/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.objects.properties.item;

import com.google.common.collect.Iterables;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.util.UUID;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.Mechanism;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.tags.Attribute;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import net.minecraft.server.v1_8_R3.GameProfileSerializer;
import net.minecraft.server.v1_8_R3.MinecraftServer;
import net.minecraft.server.v1_8_R3.NBTBase;
import net.minecraft.server.v1_8_R3.NBTTagCompound;
import org.bukkit.craftbukkit.v1_8_R3.inventory.CraftItemStack;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.SkullMeta;

public class ItemSkullskin
implements net.aufdemrand.denizencore.objects.properties.Property {
    dItem item;

    public static boolean describes(dObject item) {
        return item instanceof dItem && ((dItem)item).getItemStack().getItemMeta() instanceof SkullMeta;
    }

    public static ItemSkullskin getFrom(dObject _item) {
        if (!ItemSkullskin.describes(_item)) {
            return null;
        }
        return new ItemSkullskin((dItem)_item);
    }

    private ItemSkullskin(dItem _item) {
        this.item = _item;
    }

    public String getAttribute(Attribute attribute) {
        if (attribute == null) {
            return "null";
        }
        if (attribute.startsWith("skin")) {
            String skin = this.getPropertyString();
            if (this.item.getItemStack().getDurability() == 3 && skin != null) {
                if ((attribute = attribute.fulfill(1)).startsWith("full")) {
                    return new Element(skin).getAttribute(attribute.fulfill(1));
                }
                return new Element(CoreUtilities.split(skin, '|').get(0)).getAttribute(attribute);
            }
            dB.echoError("This skull_item does not have a skin set!");
        }
        if (attribute.startsWith("has_skin")) {
            return new Element(this.item.getItemStack().getDurability() == 3 && this.getPropertyString() != null).getAttribute(attribute.fulfill(1));
        }
        return null;
    }

    public String getPropertyString() {
        NBTTagCompound tag;
        net.minecraft.server.v1_8_R3.ItemStack itemStack;
        if (this.item.getItemStack().getDurability() == 3 && (itemStack = CraftItemStack.asNMSCopy((ItemStack)this.item.getItemStack())).hasTag() && (tag = itemStack.getTag()).hasKeyOfType("SkullOwner", 10)) {
            GameProfile profile = GameProfileSerializer.deserialize((NBTTagCompound)tag.getCompound("SkullOwner"));
            Property property = Iterables.getFirst(profile.getProperties().get((Object)"textures"), null);
            UUID uuid = profile.getId();
            return (uuid != null ? uuid : profile.getName()) + (property != null ? "|" + property.getValue() : "");
        }
        return null;
    }

    public String getPropertyId() {
        return "skull_skin";
    }

    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("skull_skin")) {
            GameProfile profile;
            if (this.item.getItemStack().getDurability() != 3) {
                this.item.getItemStack().setDurability((short)3);
            }
            dList list = mechanism.getValue().asType(dList.class);
            String idString = (String)list.get(0);
            net.minecraft.server.v1_8_R3.ItemStack itemStack = CraftItemStack.asNMSCopy((ItemStack)this.item.getItemStack());
            if (idString.contains("-")) {
                UUID uuid = UUID.fromString(idString);
                profile = new GameProfile(uuid, null);
            } else {
                profile = new GameProfile(null, idString);
            }
            profile = ItemSkullskin.fillGameProfile(profile);
            if (list.size() > 1) {
                profile.getProperties().put((Object)"textures", (Object)new Property("value", (String)list.get(1)));
            }
            NBTTagCompound tag = itemStack.hasTag() ? itemStack.getTag() : new NBTTagCompound();
            tag.set("SkullOwner", (NBTBase)GameProfileSerializer.serialize((NBTTagCompound)new NBTTagCompound(), (GameProfile)profile));
            itemStack.setTag(tag);
            this.item.setItemStack(CraftItemStack.asBukkitCopy((net.minecraft.server.v1_8_R3.ItemStack)itemStack));
        }
    }

    public static GameProfile fillGameProfile(GameProfile gameProfile) {
        if (gameProfile != null) {
            GameProfile gameProfile1 = null;
            if (gameProfile.getName() != null) {
                gameProfile1 = MinecraftServer.getServer().getUserCache().getProfile(gameProfile.getName());
            }
            if (gameProfile1 == null) {
                gameProfile1 = MinecraftServer.getServer().getUserCache().a(gameProfile.getId());
            }
            if (gameProfile1 == null) {
                gameProfile1 = gameProfile;
            }
            if (Iterables.getFirst(gameProfile1.getProperties().get((Object)"textures"), null) == null) {
                gameProfile1 = MinecraftServer.getServer().aD().fillProfileProperties(gameProfile1, true);
            }
            return gameProfile1;
        }
        return null;
    }
}

