/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.npc;

import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.objects.dNPC;
import net.aufdemrand.denizen.utilities.Utilities;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.exceptions.CommandExecutionException;
import net.aufdemrand.denizencore.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.commands.AbstractCommand;
import net.citizensnpcs.trait.Anchors;
import net.citizensnpcs.util.Anchor;
import org.bukkit.Location;

public class AnchorCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (!scriptEntry.hasObject("action") && arg.matchesEnum(Action.values())) {
                scriptEntry.addObject("action", (Object)Action.valueOf(arg.getValue().toUpperCase()));
                continue;
            }
            if (!scriptEntry.hasObject("range") && arg.matchesPrimitive(aH.PrimitiveType.Double) && arg.matchesPrefix("range", "r")) {
                scriptEntry.addObject("range", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("id") && arg.matchesPrefix("id", "i")) {
                scriptEntry.addObject("id", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("location") && arg.matchesArgumentType(dLocation.class)) {
                scriptEntry.addObject("location", arg.asType(dLocation.class));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!((BukkitScriptEntryData)scriptEntry.entryData).hasNPC()) {
            throw new InvalidArgumentsException("NPC linked was missing or invalid.");
        }
        if (!scriptEntry.hasObject("action")) {
            throw new InvalidArgumentsException("Must specify an 'Anchor Action'. Valid: " + Action.values());
        }
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        Action action = (Action)((Object)scriptEntry.getObject("action"));
        dLocation location = (dLocation)scriptEntry.getObject("location");
        Element range = (Element)scriptEntry.getObject("range");
        Element id = (Element)scriptEntry.getObject("id");
        dB.report(scriptEntry, this.getName(), aH.debugObj("NPC", ((BukkitScriptEntryData)scriptEntry.entryData).getNPC().toString()) + action.name() + id.debug() + (location != null ? location.debug() : "") + (range != null ? range.debug() : ""));
        dNPC npc = ((BukkitScriptEntryData)scriptEntry.entryData).getNPC();
        if (!npc.getCitizen().hasTrait(Anchors.class)) {
            npc.getCitizen().addTrait(Anchors.class);
        }
        switch (action) {
            case ADD: {
                ((Anchors)npc.getCitizen().getTrait(Anchors.class)).addAnchor(id.asString(), (Location)location);
                return;
            }
            case ASSUME: {
                Anchor n = ((Anchors)npc.getCitizen().getTrait(Anchors.class)).getAnchor(id.asString());
                if (n == null) {
                    dB.echoError(scriptEntry.getResidingQueue(), "Invalid anchor name '" + id.asString() + "'");
                } else {
                    npc.getEntity().teleport(n.getLocation());
                }
                return;
            }
            case WALKNEAR: {
                Anchor n = ((Anchors)npc.getCitizen().getTrait(Anchors.class)).getAnchor(id.asString());
                if (n == null) {
                    dB.echoError(scriptEntry.getResidingQueue(), "Invalid anchor name '" + id.asString() + "'");
                } else if (range == null) {
                    dB.echoError(scriptEntry.getResidingQueue(), "Must specify a range!");
                } else {
                    npc.getNavigator().setTarget(Utilities.getWalkableLocationNear(n.getLocation(), range.asInt()));
                }
                return;
            }
            case WALKTO: {
                Anchor n = ((Anchors)npc.getCitizen().getTrait(Anchors.class)).getAnchor(id.asString());
                if (n == null) {
                    dB.echoError(scriptEntry.getResidingQueue(), "Invalid anchor name '" + id.asString() + "'");
                } else {
                    npc.getNavigator().setTarget(n.getLocation());
                }
                return;
            }
            case REMOVE: {
                Anchor n = ((Anchors)npc.getCitizen().getTrait(Anchors.class)).getAnchor(id.asString());
                if (n == null) {
                    dB.echoError(scriptEntry.getResidingQueue(), "Invalid anchor name '" + id.asString() + "'");
                    break;
                }
                ((Anchors)npc.getCitizen().getTrait(Anchors.class)).removeAnchor(n);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Action {
        ADD,
        REMOVE,
        ASSUME,
        WALKTO,
        WALKNEAR;

    }
}

