/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.tags.core;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.aufdemrand.denizen.Denizen;
import net.aufdemrand.denizen.Settings;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.tags.BukkitTagContext;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.tags.Attribute;
import net.aufdemrand.denizencore.tags.ReplaceableTagEvent;
import net.aufdemrand.denizencore.tags.TagManager;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.plugin.Plugin;

public class PlayerTags
implements Listener {
    public static Map<String, List<String>> playerChatHistory = new ConcurrentHashMap<String, List<String>>(8, 0.9f, 2);

    public PlayerTags(Denizen denizen) {
        denizen.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)denizen);
        TagManager.registerTagEvents(this);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void addMessage(final AsyncPlayerChatEvent event) {
        final int maxSize = Settings.chatHistoryMaxMessages();
        if (maxSize > 0) {
            Bukkit.getScheduler().runTaskLater((Plugin)DenizenAPI.getCurrentInstance(), new Runnable(){

                public void run() {
                    List<String> history = playerChatHistory.get(event.getPlayer().getName());
                    if (history == null) {
                        history = new ArrayList<String>();
                    }
                    if (history.size() > maxSize) {
                        history.remove(maxSize - 1);
                    }
                    history.add(0, event.getMessage());
                    playerChatHistory.put(event.getPlayer().getName(), history);
                }
            }, 1L);
        }
    }

    @TagManager.TagEvents
    public void playerTags(ReplaceableTagEvent event) {
        if (!event.matches("player", "pl") || event.replaced()) {
            return;
        }
        Attribute attribute = event.getAttributes();
        dPlayer p = ((BukkitTagContext)event.getContext()).player;
        if (attribute.hasContext(1)) {
            p = dPlayer.valueOf(attribute.getContext(1));
        }
        if (p == null || !p.isValid()) {
            if (!event.hasAlternative()) {
                dB.echoError("Invalid or missing player for tag <" + event.raw_tag + ">!");
            }
            return;
        }
        event.setReplaced(p.getAttribute(attribute.fulfill(1)));
    }
}

