/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.utilities.maps;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.utilities.maps.MapObject;
import net.aufdemrand.denizencore.objects.aH;
import org.bukkit.map.MapCanvas;
import org.bukkit.map.MapCursor;
import org.bukkit.map.MapView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapCursor
extends MapObject {
    protected String directionTag;
    protected String typeTag;
    protected Map<UUID, org.bukkit.map.MapCursor> cursors = new HashMap<UUID, org.bukkit.map.MapCursor>();

    public MapCursor(String xTag, String yTag, String visibilityTag, boolean debug, String directionTag, String typeTag) {
        super(xTag, yTag, visibilityTag, debug);
        this.directionTag = directionTag;
        this.typeTag = typeTag;
    }

    public byte getDirection(dPlayer player) {
        return this.yawToDirection(aH.getDoubleFrom(this.tag(this.directionTag, player)));
    }

    public MapCursor.Type getType(dPlayer player) {
        return MapCursor.Type.valueOf((String)this.tag(this.typeTag, player).toUpperCase());
    }

    private byte yawToDirection(double yaw) {
        return (byte)(Math.floor(yaw / 22.5 + 0.5) % 16.0);
    }

    @Override
    public void update(dPlayer player, UUID uuid) {
        super.update(player, uuid);
        if (this.cursors.containsKey(uuid)) {
            org.bukkit.map.MapCursor cursor = this.cursors.get(uuid);
            cursor.setX((byte)this.getX(player, uuid));
            cursor.setY((byte)this.getY(player, uuid));
            cursor.setVisible(this.isVisibleTo(player, uuid));
            cursor.setDirection(this.getDirection(player));
            cursor.setType(this.getType(player));
        }
    }

    @Override
    public Map<String, Object> getSaveData() {
        Map<String, Object> data = super.getSaveData();
        data.put("type", "CURSOR");
        data.put("direction", this.directionTag);
        data.put("cursor", this.typeTag);
        return data;
    }

    @Override
    public void render(MapView mapView, MapCanvas mapCanvas, dPlayer player, UUID uuid) {
        if (!this.cursors.containsKey(uuid)) {
            org.bukkit.map.MapCursor cursor = new org.bukkit.map.MapCursor((byte)this.getX(player, uuid), (byte)this.getY(player, uuid), this.getDirection(player), this.getType(player).getValue(), this.isVisibleTo(player, uuid));
            mapCanvas.getCursors().addCursor(cursor);
            this.cursors.put(uuid, cursor);
        }
    }
}

