/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.utilities.packets;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizen.utilities.packets.PacketHelper;
import net.minecraft.server.v1_8_R3.DataWatcher;
import net.minecraft.server.v1_8_R3.Packet;
import net.minecraft.server.v1_8_R3.PacketPlayInClientCommand;
import net.minecraft.server.v1_8_R3.PacketPlayOutEntityDestroy;
import net.minecraft.server.v1_8_R3.PacketPlayOutEntityMetadata;
import net.minecraft.server.v1_8_R3.PacketPlayOutEntityTeleport;
import net.minecraft.server.v1_8_R3.PacketPlayOutSpawnEntityLiving;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class BossHealthBar {
    public static final int ENTITY_ID = 1234567;
    private static HashMap<String, Boolean> hasHealthBar = new HashMap();
    private static ArrayList<Player> playersWithHealthBar = new ArrayList();
    private static final Field spawn_entityId;
    private static final Field spawn_entityType;
    private static final Field spawn_locationX;
    private static final Field spawn_locationY;
    private static final Field spawn_locationZ;
    private static final Field spawn_velocityX;
    private static final Field spawn_velocityY;
    private static final Field spawn_velocityZ;
    private static final Field spawn_yaw;
    private static final Field spawn_pitch;
    private static final Field spawn_headPitch;
    private static final Field spawn_data;
    private static final Field destroy_entityList;
    private static final Field metadata_entityId;
    private static final Field metadata_data;
    private static final Field ccommand_command;
    private static final Field teleport_entityId;
    private static final Field teleport_x;
    private static final Field teleport_y;
    private static final Field teleport_z;
    private static final Field teleport_yaw;
    private static final Field teleport_pitch;
    private static final Field teleport_onGround;
    private static final HashSet<Material> ignoreAllBlocks;
    private static final BukkitTask task;

    public static PacketPlayOutSpawnEntityLiving getMobPacket(String text, Location loc, int health) {
        PacketPlayOutSpawnEntityLiving mobPacket = new PacketPlayOutSpawnEntityLiving();
        try {
            spawn_entityId.set(mobPacket, 1234567);
            spawn_entityType.set(mobPacket, (byte)EntityType.WITHER.getTypeId());
            spawn_locationX.set(mobPacket, (int)Math.floor((double)loc.getBlockX() * 32.0));
            spawn_locationY.set(mobPacket, -8192);
            spawn_locationZ.set(mobPacket, (int)Math.floor((double)loc.getBlockZ() * 32.0));
            spawn_velocityX.set(mobPacket, (byte)0);
            spawn_velocityY.set(mobPacket, (byte)0);
            spawn_velocityZ.set(mobPacket, (byte)0);
            spawn_yaw.set(mobPacket, (byte)0);
            spawn_pitch.set(mobPacket, (byte)0);
            spawn_headPitch.set(mobPacket, (byte)0);
            spawn_data.set(mobPacket, BossHealthBar.getWatcher(text, health));
        }
        catch (Exception e) {
            dB.echoError(e);
        }
        return mobPacket;
    }

    public static PacketPlayOutEntityDestroy getDestroyEntityPacket() {
        PacketPlayOutEntityDestroy destroyPacket = new PacketPlayOutEntityDestroy();
        try {
            destroy_entityList.set(destroyPacket, new int[]{1234567});
        }
        catch (Exception e) {
            dB.echoError(e);
        }
        return destroyPacket;
    }

    public static PacketPlayOutEntityMetadata getMetadataPacket(DataWatcher watcher) {
        PacketPlayOutEntityMetadata metaPacket = new PacketPlayOutEntityMetadata();
        try {
            metadata_entityId.set(metaPacket, 1234567);
            metadata_data.set(metaPacket, watcher.c());
        }
        catch (Exception e) {
            dB.echoError(e);
        }
        return metaPacket;
    }

    public static PacketPlayOutEntityTeleport getTeleportPacket(Location location) {
        PacketPlayOutEntityTeleport teleportPacket = new PacketPlayOutEntityTeleport();
        try {
            teleport_entityId.set(teleportPacket, 1234567);
            teleport_x.set(teleportPacket, (int)Math.floor((double)location.getBlockX() * 32.0));
            teleport_y.set(teleportPacket, (int)Math.floor((double)location.getBlockY() * 32.0));
            teleport_z.set(teleportPacket, (int)Math.floor((double)location.getBlockZ() * 32.0));
            teleport_yaw.set(teleportPacket, (byte)0);
            teleport_pitch.set(teleportPacket, (byte)0);
            teleport_onGround.set(teleportPacket, false);
        }
        catch (Exception e) {
            dB.echoError(e);
        }
        return teleportPacket;
    }

    public static PacketPlayInClientCommand getRespawnPacket() {
        PacketPlayInClientCommand ccommandPacket = new PacketPlayInClientCommand();
        try {
            ccommand_command.set(ccommandPacket, PacketPlayInClientCommand.EnumClientCommand.PERFORM_RESPAWN);
        }
        catch (Exception e) {
            dB.echoError(e);
        }
        return ccommandPacket;
    }

    public static DataWatcher getWatcher(String text, int health) {
        DataWatcher watcher = new DataWatcher(null);
        watcher.a(0, (Object)32);
        watcher.a(2, (Object)text);
        watcher.a(3, (Object)1);
        watcher.a(6, (Object)Float.valueOf((float)health * 1.5f));
        return watcher;
    }

    public static void displayTextBar(String text, Player player, int health) {
        PacketPlayOutSpawnEntityLiving mobPacket = BossHealthBar.getMobPacket(text, player.getLocation(), health);
        PacketHelper.sendPacket(player, (Packet)mobPacket);
        hasHealthBar.put(player.getName(), true);
        playersWithHealthBar.add(player);
    }

    public static void removeTextBar(Player player) {
        if (hasHealthBar.containsKey(player.getName())) {
            PacketPlayOutEntityDestroy destroyEntityPacket = BossHealthBar.getDestroyEntityPacket();
            PacketHelper.sendPacket(player, (Packet)destroyEntityPacket);
            hasHealthBar.put(player.getName(), false);
            playersWithHealthBar.remove(player);
        }
    }

    public static void displayLoadingBar(final String text, final String completeText, final Player player, final int healthAdd, long delay, final boolean loadUp) {
        PacketPlayOutSpawnEntityLiving mobPacket = BossHealthBar.getMobPacket(text, player.getLocation(), 200);
        PacketHelper.sendPacket(player, (Packet)mobPacket);
        hasHealthBar.put(player.getName(), true);
        playersWithHealthBar.add(player);
        new BukkitRunnable(){
            int health;
            {
                this.health = loadUp ? 0 : 300;
            }

            public void run() {
                if (loadUp ? this.health < 300 : this.health > 0) {
                    DataWatcher watcher = BossHealthBar.getWatcher(text, this.health);
                    PacketPlayOutEntityMetadata metaPacket = BossHealthBar.getMetadataPacket(watcher);
                    PacketHelper.sendPacket(player, (Packet)metaPacket);
                    this.health = loadUp ? (this.health += healthAdd) : (this.health -= healthAdd);
                } else {
                    DataWatcher watcher = BossHealthBar.getWatcher(text, loadUp ? 300 : 0);
                    PacketPlayOutEntityMetadata metaPacket = BossHealthBar.getMetadataPacket(watcher);
                    PacketPlayOutEntityDestroy destroyEntityPacket = BossHealthBar.getDestroyEntityPacket();
                    PacketHelper.sendPacket(player, (Packet)metaPacket);
                    PacketHelper.sendPacket(player, (Packet)destroyEntityPacket);
                    hasHealthBar.put(player.getName(), false);
                    playersWithHealthBar.remove(player);
                    PacketPlayOutSpawnEntityLiving mobPacket = BossHealthBar.getMobPacket(completeText, player.getLocation(), 200);
                    PacketHelper.sendPacket(player, (Packet)mobPacket);
                    hasHealthBar.put(player.getName(), true);
                    playersWithHealthBar.add(player);
                    DataWatcher watcher2 = BossHealthBar.getWatcher(completeText, 300);
                    PacketPlayOutEntityMetadata metaPacket2 = BossHealthBar.getMetadataPacket(watcher2);
                    PacketHelper.sendPacket(player, (Packet)metaPacket2);
                    new BukkitRunnable(){

                        public void run() {
                            PacketPlayOutEntityDestroy destroyEntityPacket = BossHealthBar.getDestroyEntityPacket();
                            PacketHelper.sendPacket(player, (Packet)destroyEntityPacket);
                            hasHealthBar.put(player.getName(), false);
                            playersWithHealthBar.remove(player);
                        }
                    }.runTaskLater((Plugin)DenizenAPI.getCurrentInstance(), 40L);
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)DenizenAPI.getCurrentInstance(), delay, delay);
    }

    public static void displayLoadingBar(String text, String completeText, Player player, int secondsDelay, boolean loadUp) {
        int healthChangePerSecond = 300 / secondsDelay;
        BossHealthBar.displayLoadingBar(text, completeText, player, healthChangePerSecond, 20L, loadUp);
    }

    static {
        ignoreAllBlocks = new HashSet<Material>(EnumSet.allOf(Material.class));
        task = new BukkitRunnable(){

            public void run() {
                for (int i = 0; i < playersWithHealthBar.size(); ++i) {
                    Player player = (Player)playersWithHealthBar.get(i);
                    if (!player.isDead() && player.isValid()) {
                        PacketHelper.sendPacket(player, (Packet)BossHealthBar.getTeleportPacket(player.getLocation().clone().add(player.getLocation().getDirection().multiply(30))));
                        continue;
                    }
                    hasHealthBar.put(player.getName(), false);
                    playersWithHealthBar.remove(player);
                }
            }
        }.runTaskTimer((Plugin)DenizenAPI.getCurrentInstance(), 20L, 20L);
        Map<String, Field> fields = PacketHelper.registerFields(PacketPlayOutSpawnEntityLiving.class);
        spawn_entityId = fields.get("a");
        spawn_entityType = fields.get("b");
        spawn_locationX = fields.get("c");
        spawn_locationY = fields.get("d");
        spawn_locationZ = fields.get("e");
        spawn_velocityX = fields.get("f");
        spawn_velocityY = fields.get("g");
        spawn_velocityZ = fields.get("h");
        spawn_yaw = fields.get("i");
        spawn_pitch = fields.get("j");
        spawn_headPitch = fields.get("k");
        spawn_data = fields.get("l");
        fields = PacketHelper.registerFields(PacketPlayOutEntityDestroy.class);
        destroy_entityList = fields.get("a");
        fields = PacketHelper.registerFields(PacketPlayOutEntityMetadata.class);
        metadata_entityId = fields.get("a");
        metadata_data = fields.get("b");
        fields = PacketHelper.registerFields(PacketPlayInClientCommand.class);
        ccommand_command = fields.get("a");
        fields = PacketHelper.registerFields(PacketPlayOutEntityTeleport.class);
        teleport_entityId = fields.get("a");
        teleport_x = fields.get("b");
        teleport_y = fields.get("c");
        teleport_z = fields.get("d");
        teleport_yaw = fields.get("e");
        teleport_pitch = fields.get("f");
        teleport_onGround = fields.get("g");
    }
}

