/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizencore.objects;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.aufdemrand.denizencore.objects.CustomObject;
import net.aufdemrand.denizencore.objects.Duration;
import net.aufdemrand.denizencore.objects.Fetchable;
import net.aufdemrand.denizencore.objects.ObjectFetcher;
import net.aufdemrand.denizencore.objects.TagRunnable;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.objects.dScript;
import net.aufdemrand.denizencore.objects.properties.Property;
import net.aufdemrand.denizencore.objects.properties.PropertyParser;
import net.aufdemrand.denizencore.scripts.queues.ScriptQueue;
import net.aufdemrand.denizencore.tags.Attribute;
import net.aufdemrand.denizencore.tags.TagContext;
import net.aufdemrand.denizencore.tags.TagManager;
import net.aufdemrand.denizencore.tags.core.EscapeTags;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import net.aufdemrand.denizencore.utilities.SQLEscaper;
import net.aufdemrand.denizencore.utilities.debugging.Debuggable;
import net.aufdemrand.denizencore.utilities.debugging.dB;

public class Element
implements dObject {
    public static final Element TRUE = new Element(Boolean.TRUE);
    public static final Element FALSE = new Element(Boolean.FALSE);
    public static final Element SERVER = new Element("server");
    public static final Element NULL = new Element("null");
    static final Pattern VALUE_PATTERN = Pattern.compile("el@val(?:ue)?\\[([^\\[\\]]+)\\].*", 42);
    private final String element;
    static final BigDecimal max = new BigDecimal("10E1000");
    private String prefix;
    public static HashMap<String, TagRunnable> registeredTags = new HashMap();

    public static Element valueOf(String string) {
        return Element.valueOf(string, null);
    }

    @Fetchable(value="el")
    public static Element valueOf(String string, TagContext context) {
        if (string == null) {
            return null;
        }
        Matcher m = VALUE_PATTERN.matcher(string);
        if (m.matches()) {
            String value = m.group(1);
            return new Element(value);
        }
        return new Element(string.toLowerCase().startsWith("el@") ? string.substring(3) : string);
    }

    public static boolean matches(String string) {
        return string != null;
    }

    public static dObject handleNull(String tag, dObject object, String type, boolean has_fallback) {
        if (object == null) {
            if (!has_fallback) {
                dB.echoError("'" + tag + "' is an invalid " + type + "!");
            }
            return null;
        }
        return object;
    }

    public Element(String string) {
        this.prefix = "element";
        this.element = string == null ? "null" : TagManager.cleanOutputFully(string);
    }

    public Element(Boolean bool) {
        this.prefix = "boolean";
        this.element = String.valueOf(bool);
    }

    public Element(Integer integer) {
        this.prefix = "integer";
        this.element = String.valueOf(integer);
    }

    public Element(Byte byt) {
        this.prefix = "byte";
        this.element = String.valueOf(byt);
    }

    public Element(Short shrt) {
        this.prefix = "short";
        this.element = String.valueOf(shrt);
    }

    public Element(Long lng) {
        this.prefix = "long";
        this.element = String.valueOf(lng);
    }

    public Element(Double dbl) {
        this.prefix = "double";
        this.element = String.valueOf(dbl);
    }

    public Element(Float flt) {
        this.prefix = "float";
        this.element = String.valueOf(flt);
    }

    public Element(String prefix, String string) {
        this.prefix = prefix == null ? "element" : prefix;
        this.element = TagManager.cleanOutputFully(string);
    }

    private BigDecimal getBD(String text) {
        BigDecimal bd = new BigDecimal(text);
        if (bd.compareTo(max) >= 1) {
            dB.echoError("Unreasonably large number detected!");
            return max;
        }
        return bd;
    }

    public BigDecimal asBigDecimal() {
        return this.getBD(this.element.replaceAll("%", ""));
    }

    public double asDouble() {
        return Double.valueOf(this.element.replaceAll("%", ""));
    }

    public float asFloat() {
        return Float.valueOf(this.element.replaceAll("%", "")).floatValue();
    }

    public int asInt() {
        try {
            return Integer.valueOf(this.element.replaceAll("(%)|(\\.\\d+)", ""));
        }
        catch (NumberFormatException ex) {
            dB.echoError("'" + this.element + "' is not a valid integer!");
            return 0;
        }
    }

    public long asLong() {
        try {
            return Long.valueOf(this.element.replaceAll("(%)|(\\.\\d+)", ""));
        }
        catch (NumberFormatException ex) {
            dB.echoError("'" + this.element + "' is not a valid integer!");
            return 0L;
        }
    }

    public boolean asBoolean() {
        return Boolean.valueOf(this.element.replaceAll("el@", ""));
    }

    public String asString() {
        return this.element;
    }

    public boolean isBoolean() {
        return this.element != null && (this.element.equalsIgnoreCase("true") || this.element.equalsIgnoreCase("false"));
    }

    public boolean isDouble() {
        try {
            if (Double.valueOf(this.element) != null) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean isFloat() {
        try {
            if (Float.valueOf(this.element) != null) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean isInt() {
        try {
            if (Integer.valueOf(this.element.replaceAll("(%)|(\\.\\d+)", "")) != null) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean isString() {
        return this.element != null && !this.element.isEmpty();
    }

    public boolean matchesType(Class<? extends dObject> dClass) {
        return ObjectFetcher.checkMatch(dClass, this.element);
    }

    public <T extends dObject> T asType(Class<T> dClass) {
        return ObjectFetcher.getObjectFrom(dClass, this.element);
    }

    public boolean matchesEnum(Enum[] values) {
        for (Enum value : values) {
            if (!value.name().equalsIgnoreCase(this.element)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getObjectType() {
        return "Element";
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public dObject setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    @Override
    public String debug() {
        return this.prefix + "='<A>" + this.identify() + "<G>'  ";
    }

    @Override
    public String identify() {
        return this.element;
    }

    @Override
    public String identifySimple() {
        return this.identify();
    }

    public String toString() {
        return this.identify();
    }

    @Override
    public boolean isUnique() {
        return false;
    }

    public static void registerTags() {
        Element.registerTag("as_boolean", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                String element = ((Element)object).element;
                return new Element(element.equalsIgnoreCase("true") || element.equalsIgnoreCase("t") || element.equalsIgnoreCase("1")).getAttribute(attribute.fulfill(1));
            }
        });
        Element.registerTag("asboolean", registeredTags.get("as_boolean"));
        Element.registerTag("as_decimal", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                String element = ((Element)object).element;
                try {
                    return new Element(Double.valueOf(element)).getAttribute(attribute.fulfill(1));
                }
                catch (NumberFormatException e) {
                    if (!attribute.hasAlternative()) {
                        dB.echoError("'" + element + "' is not a valid decimal number.");
                    }
                    return null;
                }
            }
        });
        Element.registerTag("as_double", registeredTags.get("as_decimal"));
        Element.registerTag("asdouble", registeredTags.get("as_decimal"));
        Element.registerTag("as_int", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                String element = ((Element)object).element;
                try {
                    return new Element(Math.round(Double.valueOf(element))).getAttribute(attribute.fulfill(1));
                }
                catch (NumberFormatException e) {
                    if (!attribute.hasAlternative()) {
                        dB.echoError("'" + element + "' is not a valid number.");
                    }
                    return null;
                }
            }
        });
        Element.registerTag("asint", registeredTags.get("as_int"));
        Element.registerTag("as_money", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                String element = ((Element)object).element;
                try {
                    DecimalFormat d = new DecimalFormat("0.00");
                    return new Element(d.format(Double.valueOf(element))).getAttribute(attribute.fulfill(1));
                }
                catch (NumberFormatException e) {
                    if (!attribute.hasAlternative()) {
                        dB.echoError("'" + element + "' is not a valid decimal number.");
                    }
                    return null;
                }
            }
        });
        Element.registerTag("asmoney", registeredTags.get("as_money"));
        Element.registerTag("as_list", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                String element = ((Element)object).element;
                dObject obj = Element.handleNull(element, dList.valueOf(element), "dList", attribute.hasAlternative());
                if (obj != null) {
                    return obj.getAttribute(attribute.fulfill(1));
                }
                return null;
            }
        });
        Element.registerTag("aslist", registeredTags.get("as_list"));
        Element.registerTag("as_custom", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                String element = ((Element)object).element;
                dObject obj = Element.handleNull(element, CustomObject.valueOf(element, null), "Custom", attribute.hasAlternative());
                if (obj != null) {
                    return obj.getAttribute(attribute.fulfill(1));
                }
                return null;
            }
        });
        Element.registerTag("ascustom", registeredTags.get("as_custom"));
        Element.registerTag("as_script", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                String element = ((Element)object).element;
                dObject obj = Element.handleNull(element, dScript.valueOf(element), "dScript", attribute.hasAlternative());
                if (obj != null) {
                    return obj.getAttribute(attribute.fulfill(1));
                }
                return null;
            }
        });
        Element.registerTag("asscript", registeredTags.get("as_script"));
        Element.registerTag("as_queue", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                String element = ((Element)object).element;
                dObject obj = Element.handleNull(element, ScriptQueue.valueOf(element), "ScriptQueue", attribute.hasAlternative());
                if (obj != null) {
                    return obj.getAttribute(attribute.fulfill(1));
                }
                return null;
            }
        });
        Element.registerTag("asqueue", registeredTags.get("as_queue"));
        Element.registerTag("as_duration", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                String element = ((Element)object).element;
                dObject obj = Element.handleNull(element, Duration.valueOf(element), "Duration", attribute.hasAlternative());
                if (obj != null) {
                    return obj.getAttribute(attribute.fulfill(1));
                }
                return null;
            }
        });
        Element.registerTag("asduration", registeredTags.get("as_duration"));
        Element.registerTag("escaped", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                String element = ((Element)object).element;
                return new Element(EscapeTags.Escape(element)).getAttribute(attribute.fulfill(1));
            }
        });
        Element.registerTag("sql_escaped", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                String element = ((Element)object).element;
                return new Element(SQLEscaper.escapeSQL(element)).getAttribute(attribute.fulfill(1));
            }
        });
        Element.registerTag("unescaped", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                String element = ((Element)object).element;
                return new Element(EscapeTags.unEscape(element)).getAttribute(attribute.fulfill(1));
            }
        });
        Element.registerTag("debug", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                return new Element(object.debug()).getAttribute(attribute.fulfill(1));
            }
        });
        Element.registerTag("prefix", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                return new Element(object.getPrefix()).getAttribute(attribute.fulfill(1));
            }
        });
        Element.registerTag("contains_any_case_sensitive", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                String element = ((Element)object).element;
                dList list = dList.valueOf(attribute.getContext(1));
                for (String list_element : list) {
                    if (!element.contains(list_element)) continue;
                    return TRUE.getAttribute(attribute.fulfill(1));
                }
                return FALSE.getAttribute(attribute.fulfill(1));
            }
        });
        TagRunnable r = registeredTags.get("contains_any_case_sensitive").clone();
        r.name = null;
        Element.registerTag("contains_any_case_sensitive_text", r);
        Element.registerTag("contains_any", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                String element = ((Element)object).element;
                dList list = dList.valueOf(CoreUtilities.toLowerCase(attribute.getContext(1)));
                String ellow = CoreUtilities.toLowerCase(element);
                for (String list_element : list) {
                    if (!ellow.contains(list_element)) continue;
                    return TRUE.getAttribute(attribute.fulfill(1));
                }
                return FALSE.getAttribute(attribute.fulfill(1));
            }
        });
        r = registeredTags.get("contains_any").clone();
        r.name = null;
        Element.registerTag("contains_any_text", r);
        Element.registerTag("contains_case_sensitive", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                String contains;
                String element = ((Element)object).element;
                if (element.contains(contains = attribute.getContext(1))) {
                    return new Element("true").getAttribute(attribute.fulfill(1));
                }
                return new Element("false").getAttribute(attribute.fulfill(1));
            }
        });
        r = registeredTags.get("contains_case_sensitive").clone();
        r.name = null;
        Element.registerTag("contains_case_sensitive_text", r);
        Element.registerTag("contains", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                String element = ((Element)object).element;
                String contains = attribute.getContext(1);
                if (contains.toLowerCase().startsWith("regex:")) {
                    if (Pattern.compile(contains.substring("regex:".length()), 2).matcher(element).matches()) {
                        return new Element("true").getAttribute(attribute.fulfill(1));
                    }
                    return new Element("false").getAttribute(attribute.fulfill(1));
                }
                if (element.toLowerCase().contains(contains.toLowerCase())) {
                    return new Element("true").getAttribute(attribute.fulfill(1));
                }
                return new Element("false").getAttribute(attribute.fulfill(1));
            }
        });
        r = registeredTags.get("contains").clone();
        r.name = null;
        Element.registerTag("contains_text", r);
    }

    public static void registerTag(String name, TagRunnable runnable) {
        if (runnable.name == null) {
            runnable.name = name;
        }
        registeredTags.put(name, runnable);
    }

    @Override
    public String getAttribute(Attribute attribute) {
        String returned;
        if (attribute == null) {
            return null;
        }
        String attrLow = CoreUtilities.toLowerCase(attribute.getAttributeWithoutContext(1));
        TagRunnable tr = registeredTags.get(attrLow);
        if (tr != null) {
            if (!tr.name.equals(attrLow)) {
                dB.echoError(attribute.getScriptEntry() != null ? attribute.getScriptEntry().getResidingQueue() : null, "Using deprecated form of tag '" + tr.name + "': '" + attrLow + "'.");
            }
            return tr.run(attribute, this);
        }
        if (attribute.startsWith("ends_with") || attribute.startsWith("endswith")) {
            return new Element(this.element.toLowerCase().endsWith(attribute.getContext(1).toLowerCase())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("equals_case_sensitive") && attribute.hasContext(1)) {
            return new Element(this.element.equals(attribute.getContext(1))).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("matches") && attribute.hasContext(1)) {
            return new Element(this.element.matches(attribute.getContext(1))).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("regex") && attribute.hasContext(1) && attribute.hasContext(2)) {
            String regex = attribute.getContext(1);
            Matcher m = Pattern.compile(regex).matcher(this.element);
            if (!m.matches()) {
                return null;
            }
            int group = new Element(attribute.getContext(2)).asInt();
            if (group < 0) {
                group = 0;
            }
            if (group > m.groupCount()) {
                group = m.groupCount();
            }
            return new Element(m.group(group)).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("length")) {
            return new Element(this.element.length()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("not")) {
            return new Element(!this.element.equalsIgnoreCase("true")).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("and") && attribute.hasContext(1)) {
            return new Element(this.element.equalsIgnoreCase("true") && attribute.getContext(1).equalsIgnoreCase("true")).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("or") && attribute.hasContext(1)) {
            return new Element(this.element.equalsIgnoreCase("true") || attribute.getContext(1).equalsIgnoreCase("true")).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("xor") && attribute.hasContext(1)) {
            return new Element(this.element.equalsIgnoreCase("true") != attribute.getContext(1).equalsIgnoreCase("true")).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("equals_with_case") && attribute.hasContext(1)) {
            return new Element(this.element.equals(attribute.getContext(1))).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("starts_with") || attribute.startsWith("startswith")) {
            return new Element(this.element.toLowerCase().startsWith(attribute.getContext(1).toLowerCase())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("index_of") && attribute.hasContext(1)) {
            return new Element(this.element.toLowerCase().indexOf(attribute.getContext(1).toLowerCase()) + 1).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("last_index_of") && attribute.hasContext(1)) {
            return new Element(this.element.toLowerCase().lastIndexOf(attribute.getContext(1).toLowerCase()) + 1).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("char_at") && attribute.hasContext(1)) {
            int index = attribute.getIntContext(1) - 1;
            if (index < 0 || index >= this.element.length()) {
                return null;
            }
            return new Element(String.valueOf(this.element.charAt(index))).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("after_last") && attribute.hasContext(1)) {
            String delimiter = attribute.getContext(1);
            if (this.element.toLowerCase().contains(delimiter.toLowerCase())) {
                return new Element(this.element.substring(this.element.toLowerCase().lastIndexOf(delimiter.toLowerCase()) + delimiter.length())).getAttribute(attribute.fulfill(1));
            }
            return new Element("").getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("after") && attribute.hasContext(1)) {
            String delimiter = attribute.getContext(1);
            if (this.element.toLowerCase().contains(delimiter.toLowerCase())) {
                return new Element(this.element.substring(this.element.toLowerCase().indexOf(delimiter.toLowerCase()) + delimiter.length())).getAttribute(attribute.fulfill(1));
            }
            return new Element("").getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("before_last") && attribute.hasContext(1)) {
            String delimiter = attribute.getContext(1);
            if (this.element.toLowerCase().contains(delimiter.toLowerCase())) {
                return new Element(this.element.substring(0, this.element.toLowerCase().lastIndexOf(delimiter.toLowerCase()))).getAttribute(attribute.fulfill(1));
            }
            return new Element(this.element).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("before") && attribute.hasContext(1)) {
            String delimiter = attribute.getContext(1);
            if (this.element.toLowerCase().contains(delimiter.toLowerCase())) {
                return new Element(this.element.substring(0, this.element.toLowerCase().indexOf(delimiter.toLowerCase()))).getAttribute(attribute.fulfill(1));
            }
            return new Element(this.element).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("replace") && attribute.hasContext(1)) {
            String replace = attribute.getContext(1);
            String replacement = "";
            attribute.fulfill(1);
            if (attribute.startsWith("with") && attribute.hasContext(1)) {
                replacement = attribute.getContext(1);
                if (replacement == null) {
                    replacement = "";
                }
                attribute.fulfill(1);
            }
            if (replace.startsWith("regex:")) {
                return new Element(this.element.replaceAll(replace.substring("regex:".length()), replacement)).getAttribute(attribute);
            }
            if (replace.startsWith("firstregex:")) {
                return new Element(this.element.replaceFirst(replace.substring("firstregex:".length()), replacement)).getAttribute(attribute);
            }
            return new Element(this.element.replaceAll("(?i)" + Pattern.quote(replace), replacement)).getAttribute(attribute);
        }
        if (attribute.startsWith("split") && attribute.startsWith("limit", 2)) {
            String split_string = attribute.hasContext(1) ? attribute.getContext(1) : " ";
            Integer limit = attribute.hasContext(2) ? attribute.getIntContext(2) : 1;
            if (split_string.toLowerCase().startsWith("regex:")) {
                return new dList(Arrays.asList(this.element.split(split_string.split(":", 2)[1], limit))).getAttribute(attribute.fulfill(2));
            }
            return new dList(Arrays.asList(this.element.split("(?i)" + Pattern.quote(split_string), limit))).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("split")) {
            String split_string;
            String string = split_string = attribute.hasContext(1) ? attribute.getContext(1) : " ";
            if (split_string.toLowerCase().startsWith("regex:")) {
                return new dList(Arrays.asList(this.element.split(split_string.split(":", 2)[1]))).getAttribute(attribute.fulfill(1));
            }
            return new dList(Arrays.asList(this.element.split("(?i)" + Pattern.quote(split_string)))).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("format_number")) {
            try {
                String afterdecimal;
                String shortelement;
                int decimal = this.element.indexOf(46);
                if (decimal != -1) {
                    shortelement = this.element.substring(0, decimal);
                    afterdecimal = this.element.substring(decimal);
                } else {
                    shortelement = this.element;
                    afterdecimal = "";
                }
                String intform = Long.valueOf(shortelement.replace("%", "")).toString();
                String negative = "";
                if (intform.startsWith("-")) {
                    negative = "-";
                    intform = intform.substring(1, intform.length());
                }
                for (int i = intform.length() - 3; i > 0; i -= 3) {
                    intform = intform.substring(0, i) + "," + intform.substring(i, intform.length());
                }
                return new Element(negative + intform + afterdecimal).getAttribute(attribute.fulfill(1));
            }
            catch (Exception ex) {
                dB.echoError(ex);
            }
        }
        if (attribute.startsWith("to_list")) {
            dList list = new dList();
            for (int i = 0; i < this.element.length(); ++i) {
                list.add(String.valueOf(this.element.charAt(i)));
            }
            return list.getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("trim")) {
            return new Element(this.element.trim()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("to_uppercase") || attribute.startsWith("upper")) {
            return new Element(this.element.toUpperCase()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("to_lowercase") || attribute.startsWith("lower")) {
            return new Element(CoreUtilities.toLowerCase(this.element)).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("to_titlecase") || attribute.startsWith("totitlecase")) {
            if (this.element.length() == 0) {
                return new Element("").getAttribute(attribute.fulfill(1));
            }
            StringBuilder TitleCase = new StringBuilder(this.element.length());
            String Upper = this.element.toUpperCase();
            String Lower = this.element.toLowerCase();
            TitleCase.append(Upper.charAt(0));
            for (int i = 1; i < this.element.length(); ++i) {
                if (this.element.charAt(i - 1) == ' ') {
                    TitleCase.append(Upper.charAt(i));
                    continue;
                }
                TitleCase.append(Lower.charAt(i));
            }
            return new Element(TitleCase.toString()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("substring") || attribute.startsWith("substr")) {
            int beginning_index = new Element(attribute.getContext(1).split(",")[0]).asInt() - 1;
            int ending_index = attribute.getContext(1).split(",").length > 1 ? new Element(attribute.getContext(1).split(",")[1]).asInt() : this.element.length();
            if (beginning_index < 0) {
                beginning_index = 0;
            }
            if (beginning_index > this.element.length()) {
                beginning_index = this.element.length();
            }
            if (ending_index > this.element.length()) {
                ending_index = this.element.length();
            }
            if (ending_index < beginning_index) {
                ending_index = beginning_index;
            }
            return new Element(this.element.substring(beginning_index, ending_index)).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("pad_left") && attribute.hasContext(1)) {
            String with = String.valueOf('\u00a0');
            int length = attribute.getIntContext(1);
            if ((attribute = attribute.fulfill(1)).startsWith("with") && attribute.hasContext(1)) {
                with = String.valueOf(attribute.getContext(1).charAt(0));
                attribute = attribute.fulfill(1);
            }
            String padded = this.element;
            while (padded.length() < length) {
                padded = with + padded;
            }
            return new Element(padded).getAttribute(attribute);
        }
        if (attribute.startsWith("pad_right") && attribute.hasContext(1)) {
            String with = String.valueOf('\u00a0');
            int length = attribute.getIntContext(1);
            if ((attribute = attribute.fulfill(1)).startsWith("with") && attribute.hasContext(1)) {
                with = String.valueOf(attribute.getContext(1).charAt(0));
                attribute = attribute.fulfill(1);
            }
            StringBuilder padded = new StringBuilder(this.element);
            while (padded.length() < length) {
                padded.append(with);
            }
            return new Element(padded.toString()).getAttribute(attribute);
        }
        if (attribute.startsWith("abs")) {
            if (!this.isDouble()) {
                dB.echoError("Element '" + this.element + "' is not a valid decimal number!");
                return null;
            }
            return new Element(Math.abs(this.asDouble())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("max") && attribute.hasContext(1)) {
            if (!this.isDouble()) {
                dB.echoError("Element '" + this.element + "' is not a valid number!");
                return null;
            }
            return new Element(Math.max(this.asDouble(), new Element(attribute.getContext(1)).asDouble())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("min") && attribute.hasContext(1)) {
            if (!this.isDouble()) {
                dB.echoError("Element '" + this.element + "' is not a valid number!");
                return null;
            }
            return new Element(Math.min(this.asDouble(), new Element(attribute.getContext(1)).asDouble())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("add_int") && attribute.hasContext(1)) {
            if (!this.isDouble()) {
                dB.echoError("Element '" + this.element + "' is not a valid number!");
                return null;
            }
            return new Element(this.asLong() + aH.getLongFrom(attribute.getContext(1))).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("div_int") && attribute.hasContext(1)) {
            if (!this.isDouble()) {
                dB.echoError("Element '" + this.element + "' is not a valid decimal number!");
                return null;
            }
            return new Element(this.asLong() / aH.getLongFrom(attribute.getContext(1))).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("mul_int") && attribute.hasContext(1)) {
            if (!this.isDouble()) {
                dB.echoError("Element '" + this.element + "' is not a valid decimal number!");
                return null;
            }
            return new Element(this.asLong() * aH.getLongFrom(attribute.getContext(1))).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("sub_int") && attribute.hasContext(1)) {
            if (!this.isDouble()) {
                dB.echoError("Element '" + this.element + "' is not a valid decimal number!");
                return null;
            }
            return new Element(this.asLong() - aH.getLongFrom(attribute.getContext(1))).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("add") && attribute.hasContext(1)) {
            if (!this.isDouble()) {
                dB.echoError("Element '" + this.element + "' is not a valid decimal number!");
                return null;
            }
            try {
                return new Element(this.asBigDecimal().add(this.getBD(attribute.getContext(1))).toString()).getAttribute(attribute.fulfill(1));
            }
            catch (Throwable e) {
                return new Element(this.asDouble() + aH.getDoubleFrom(attribute.getContext(1))).getAttribute(attribute.fulfill(1));
            }
        }
        if (attribute.startsWith("div") && attribute.hasContext(1)) {
            if (!this.isDouble()) {
                dB.echoError("Element '" + this.element + "' is not a valid decimal number!");
                return null;
            }
            try {
                return new Element(this.asBigDecimal().divide(this.getBD(attribute.getContext(1))).toString()).getAttribute(attribute.fulfill(1));
            }
            catch (Exception e) {
                return new Element(this.asDouble() / aH.getDoubleFrom(attribute.getContext(1))).getAttribute(attribute.fulfill(1));
            }
        }
        if (attribute.startsWith("mod") && attribute.hasContext(1)) {
            if (!this.isDouble()) {
                dB.echoError("Element '" + this.element + "' is not a valid decimal number!");
                return null;
            }
            return new Element(this.asDouble() % aH.getDoubleFrom(attribute.getContext(1))).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("mul") && attribute.hasContext(1)) {
            if (!this.isDouble()) {
                dB.echoError("Element '" + this.element + "' is not a valid decimal number!");
                return null;
            }
            try {
                return new Element(this.asBigDecimal().multiply(this.getBD(attribute.getContext(1))).toString()).getAttribute(attribute.fulfill(1));
            }
            catch (Throwable e) {
                return new Element(this.asDouble() * aH.getDoubleFrom(attribute.getContext(1))).getAttribute(attribute.fulfill(1));
            }
        }
        if (attribute.startsWith("sub") && attribute.hasContext(1)) {
            if (!this.isDouble()) {
                dB.echoError("Element '" + this.element + "' is not a valid decimal number!");
                return null;
            }
            try {
                return new Element(this.asBigDecimal().subtract(this.getBD(attribute.getContext(1))).toString()).getAttribute(attribute.fulfill(1));
            }
            catch (Throwable e) {
                return new Element(this.asDouble() - aH.getDoubleFrom(attribute.getContext(1))).getAttribute(attribute.fulfill(1));
            }
        }
        if (attribute.startsWith("sqrt")) {
            if (!this.isDouble()) {
                dB.echoError("Element '" + this.element + "' is not a valid decimal number!");
                return null;
            }
            return new Element(Math.sqrt(this.asDouble())).getAttribute(attribute.fulfill(1));
        }
        for (Property property : PropertyParser.getProperties(this)) {
            returned = property.getAttribute(attribute);
            if (returned == null) continue;
            return returned;
        }
        if (attribute.startsWith("power") && attribute.hasContext(1)) {
            if (!this.isDouble()) {
                dB.echoError("Element '" + this.element + "' is not a valid decimal number!");
                return null;
            }
            return new Element(Math.pow(this.asDouble(), aH.getDoubleFrom(attribute.getContext(1)))).getAttribute(attribute.fulfill(1));
        }
        for (Property property : PropertyParser.getProperties(this)) {
            returned = property.getAttribute(attribute);
            if (returned == null) continue;
            return returned;
        }
        if (attribute.startsWith("asin")) {
            if (!this.isDouble()) {
                dB.echoError("Element '" + this.element + "' is not a valid decimal number!");
                return null;
            }
            return new Element(Math.asin(this.asDouble())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("acos")) {
            if (!this.isDouble()) {
                dB.echoError("Element '" + this.element + "' is not a valid decimal number!");
                return null;
            }
            return new Element(Math.acos(this.asDouble())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("atan")) {
            if (!this.isDouble()) {
                dB.echoError("Element '" + this.element + "' is not a valid decimal number!");
                return null;
            }
            return new Element(Math.atan(this.asDouble())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("cos")) {
            if (!this.isDouble()) {
                dB.echoError("Element '" + this.element + "' is not a valid decimal number!");
                return null;
            }
            return new Element(Math.cos(this.asDouble())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("sin")) {
            if (!this.isDouble()) {
                dB.echoError("Element '" + this.element + "' is not a valid decimal number!");
                return null;
            }
            return new Element(Math.sin(this.asDouble())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("tan")) {
            if (!this.isDouble()) {
                dB.echoError("Element '" + this.element + "' is not a valid decimal number!");
                return null;
            }
            return new Element(Math.tan(this.asDouble())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("to_degrees")) {
            if (!this.isDouble()) {
                dB.echoError("Element '" + this.element + "' is not a valid decimal number!");
                return null;
            }
            return new Element(Math.toDegrees(this.asDouble())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("to_radians")) {
            if (!this.isDouble()) {
                dB.echoError("Element '" + this.element + "' is not a valid decimal number!");
                return null;
            }
            return new Element(Math.toRadians(this.asDouble())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("round_up")) {
            if (!this.isDouble()) {
                dB.echoError("Element '" + this.element + "' is not a valid decimal number!");
                return null;
            }
            return new Element((int)Math.ceil(this.asDouble())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("round_down")) {
            if (!this.isDouble()) {
                dB.echoError("Element '" + this.element + "' is not a valid decimal number!");
                return null;
            }
            return new Element((int)Math.floor(this.asDouble())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("round_to") && attribute.hasContext(1)) {
            if (!this.isDouble()) {
                dB.echoError("Element '" + this.element + "' is not a valid decimal number!");
                return null;
            }
            int ten = (int)Math.pow(10.0, attribute.getIntContext(1));
            return new Element((double)Math.round(this.asDouble() * (double)ten) / (double)ten).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("round")) {
            if (!this.isDouble()) {
                dB.echoError("Element '" + this.element + "' is not a valid decimal number!");
                return null;
            }
            return new Element((int)Math.round(this.asDouble())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("type")) {
            return new Element("Element").getAttribute(attribute.fulfill(1));
        }
        if (attribute.attributes.size() > 0) {
            if (!attribute.hasAlternative()) {
                dB.echoDebug((Debuggable)attribute.getScriptEntry(), "Unfilled attributes '" + attribute.attributes.toString() + "' for tag <" + attribute.getOrigin() + ">!");
            }
            return null;
        }
        return this.element;
    }
}

