/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizencore.tags.core;

import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.tags.Attribute;
import net.aufdemrand.denizencore.tags.ReplaceableTagEvent;
import net.aufdemrand.denizencore.tags.TagManager;
import net.aufdemrand.denizencore.utilities.debugging.Debuggable;
import net.aufdemrand.denizencore.utilities.debugging.dB;

public class ContextTags {
    public ContextTags() {
        TagManager.registerTagEvents(this);
    }

    @TagManager.TagEvents
    public void contextTags(ReplaceableTagEvent event) {
        if (!event.matches("context", "c") || event.getScriptEntry() == null) {
            return;
        }
        String object = event.getType();
        dObject obj = event.getScriptEntry().getResidingQueue().getContext(object);
        if (obj != null) {
            Attribute attribute = event.getAttributes();
            event.setReplaced(obj.getAttribute(attribute.fulfill(2)));
            return;
        }
        dB.echoError(event.getScriptEntry() != null ? event.getScriptEntry().getResidingQueue() : null, "Invalid context ID '" + object + "'!");
    }

    @TagManager.TagEvents
    public void savedEntryTags(ReplaceableTagEvent event) {
        if (!event.matches("entry", "e") || event.getScriptEntry() == null || !event.hasNameContext()) {
            return;
        }
        if (event.getScriptEntry().getResidingQueue() != null) {
            String id = event.getNameContext();
            Attribute attribute = event.getAttributes();
            ScriptEntry held = event.getScriptEntry().getResidingQueue().getHeldScriptEntry(id);
            if (held == null) {
                dB.echoDebug((Debuggable)event.getScriptEntry(), "Bad saved entry ID '" + id + "'");
            } else if (!held.hasObject(attribute.getAttribute(2)) || held.getdObject(attribute.getAttribute(2)) == null) {
                dB.echoDebug((Debuggable)event.getScriptEntry(), "Missing saved entry object '" + attribute.getAttribute(2) + "'");
            } else {
                event.setReplaced(held.getdObject(attribute.getAttribute(2)).getAttribute(attribute.fulfill(2)));
            }
        }
    }
}

