/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.entity;

import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.events.BukkitScriptEvent;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.ScriptEntryData;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.vehicle.VehicleExitEvent;
import org.bukkit.plugin.Plugin;

public class EntityExitsVehicleScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static EntityExitsVehicleScriptEvent instance;
    public dEntity vehicle;
    public dEntity entity;
    public VehicleExitEvent event;

    public EntityExitsVehicleScriptEvent() {
        instance = this;
    }

    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        return CoreUtilities.getXthArg(1, CoreUtilities.toLowerCase(s)).equals("exits");
    }

    public boolean matches(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        if (!this.entity.matchesEntity(CoreUtilities.getXthArg(0, lower))) {
            return false;
        }
        if (!this.vehicle.matchesEntity(CoreUtilities.getXthArg(2, lower))) {
            return false;
        }
        return this.runInCheck(scriptContainer, s, lower, this.vehicle.getLocation());
    }

    public String getName() {
        return "EntityExitsVehicle";
    }

    public void init() {
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
    }

    public void destroy() {
        VehicleExitEvent.getHandlerList().unregister((Listener)this);
    }

    public boolean applyDetermination(ScriptContainer container, String determination) {
        return super.applyDetermination(container, determination);
    }

    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.entity.isPlayer() ? this.entity.getDenizenPlayer() : null, this.entity.isCitizensNPC() ? this.entity.getDenizenNPC() : null);
    }

    public dObject getContext(String name) {
        if (name.equals("vehicle")) {
            return this.vehicle;
        }
        if (name.equals("entity")) {
            return this.entity;
        }
        return super.getContext(name);
    }

    @EventHandler(ignoreCancelled=true)
    public void onEntityExitsVehicle(VehicleExitEvent event) {
        this.vehicle = new dEntity((Entity)event.getVehicle());
        this.entity = new dEntity((Entity)event.getExited());
        this.event = event;
        this.cancelled = event.isCancelled();
        this.fire();
        event.setCancelled(this.cancelled);
    }
}

