/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.entity;

import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.events.BukkitScriptEvent;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.objects.dMaterial;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.ScriptEntryData;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.Bukkit;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.BlockIterator;

public class ProjectileHitsScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static ProjectileHitsScriptEvent instance;
    public dEntity projectile;
    public dEntity shooter;
    public dLocation location;
    private dMaterial material;
    public ProjectileHitEvent event;

    public ProjectileHitsScriptEvent() {
        instance = this;
    }

    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        String cmd = CoreUtilities.getXthArg(1, lower);
        return cmd.equals("hits") || cmd.equals("shoots");
    }

    public boolean matches(ScriptContainer scriptContainer, String s) {
        String sTest;
        String pTest;
        String lower = CoreUtilities.toLowerCase(s);
        String cmd = CoreUtilities.getXthArg(1, lower);
        String string = cmd.equals("hits") ? CoreUtilities.getXthArg(0, lower) : (pTest = CoreUtilities.getXthArg(3, lower).equals("with") ? CoreUtilities.getXthArg(4, lower) : "");
        if (pTest.length() > 0 && !this.projectile.matchesEntity(pTest)) {
            return false;
        }
        String mat = CoreUtilities.getXthArg(2, lower);
        if (!this.tryMaterial(this.material, mat)) {
            return false;
        }
        String string2 = sTest = cmd.equals("shoots") ? CoreUtilities.getXthArg(0, lower) : "";
        if (this.shooter != null && sTest.length() > 0 && !this.shooter.matchesEntity(sTest)) {
            return false;
        }
        return this.runInCheck(scriptContainer, s, lower, this.location);
    }

    public String getName() {
        return "ProjectileHits";
    }

    public void init() {
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
    }

    public void destroy() {
        ProjectileHitEvent.getHandlerList().unregister((Listener)this);
    }

    public boolean applyDetermination(ScriptContainer container, String determination) {
        return super.applyDetermination(container, determination);
    }

    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.shooter != null && this.shooter.isPlayer() ? dEntity.getPlayerFrom((Entity)this.event.getEntity()) : null, this.shooter != null && this.shooter.isCitizensNPC() ? dEntity.getNPCFrom((Entity)this.event.getEntity()) : null);
    }

    public dObject getContext(String name) {
        if (name.equals("projectile")) {
            return this.projectile;
        }
        if (name.equals("location")) {
            return this.location;
        }
        if (name.equals("shooter") && this.shooter != null) {
            return this.shooter;
        }
        return super.getContext(name);
    }

    @EventHandler(ignoreCancelled=true)
    public void onProjectileHits(ProjectileHitEvent event) {
        this.projectile = new dEntity((Entity)event.getEntity());
        if (this.projectile.getLocation() == null) {
            return;
        }
        if (Double.isNaN(this.projectile.getLocation().getDirection().normalize().getX())) {
            return;
        }
        Block block = null;
        try {
            BlockIterator bi = new BlockIterator(this.projectile.getLocation().getWorld(), this.projectile.getLocation().toVector(), this.projectile.getLocation().getDirection().normalize(), 0.0, 4);
            while (bi.hasNext() && (block = bi.next()).getTypeId() == 0) {
            }
        }
        catch (IllegalStateException ex) {
            return;
        }
        if (block == null) {
            return;
        }
        this.material = dMaterial.getMaterialFrom(block.getType(), block.getData());
        this.shooter = this.projectile.getShooter();
        this.location = new dLocation(block.getLocation());
        this.event = event;
        this.fire();
    }
}

