/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.player;

import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.events.BukkitScriptEvent;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dInventory;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.objects.notable.NotableManager;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.ScriptEntryData;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class PlayerDragsInInvScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static PlayerDragsInInvScriptEvent instance;
    public Inventory inventory;
    public dList slots;
    public dItem item;
    public dList raw_slots;
    private dPlayer entity;
    private dInventory dInv;
    private boolean manual_cancelled;
    public InventoryDragEvent event;

    public PlayerDragsInInvScriptEvent() {
        instance = this;
    }

    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        return lower.startsWith("player drags");
    }

    public boolean matches(ScriptContainer scriptContainer, String s) {
        String nname;
        String lower = CoreUtilities.toLowerCase(s);
        String arg2 = CoreUtilities.getXthArg(2, lower);
        String arg3 = CoreUtilities.getXthArg(3, lower);
        String arg4 = CoreUtilities.getXthArg(4, lower);
        String inv = arg2.equals("in") ? arg3 : (arg3.equals("in") ? arg4 : "");
        String string = nname = NotableManager.isSaved(this.dInv) ? CoreUtilities.toLowerCase(NotableManager.getSavedId(this.dInv)) : "\u0000";
        if (!(inv.equals("") || inv.equals("inventory") || inv.equals(CoreUtilities.toLowerCase(this.dInv.getInventoryType().name())) || inv.equals(nname))) {
            return false;
        }
        if (!arg2.equals("in") && !this.tryItem(this.item, arg2)) {
            return false;
        }
        return this.runInCheck(scriptContainer, s, lower, this.entity.getLocation(), "in_area");
    }

    public String getName() {
        return "PlayerDragsInInventory";
    }

    public void init() {
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
    }

    public void destroy() {
        InventoryDragEvent.getHandlerList().unregister((Listener)this);
    }

    public boolean applyDetermination(ScriptContainer container, String determination) {
        if (CoreUtilities.toLowerCase(determination).equals("cancelled")) {
            this.manual_cancelled = true;
        }
        return super.applyDetermination(container, determination);
    }

    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.entity, null);
    }

    public dObject getContext(String name) {
        if (name.equals("inventory")) {
            return this.dInv;
        }
        if (name.equals("slots")) {
            return this.slots;
        }
        if (name.equals("raw_slots")) {
            return this.raw_slots;
        }
        if (name.equals("item")) {
            return this.item;
        }
        return super.getContext(name);
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerDragsInInv(InventoryDragEvent event) {
        if (dEntity.isCitizensNPC((Entity)event.getWhoClicked())) {
            return;
        }
        this.entity = dEntity.getPlayerFrom((Entity)event.getWhoClicked());
        this.inventory = event.getInventory();
        this.dInv = dInventory.mirrorBukkitInventory(this.inventory);
        this.item = new dItem(event.getOldCursor());
        this.slots = new dList();
        for (Integer slot : event.getInventorySlots()) {
            this.slots.add(slot.toString());
        }
        this.raw_slots = new dList();
        for (Integer raw_slot : event.getRawSlots()) {
            this.raw_slots.add(raw_slot.toString());
        }
        this.cancelled = event.isCancelled();
        this.manual_cancelled = false;
        this.event = event;
        this.fire();
        if (this.cancelled && this.manual_cancelled) {
            final InventoryHolder holder = this.inventory.getHolder();
            new BukkitRunnable(){

                public void run() {
                    PlayerDragsInInvScriptEvent.this.entity.getPlayerEntity().updateInventory();
                    if (holder != null && holder instanceof Player) {
                        ((Player)holder).updateInventory();
                    }
                }
            }.runTaskLater((Plugin)DenizenAPI.getCurrentInstance(), 1L);
        }
        event.setCancelled(this.cancelled);
    }
}

