/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.player;

import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.events.BukkitScriptEvent;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.ScriptEntryData;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerPickupItemEvent;
import org.bukkit.plugin.Plugin;

public class PlayerPicksUpScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static PlayerPicksUpScriptEvent instance;
    public dItem item;
    public dEntity entity;
    public dLocation location;
    public PlayerPickupItemEvent event;

    public PlayerPicksUpScriptEvent() {
        instance = this;
    }

    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        return lower.startsWith("player picks up") || lower.startsWith("player takes");
    }

    public boolean matches(ScriptContainer scriptContainer, String s) {
        String iTest;
        String lower = CoreUtilities.toLowerCase(s);
        String string = iTest = CoreUtilities.xthArgEquals(1, lower, "picks") ? CoreUtilities.getXthArg(3, lower) : CoreUtilities.getXthArg(2, lower);
        if (!this.tryItem(this.item, iTest)) {
            return false;
        }
        return this.runInCheck(scriptContainer, s, lower, this.location);
    }

    public String getName() {
        return "PlayerPicksUp";
    }

    public void init() {
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
    }

    public void destroy() {
        PlayerPickupItemEvent.getHandlerList().unregister((Listener)this);
    }

    public boolean applyDetermination(ScriptContainer container, String determination) {
        return super.applyDetermination(container, determination);
    }

    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(dEntity.isPlayer((Entity)this.event.getPlayer()) ? dEntity.getPlayerFrom((Entity)this.event.getPlayer()) : null, null);
    }

    public dObject getContext(String name) {
        if (name.equals("item")) {
            return this.item;
        }
        if (name.equals("entity")) {
            return this.entity;
        }
        if (name.equals("location")) {
            return this.location;
        }
        return super.getContext(name);
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerPicksUp(PlayerPickupItemEvent event) {
        if (dEntity.isNPC((Entity)event.getPlayer())) {
            return;
        }
        this.location = new dLocation(event.getItem().getLocation());
        this.item = new dItem(event.getItem().getItemStack());
        this.entity = new dEntity((Entity)event.getItem());
        this.cancelled = event.isCancelled();
        this.event = event;
        this.fire();
        event.setCancelled(this.cancelled);
    }
}

