/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.player;

import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.events.BukkitScriptEvent;
import net.aufdemrand.denizen.objects.dCuboid;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.ScriptEntryData;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Hanging;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.hanging.HangingPlaceEvent;
import org.bukkit.plugin.Plugin;

public class PlayerPlacesHangingScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static PlayerPlacesHangingScriptEvent instance;
    public dEntity hanging;
    public dList cuboids;
    public dLocation location;
    public HangingPlaceEvent event;

    public PlayerPlacesHangingScriptEvent() {
        instance = this;
    }

    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        return lower.startsWith("player places");
    }

    public boolean matches(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        String hangCheck = CoreUtilities.getXthArg(2, lower);
        if (!this.hanging.matchesEntity(hangCheck)) {
            return false;
        }
        return this.runInCheck(scriptContainer, s, lower, this.location);
    }

    public String getName() {
        return "PlayerPlacesHanging";
    }

    public void init() {
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
    }

    public void destroy() {
        HangingPlaceEvent.getHandlerList().unregister((Listener)this);
    }

    public boolean applyDetermination(ScriptContainer container, String determination) {
        return super.applyDetermination(container, determination);
    }

    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(new dPlayer(this.event.getPlayer()), null);
    }

    public dObject getContext(String name) {
        if (name.equals("hanging")) {
            return this.hanging;
        }
        if (name.equals("location")) {
            return this.location;
        }
        if (name.equals("cuboids")) {
            return this.cuboids;
        }
        return super.getContext(name);
    }

    @EventHandler(ignoreCancelled=true)
    public void pnPlayerPlacesHanging(HangingPlaceEvent event) {
        if (dEntity.isNPC((Entity)event.getPlayer())) {
            return;
        }
        Hanging hangingEntity = event.getEntity();
        dEntity.rememberEntity((Entity)hangingEntity);
        this.hanging = new dEntity((Entity)hangingEntity);
        this.location = new dLocation(event.getBlock().getLocation());
        this.cuboids = new dList();
        for (dCuboid cuboid : dCuboid.getNotableCuboidsContaining(this.location)) {
            this.cuboids.add(cuboid.identifySimple());
        }
        this.cancelled = event.isCancelled();
        this.event = event;
        this.fire();
        dEntity.forgetEntity((Entity)hangingEntity);
        event.setCancelled(this.cancelled);
    }
}

