/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.player;

import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.events.BukkitScriptEvent;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.ScriptEntryData;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.plugin.Plugin;

public class PlayerSneakScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static PlayerSneakScriptEvent instance;
    public Boolean state;
    public PlayerToggleSneakEvent event;

    public PlayerSneakScriptEvent() {
        instance = this;
    }

    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        return CoreUtilities.getXthArg(2, CoreUtilities.toLowerCase(s)).startsWith("sneak");
    }

    public boolean matches(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        String cmd = CoreUtilities.getXthArg(1, lower);
        if (cmd.equals("starts") && !this.state.booleanValue()) {
            return false;
        }
        if (cmd.equals("stops") && this.state.booleanValue()) {
            return false;
        }
        return this.runInCheck(scriptContainer, s, lower, this.event.getPlayer().getLocation());
    }

    public String getName() {
        return "PlayerSpring";
    }

    public void init() {
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
    }

    public void destroy() {
        PlayerToggleSneakEvent.getHandlerList().unregister((Listener)this);
    }

    public boolean applyDetermination(ScriptContainer container, String determination) {
        return super.applyDetermination(container, determination);
    }

    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(dEntity.isPlayer((Entity)this.event.getPlayer()) ? dEntity.getPlayerFrom((Entity)this.event.getPlayer()) : null, null);
    }

    public dObject getContext(String name) {
        if (name.equals("state")) {
            return new Element(this.state);
        }
        return super.getContext(name);
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerSneak(PlayerToggleSneakEvent event) {
        if (dEntity.isNPC((Entity)event.getPlayer())) {
            return;
        }
        this.state = event.isSneaking();
        this.cancelled = event.isCancelled();
        this.event = event;
        this.fire();
        event.setCancelled(this.cancelled);
    }
}

