/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.objects;

import java.util.HashMap;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.Fetchable;
import net.aufdemrand.denizencore.objects.TagRunnable;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.objects.properties.Property;
import net.aufdemrand.denizencore.objects.properties.PropertyParser;
import net.aufdemrand.denizencore.tags.Attribute;
import net.aufdemrand.denizencore.tags.TagContext;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import net.aufdemrand.denizencore.utilities.debugging.dB;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class dPlugin
implements dObject {
    private Plugin plugin;
    private String prefix = "Plugin";
    public static HashMap<String, TagRunnable> registeredTags = new HashMap();

    public static dPlugin valueOf(String string) {
        return dPlugin.valueOf(string, null);
    }

    @Fetchable(value="pl")
    public static dPlugin valueOf(String string, TagContext context) {
        if (string == null) {
            return null;
        }
        string = string.toLowerCase().replace("pl@", "");
        try {
            for (Plugin plugin : Bukkit.getServer().getPluginManager().getPlugins()) {
                if (!string.equalsIgnoreCase(plugin.getName())) continue;
                return new dPlugin(plugin);
            }
        }
        catch (Exception e) {
            net.aufdemrand.denizen.utilities.debugging.dB.echoError("Invalid plugin name specified, or plugin is not enabled: " + string);
        }
        return null;
    }

    public static boolean matches(String arg) {
        if (arg.toLowerCase().startsWith("pl@")) {
            return true;
        }
        for (Plugin plugin : Bukkit.getServer().getPluginManager().getPlugins()) {
            if (!arg.equalsIgnoreCase(plugin.getName())) continue;
            return true;
        }
        return false;
    }

    public dPlugin(Plugin plugin) {
        this.plugin = plugin;
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    public String getObjectType() {
        return "Plugin";
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String debug() {
        return String.format("<G>%s='<Y>%s<G>'  ", this.prefix, this.identify());
    }

    public boolean isUnique() {
        return true;
    }

    public String identify() {
        return "pl@" + this.plugin.getName();
    }

    public String identifySimple() {
        return this.identify();
    }

    public dPlugin setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public static void registerTags() {
        dPlugin.registerTag("name", new TagRunnable(){

            public String run(Attribute attribute, dObject object) {
                return new Element(((dPlugin)object).plugin.getName()).getAttribute(attribute.fulfill(1));
            }
        });
        dPlugin.registerTag("version", new TagRunnable(){

            public String run(Attribute attribute, dObject object) {
                return new Element(((dPlugin)object).plugin.getDescription().getVersion()).getAttribute(attribute.fulfill(1));
            }
        });
        dPlugin.registerTag("description", new TagRunnable(){

            public String run(Attribute attribute, dObject object) {
                return new Element(((dPlugin)object).plugin.getDescription().getDescription()).getAttribute(attribute.fulfill(1));
            }
        });
        dPlugin.registerTag("authors", new TagRunnable(){

            public String run(Attribute attribute, dObject object) {
                return new dList(((dPlugin)object).plugin.getDescription().getAuthors()).getAttribute(attribute.fulfill(1));
            }
        });
        dPlugin.registerTag("type", new TagRunnable(){

            public String run(Attribute attribute, dObject object) {
                return new Element("Plugin").getAttribute(attribute.fulfill(1));
            }
        });
    }

    public static void registerTag(String name, TagRunnable runnable) {
        if (runnable.name == null) {
            runnable.name = name;
        }
        registeredTags.put(name, runnable);
    }

    public String getAttribute(Attribute attribute) {
        if (attribute == null) {
            return "null";
        }
        String attrLow = CoreUtilities.toLowerCase(attribute.getAttributeWithoutContext(1));
        TagRunnable tr = registeredTags.get(attrLow);
        if (tr != null) {
            if (!tr.name.equals(attrLow)) {
                dB.echoError(attribute.getScriptEntry() != null ? attribute.getScriptEntry().getResidingQueue() : null, "Using deprecated form of tag '" + tr.name + "': '" + attrLow + "'.");
            }
            return tr.run(attribute, this);
        }
        for (Property property : PropertyParser.getProperties(this)) {
            String returned = property.getAttribute(attribute);
            if (returned == null) continue;
            return returned;
        }
        return new Element(this.identify()).getAttribute(attribute);
    }
}

