/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.objects.properties.entity;

import java.util.Iterator;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.objects.Mechanism;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.objects.properties.Property;
import net.aufdemrand.denizencore.tags.Attribute;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.EntityType;
import org.bukkit.util.EulerAngle;

public class EntityArmorPose
implements Property {
    dEntity entity;

    public static boolean describes(dObject entity) {
        return entity instanceof dEntity && ((dEntity)entity).getBukkitEntityType() == EntityType.ARMOR_STAND;
    }

    public static EntityArmorPose getFrom(dObject entity) {
        if (!EntityArmorPose.describes(entity)) {
            return null;
        }
        return new EntityArmorPose((dEntity)entity);
    }

    private EntityArmorPose(dEntity ent) {
        this.entity = ent;
    }

    public String getPropertyString() {
        return this.getPoseList().identify();
    }

    public String getPropertyId() {
        return "armor_pose";
    }

    private dList getPoseList() {
        ArmorStand armorStand = (ArmorStand)this.entity.getBukkitEntity();
        dList list = new dList();
        for (PosePart posePart : PosePart.values()) {
            list.add(CoreUtilities.toLowerCase(posePart.name()));
            list.add(EntityArmorPose.fromEulerAngle(posePart.getAngle(armorStand)).identify());
        }
        return list;
    }

    public String getAttribute(Attribute attribute) {
        if (attribute == null) {
            return "null";
        }
        if (attribute.startsWith("armor_pose_list")) {
            return this.getPoseList().getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("armor_pose") && attribute.hasContext(1)) {
            String name = attribute.getContext(1);
            PosePart posePart = PosePart.fromName(name);
            if (posePart == null) {
                dB.echoError("Invalid pose part specified: " + name);
                return null;
            }
            return EntityArmorPose.fromEulerAngle(posePart.getAngle((ArmorStand)this.entity.getBukkitEntity())).getAttribute(attribute.fulfill(1));
        }
        return null;
    }

    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("armor_pose")) {
            ArmorStand armorStand = (ArmorStand)this.entity.getBukkitEntity();
            dList list = mechanism.getValue().asType(dList.class);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String name = (String)iterator.next();
                String angle = (String)iterator.next();
                PosePart posePart = PosePart.fromName(name);
                if (posePart == null) {
                    dB.echoError("Invalid pose part specified: " + name + "; ignoring next: " + angle);
                    continue;
                }
                posePart.setAngle(armorStand, EntityArmorPose.toEulerAngle(dLocation.valueOf(angle)));
            }
        }
    }

    private static dLocation fromEulerAngle(EulerAngle eulerAngle) {
        return new dLocation(null, eulerAngle.getX(), eulerAngle.getY(), eulerAngle.getZ());
    }

    private static EulerAngle toEulerAngle(dLocation location) {
        return new EulerAngle(location.getX(), location.getY(), location.getZ());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum PosePart {
        HEAD{

            EulerAngle getAngle(ArmorStand armorStand) {
                return armorStand.getHeadPose();
            }

            void setAngle(ArmorStand armorStand, EulerAngle eulerAngle) {
                armorStand.setHeadPose(eulerAngle);
            }
        }
        ,
        BODY{

            EulerAngle getAngle(ArmorStand armorStand) {
                return armorStand.getBodyPose();
            }

            void setAngle(ArmorStand armorStand, EulerAngle eulerAngle) {
                armorStand.setBodyPose(eulerAngle);
            }
        }
        ,
        LEFT_ARM{

            EulerAngle getAngle(ArmorStand armorStand) {
                return armorStand.getLeftArmPose();
            }

            void setAngle(ArmorStand armorStand, EulerAngle eulerAngle) {
                armorStand.setLeftArmPose(eulerAngle);
            }
        }
        ,
        RIGHT_ARM{

            EulerAngle getAngle(ArmorStand armorStand) {
                return armorStand.getRightArmPose();
            }

            void setAngle(ArmorStand armorStand, EulerAngle eulerAngle) {
                armorStand.setRightArmPose(eulerAngle);
            }
        }
        ,
        LEFT_LEG{

            EulerAngle getAngle(ArmorStand armorStand) {
                return armorStand.getLeftLegPose();
            }

            void setAngle(ArmorStand armorStand, EulerAngle eulerAngle) {
                armorStand.setLeftLegPose(eulerAngle);
            }
        }
        ,
        RIGHT_LEG{

            EulerAngle getAngle(ArmorStand armorStand) {
                return armorStand.getRightLegPose();
            }

            void setAngle(ArmorStand armorStand, EulerAngle eulerAngle) {
                armorStand.setRightLegPose(eulerAngle);
            }
        };


        abstract EulerAngle getAngle(ArmorStand var1);

        abstract void setAngle(ArmorStand var1, EulerAngle var2);

        static PosePart fromName(String name) {
            for (PosePart posePart : PosePart.values()) {
                if (!posePart.name().equalsIgnoreCase(name)) continue;
                return posePart;
            }
            return null;
        }
    }
}

