/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.world;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.exceptions.CommandExecutionException;
import net.aufdemrand.denizencore.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.commands.AbstractCommand;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import net.minecraft.server.v1_8_R3.EnumParticle;
import net.minecraft.server.v1_8_R3.Packet;
import net.minecraft.server.v1_8_R3.PacketPlayOutWorldParticles;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.craftbukkit.v1_8_R3.entity.CraftPlayer;
import org.bukkit.entity.Player;

public class PlayEffectCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (!scriptEntry.hasObject("location") && arg.matchesArgumentList(dLocation.class)) {
                scriptEntry.addObject("location", arg.asType(dList.class).filter(dLocation.class));
                continue;
            }
            if (!(scriptEntry.hasObject("effect") || scriptEntry.hasObject("particleeffect") || scriptEntry.hasObject("iconcrack"))) {
                if (arg.matchesEnum(ParticleEffect.values())) {
                    scriptEntry.addObject("particleeffect", (Object)ParticleEffect.valueOf(arg.getValue().toUpperCase()));
                    continue;
                }
                if (arg.matches("random")) {
                    Enum effect = null;
                    while (effect == null || effect.toString().matches("^(BUBBLE|SUSPEND|DEPTH_SUSPEND)$")) {
                        effect = ParticleEffect.values()[CoreUtilities.getRandom().nextInt(ParticleEffect.values().length)];
                    }
                    scriptEntry.addObject("particleeffect", effect);
                    continue;
                }
                if (arg.startsWith("iconcrack_")) {
                    Element typeId = new Element(arg.getValue().substring(10));
                    if (typeId.isInt() && typeId.asInt() > 0 && Material.getMaterial((int)typeId.asInt()) != null) {
                        scriptEntry.addObject("iconcrack", typeId);
                        continue;
                    }
                    dB.echoError("Invalid iconcrack_[id]. Must be a valid Material ID, besides 0.");
                    continue;
                }
                if (!arg.matchesEnum((Enum<?>[])Effect.values())) continue;
                scriptEntry.addObject("effect", Effect.valueOf((String)arg.getValue().toUpperCase()));
                continue;
            }
            if (!scriptEntry.hasObject("radius") && arg.matchesPrimitive(aH.PrimitiveType.Double) && arg.matchesPrefix("visibility", "v", "radius", "r")) {
                scriptEntry.addObject("radius", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("data") && arg.matchesPrimitive(aH.PrimitiveType.Double) && arg.matchesPrefix("data", "d")) {
                scriptEntry.addObject("data", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("qty") && arg.matchesPrimitive(aH.PrimitiveType.Integer) && arg.matchesPrefix("qty", "q", "quantity")) {
                scriptEntry.addObject("qty", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("offset") && arg.matchesPrimitive(aH.PrimitiveType.Double) && arg.matchesPrefix("offset", "o")) {
                double offset = arg.asElement().asDouble();
                scriptEntry.addObject("offset", new dLocation(null, offset, offset, offset));
                continue;
            }
            if (!scriptEntry.hasObject("offset") && arg.matchesArgumentType(dLocation.class) && arg.matchesPrefix("offset", "o")) {
                scriptEntry.addObject("offset", arg.asType(dLocation.class));
                continue;
            }
            if (!scriptEntry.hasObject("targets") && arg.matchesArgumentList(dPlayer.class) && arg.matchesPrefix("targets", "target", "t")) {
                scriptEntry.addObject("targets", arg.asType(dList.class).filter(dPlayer.class));
                continue;
            }
            arg.reportUnhandled();
        }
        scriptEntry.defaultObject("location", ((BukkitScriptEntryData)scriptEntry.entryData).hasNPC() && ((BukkitScriptEntryData)scriptEntry.entryData).getNPC().isSpawned() ? Arrays.asList(((BukkitScriptEntryData)scriptEntry.entryData).getNPC().getLocation()) : null, ((BukkitScriptEntryData)scriptEntry.entryData).hasPlayer() && ((BukkitScriptEntryData)scriptEntry.entryData).getPlayer().isOnline() ? Arrays.asList(((BukkitScriptEntryData)scriptEntry.entryData).getPlayer().getLocation()) : null);
        scriptEntry.defaultObject("data", new Element(0));
        scriptEntry.defaultObject("radius", new Element(15));
        scriptEntry.defaultObject("qty", new Element(1));
        scriptEntry.defaultObject("offset", new dLocation(null, 0.5, 0.5, 0.5));
        if (!(scriptEntry.hasObject("effect") || scriptEntry.hasObject("particleeffect") || scriptEntry.hasObject("iconcrack"))) {
            throw new InvalidArgumentsException("Missing effect argument!");
        }
        if (!scriptEntry.hasObject("location")) {
            throw new InvalidArgumentsException("Missing location argument!");
        }
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        List locations = (List)scriptEntry.getObject("location");
        List targets = (List)scriptEntry.getObject("targets");
        Effect effect = (Effect)scriptEntry.getObject("effect");
        ParticleEffect particleEffect = (ParticleEffect)((Object)scriptEntry.getObject("particleeffect"));
        Element iconcrack = scriptEntry.getElement("iconcrack");
        Element radius = scriptEntry.getElement("radius");
        Element data = scriptEntry.getElement("data");
        Element qty = scriptEntry.getElement("qty");
        dLocation offset = (dLocation)scriptEntry.getdObject("offset");
        dB.report(scriptEntry, this.getName(), (effect != null ? aH.debugObj("effect", effect.name()) : (particleEffect != null ? aH.debugObj("special effect", particleEffect.name()) : iconcrack.debug())) + aH.debugObj("locations", locations.toString()) + (targets != null ? aH.debugObj("targets", targets.toString()) : "") + radius.debug() + data.debug() + qty.debug() + offset.debug());
        for (dLocation location : locations) {
            PacketPlayOutWorldParticles o;
            ArrayList<Player> players;
            float osZ;
            float osY;
            location.add(0.0, 1.0, 0.0);
            if (effect != null) {
                for (int n = 0; n < qty.asInt(); ++n) {
                    if (targets != null) {
                        for (dPlayer player : targets) {
                            if (!player.isValid() || !player.isOnline()) continue;
                            player.getPlayerEntity().playEffect((Location)location, effect, data.asInt());
                        }
                        continue;
                    }
                    location.getWorld().playEffect((Location)location, effect, data.asInt(), radius.asInt());
                }
                continue;
            }
            if (particleEffect != null) {
                float osX = (float)offset.getX();
                osY = (float)offset.getY();
                osZ = (float)offset.getZ();
                players = new ArrayList<Player>();
                if (targets == null) {
                    float rad = radius.asFloat();
                    for (Player player : location.getWorld().getPlayers()) {
                        if (!(player.getLocation().distanceSquared((Location)location) < (double)(rad * rad))) continue;
                        players.add(player);
                    }
                } else {
                    for (dPlayer player : targets) {
                        if (!player.isValid() || !player.isOnline()) continue;
                        players.add(player.getPlayerEntity());
                    }
                }
                o = new PacketPlayOutWorldParticles(particleEffect.effect, true, (float)location.getX(), (float)location.getY(), (float)location.getZ(), osX, osY, osZ, data.asFloat(), qty.asInt(), new int[0]);
                for (Player player : players) {
                    ((CraftPlayer)player).getHandle().playerConnection.sendPacket((Packet)o);
                }
                continue;
            }
            float osX = (float)offset.getX();
            osY = (float)offset.getY();
            osZ = (float)offset.getZ();
            players = new ArrayList();
            if (targets == null) {
                float rad = radius.asFloat();
                for (Player player : location.getWorld().getPlayers()) {
                    if (!(player.getLocation().distanceSquared((Location)location) < (double)(rad * rad))) continue;
                    players.add(player);
                }
            } else {
                for (dPlayer player : targets) {
                    if (!player.isValid() || !player.isOnline()) continue;
                    players.add(player.getPlayerEntity());
                }
            }
            o = new PacketPlayOutWorldParticles(EnumParticle.ITEM_CRACK, true, (float)location.getX(), (float)location.getY(), (float)location.getZ(), osX, osY, osZ, data.asFloat(), qty.asInt(), new int[]{iconcrack.asInt(), iconcrack.asInt()});
            for (Player player : players) {
                ((CraftPlayer)player).getHandle().playerConnection.sendPacket((Packet)o);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ParticleEffect {
        ENDER_SIGNAL(EnumParticle.HEART),
        MOBSPAWNER_FLAMES(EnumParticle.FLAME),
        POTION_BREAK(EnumParticle.HEART),
        SMOKE(EnumParticle.SMOKE_NORMAL),
        HUGE_EXPLOSION(EnumParticle.EXPLOSION_HUGE),
        LARGE_EXPLODE(EnumParticle.EXPLOSION_LARGE),
        FIREWORKS_SPARK(EnumParticle.FIREWORKS_SPARK),
        BUBBLE(EnumParticle.WATER_BUBBLE),
        SUSPEND(EnumParticle.SUSPENDED),
        DEPTH_SUSPEND(EnumParticle.SUSPENDED_DEPTH),
        TOWN_AURA(EnumParticle.TOWN_AURA),
        CRIT(EnumParticle.CRIT),
        MAGIC_CRIT(EnumParticle.CRIT_MAGIC),
        MOB_SPELL(EnumParticle.SPELL_MOB),
        MOB_SPELL_AMBIENT(EnumParticle.SPELL_MOB_AMBIENT),
        SPELL(EnumParticle.SPELL),
        INSTANT_SPELL(EnumParticle.SPELL_INSTANT),
        WITCH_MAGIC(EnumParticle.SPELL_WITCH),
        NOTE(EnumParticle.NOTE),
        STEP_SOUND(EnumParticle.HEART),
        PORTAL(EnumParticle.PORTAL),
        ENCHANTMENT_TABLE(EnumParticle.ENCHANTMENT_TABLE),
        EXPLODE(EnumParticle.EXPLOSION_NORMAL),
        FLAME(EnumParticle.FLAME),
        LAVA(EnumParticle.LAVA),
        FOOTSTEP(EnumParticle.FOOTSTEP),
        SPLASH(EnumParticle.WATER_SPLASH),
        LARGE_SMOKE(EnumParticle.SMOKE_LARGE),
        CLOUD(EnumParticle.CLOUD),
        RED_DUST(EnumParticle.REDSTONE),
        SNOWBALL_POOF(EnumParticle.SNOWBALL),
        DRIP_WATER(EnumParticle.DRIP_WATER),
        DRIP_LAVA(EnumParticle.DRIP_LAVA),
        SNOW_SHOVEL(EnumParticle.SNOW_SHOVEL),
        SLIME(EnumParticle.SLIME),
        HEART(EnumParticle.HEART),
        ANGRY_VILLAGER(EnumParticle.VILLAGER_ANGRY),
        HAPPY_VILLAGER(EnumParticle.VILLAGER_HAPPY),
        BARRIER(EnumParticle.BARRIER);

        public EnumParticle effect;

        private ParticleEffect(EnumParticle eff) {
            this.effect = eff;
        }
    }
}

