/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.utilities;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dNPC;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.scripts.containers.core.CommandScriptContainer;
import net.aufdemrand.denizen.tags.BukkitTagContext;
import net.aufdemrand.denizen.utilities.depends.Depends;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.objects.dScript;
import net.aufdemrand.denizencore.tags.TagManager;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DenizenCommand
extends Command {
    private CommandScriptContainer script;

    public DenizenCommand(CommandScriptContainer script) {
        super(script.getCommandName(), script.getDescription(), script.getUsage(), script.getAliases());
        String permission = script.getPermission();
        if (permission != null && !permission.equals("")) {
            this.setPermission(permission);
            String permissionMessage = script.getPermissionMessage();
            if (permissionMessage != null && !permissionMessage.equals("")) {
                this.setPermissionMessage(permissionMessage);
            }
        }
        this.script = script;
    }

    public boolean canSeeHelp(CommandSender commandSender) {
        if (!this.script.hasAllowedHelpProcedure()) {
            return true;
        }
        if (!this.testPermissionSilent(commandSender)) {
            return false;
        }
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dPlayer player = null;
        dNPC npc = null;
        if (commandSender instanceof Player) {
            Player pl = (Player)commandSender;
            if (!dEntity.isNPC((Entity)pl)) {
                player = dPlayer.mirrorBukkitPlayer((OfflinePlayer)pl);
            }
            context.put("server", Element.FALSE);
        } else {
            context.put("server", Element.TRUE);
        }
        return this.script.runAllowedHelpProcedure(player, npc, context);
    }

    public boolean testPermission(CommandSender target) {
        if (this.testPermissionSilent(target)) {
            return true;
        }
        String permissionMessage = this.getPermissionMessage();
        if (permissionMessage == null) {
            target.sendMessage(ChatColor.RED + "I'm sorry, but you do not have permission to perform this command. " + "Please contact the server administrators if you believe that this is in error.");
        } else if (permissionMessage.length() != 0) {
            NPC citizen;
            dPlayer player = null;
            dNPC npc = null;
            if (target instanceof Player) {
                Player pl = (Player)target;
                if (dEntity.isCitizensNPC((Entity)pl)) {
                    npc = dNPC.fromEntity((Entity)pl);
                } else {
                    player = dPlayer.mirrorBukkitPlayer((OfflinePlayer)pl);
                }
            }
            if (Depends.citizens != null && npc == null && (citizen = CitizensAPI.getDefaultNPCSelector().getSelected(target)) != null) {
                npc = dNPC.mirrorCitizensNPC(citizen);
            }
            for (String line : TagManager.tag(permissionMessage.replace("<permission>", this.getPermission()), new BukkitTagContext(player, npc, false, null, false, new dScript(this.script))).split("\n")) {
                target.sendMessage(line);
            }
        }
        return false;
    }

    public boolean execute(CommandSender commandSender, String commandLabel, String[] arguments) {
        NPC citizen;
        if (!this.testPermission(commandSender)) {
            return true;
        }
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        String raw_args = "";
        if (arguments.length > 0) {
            StringBuilder rawArgsBuilder = new StringBuilder();
            for (String arg : arguments) {
                rawArgsBuilder.append(arg).append(' ');
            }
            raw_args = rawArgsBuilder.substring(0, rawArgsBuilder.length() - 1);
        }
        List<String> args = Arrays.asList(aH.buildArgs(raw_args));
        context.put("args", new dList(args));
        context.put("raw_args", new Element(raw_args));
        context.put("alias", new Element(commandLabel));
        dPlayer player = null;
        dNPC npc = null;
        if (commandSender instanceof Player) {
            Player pl = (Player)commandSender;
            if (dEntity.isCitizensNPC((Entity)pl)) {
                npc = dNPC.fromEntity((Entity)pl);
            } else {
                player = dPlayer.mirrorBukkitPlayer((OfflinePlayer)pl);
            }
            context.put("server", Element.FALSE);
        } else {
            context.put("server", Element.TRUE);
        }
        if (Depends.citizens != null && npc == null && (citizen = CitizensAPI.getDefaultNPCSelector().getSelected(commandSender)) != null) {
            npc = dNPC.mirrorCitizensNPC(citizen);
        }
        this.script.runCommandScript(player, npc, context);
        return true;
    }

    public boolean isRegistered() {
        return true;
    }

    public List<String> tabComplete(CommandSender commandSender, String alias, String[] arguments) {
        NPC citizen;
        if (!this.script.hasTabCompleteProcedure()) {
            return super.tabComplete(commandSender, alias, arguments);
        }
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        String raw_args = "";
        if (arguments.length > 0) {
            StringBuilder rawArgsBuilder = new StringBuilder();
            for (String arg : arguments) {
                rawArgsBuilder.append(arg).append(' ');
            }
            raw_args = rawArgsBuilder.substring(0, rawArgsBuilder.length() - 1);
        }
        List<String> args = Arrays.asList(aH.buildArgs(raw_args));
        context.put("args", new dList(args));
        context.put("raw_args", new Element(raw_args));
        context.put("alias", new Element(alias));
        dPlayer player = null;
        dNPC npc = null;
        if (commandSender instanceof Player) {
            Player pl = (Player)commandSender;
            if (dEntity.isCitizensNPC((Entity)pl)) {
                npc = dNPC.fromEntity((Entity)pl);
            } else {
                player = dPlayer.mirrorBukkitPlayer((OfflinePlayer)pl);
            }
            context.put("server", Element.FALSE);
        } else {
            context.put("server", Element.TRUE);
        }
        if (Depends.citizens != null && npc == null && (citizen = CitizensAPI.getDefaultNPCSelector().getSelected(commandSender)) != null) {
            npc = dNPC.mirrorCitizensNPC(citizen);
        }
        return this.script.runTabCompleteProcedure(player, npc, context);
    }
}

