/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizencore.objects.properties;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.objects.properties.Property;
import net.aufdemrand.denizencore.utilities.debugging.dB;

public class PropertyParser {
    static Map<Class<? extends dObject>, List<Class>> properties = new HashMap<Class<? extends dObject>, List<Class>>();
    static Map<Class, Method> describes = new WeakHashMap<Class, Method>();
    static Map<Class, Method> getFrom = new WeakHashMap<Class, Method>();

    public PropertyParser() {
        properties.clear();
        describes.clear();
        getFrom.clear();
    }

    public void registerProperty(Class property, Class<? extends dObject> object) {
        List<Object> prop_list = properties.containsKey(object) ? properties.get(object) : new ArrayList();
        prop_list.add(property);
        properties.put(object, prop_list);
        try {
            describes.put(property, property.getMethod("describes", dObject.class));
            getFrom.put(property, property.getMethod("getFrom", dObject.class));
        }
        catch (NoSuchMethodException e) {
            dB.echoError("Unable to register property '" + property.getSimpleName() + "'!");
        }
    }

    public static String getPropertiesString(dObject object) {
        StringBuilder prop_string = new StringBuilder();
        for (Property property : PropertyParser.getProperties(object)) {
            String description = property.getPropertyString();
            if (description == null) continue;
            prop_string.append(property.getPropertyId()).append('=').append(description.replace(';', '\u2011')).append(';');
        }
        if (prop_string.length() > 0) {
            return "[" + prop_string.substring(0, prop_string.length() - 1) + "]";
        }
        return "";
    }

    public static List<Property> getProperties(dObject object) {
        ArrayList<Property> props = new ArrayList<Property>();
        try {
            if (properties.containsKey(object.getClass())) {
                for (Class property : properties.get(object.getClass())) {
                    if (!((Boolean)describes.get(property).invoke(null, object)).booleanValue()) continue;
                    props.add((Property)getFrom.get(property).invoke(null, object));
                }
            }
        }
        catch (IllegalAccessException e) {
            dB.echoError(e);
        }
        catch (InvocationTargetException e) {
            dB.echoError(e);
        }
        return props;
    }
}

