/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizencore.scripts.queues;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.aufdemrand.denizencore.DenizenCore;
import net.aufdemrand.denizencore.events.ScriptEvent;
import net.aufdemrand.denizencore.interfaces.ContextSource;
import net.aufdemrand.denizencore.objects.Duration;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.Fetchable;
import net.aufdemrand.denizencore.objects.ObjectFetcher;
import net.aufdemrand.denizencore.objects.TagRunnable;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.objects.dScript;
import net.aufdemrand.denizencore.objects.properties.Property;
import net.aufdemrand.denizencore.objects.properties.PropertyParser;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.commands.core.DetermineCommand;
import net.aufdemrand.denizencore.scripts.queues.core.TimedQueue;
import net.aufdemrand.denizencore.tags.Attribute;
import net.aufdemrand.denizencore.tags.TagContext;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import net.aufdemrand.denizencore.utilities.QueueWordList;
import net.aufdemrand.denizencore.utilities.debugging.Debuggable;
import net.aufdemrand.denizencore.utilities.debugging.dB;
import net.aufdemrand.denizencore.utilities.scheduling.AsyncSchedulable;
import net.aufdemrand.denizencore.utilities.scheduling.OneTimeSchedulable;
import net.aufdemrand.denizencore.utilities.scheduling.Schedulable;

public abstract class ScriptQueue
implements Debuggable,
dObject {
    private static final Map<Class<? extends ScriptQueue>, String> classNameCache = new HashMap<Class<? extends ScriptQueue>, String>();
    protected static long total_queues = 0L;
    protected static Map<String, ScriptQueue> _queues = new ConcurrentHashMap<String, ScriptQueue>(8, 0.9f, 1);
    public String id;
    public boolean was_cleared = false;
    public boolean run_async = false;
    private final List<ScriptEntry> script_entries = new ArrayList<ScriptEntry>();
    private ScriptEntry lastEntryExecuted = null;
    private long delay_time = 0L;
    private final Map<String, String> definitions = new ConcurrentHashMap<String, String>(8, 0.9f, 1);
    private final Map<String, ScriptEntry> held_entries = new ConcurrentHashMap<String, ScriptEntry>(8, 0.9f, 1);
    private dScript script;
    private ContextSource cs = null;
    public HashMap<String, dObject> cachedContext;
    private long reqId = -1L;
    protected boolean is_started;
    private Class<? extends ScriptQueue> cachedClass;
    public long startTime = 0L;
    private long startTimeMilli = 0L;
    private Runnable callback = null;
    private String breakMe = null;
    protected boolean is_stopping = false;
    public boolean hasInjectedItems = false;
    String prefix = "Queue";
    public static HashMap<String, TagRunnable> registeredTags = new HashMap();

    public static String _getStats() {
        StringBuilder stats = new StringBuilder();
        for (ScriptEvent event : ScriptEvent.events) {
            stats.append("Event '" + event.getName() + "' ran " + event.fires + " times (" + event.scriptFires + " script fires)" + ", totalling " + (float)event.nanoTimes / 1000000.0f + "ms, averaging " + (float)event.nanoTimes / 1000000.0f / (float)event.fires + "ms per event or " + (float)event.nanoTimes / 1000000.0f / (float)event.scriptFires + "ms per script.\n");
        }
        return "Total number of queues created: " + total_queues + ", currently active queues: " + _queues.size() + ",\n" + stats.toString();
    }

    public static ScriptQueue _getExistingQueue(String id) {
        if (!ScriptQueue._queueExists(id)) {
            return null;
        }
        return _queues.get(id);
    }

    public static String getNextId(String prefix) {
        int size = QueueWordList.FinalWordList.size();
        String id = prefix + "_" + QueueWordList.FinalWordList.get(CoreUtilities.getRandom().nextInt(size)) + QueueWordList.FinalWordList.get(CoreUtilities.getRandom().nextInt(size)) + QueueWordList.FinalWordList.get(CoreUtilities.getRandom().nextInt(size));
        return _queues.containsKey(id) ? ScriptQueue.getNextId(prefix) : id;
    }

    public static boolean _matchesType(String queue, Class type) {
        return ScriptQueue._queueExists(queue) && _queues.get(queue).getClass() == type;
    }

    public static Collection<ScriptQueue> _getQueues() {
        return _queues.values();
    }

    public static boolean _queueExists(String id) {
        return _queues.containsKey(id);
    }

    protected ScriptQueue(String id) {
        this.id = id;
        ++total_queues;
    }

    protected ScriptQueue(String id, boolean async) {
        this(id);
        this.run_async = async;
    }

    public boolean getWasCleared() {
        return this.was_cleared;
    }

    public ScriptEntry getHeldScriptEntry(String id) {
        return this.held_entries.get(id.toLowerCase());
    }

    public ScriptQueue holdScriptEntry(String id, ScriptEntry entry) {
        this.held_entries.put(id.toLowerCase(), entry);
        return this;
    }

    public dObject getContext(String id) {
        id = CoreUtilities.toLowerCase(id);
        if (this.cs == null) {
            return null;
        }
        dObject obj = this.cachedContext.get(id);
        if (obj != null) {
            return obj;
        }
        obj = this.cs.getContext(id);
        if (obj != null && this.cs.getShouldCache()) {
            this.cachedContext.put(id, obj);
        }
        return obj;
    }

    public void setContextSource(ContextSource source) {
        this.cs = source;
        this.cachedContext = new HashMap();
    }

    public ScriptQueue setReqId(long ID2) {
        this.reqId = ID2;
        return this;
    }

    public String getDefinition(String definition) {
        if (definition == null) {
            return null;
        }
        return this.definitions.get(definition.toLowerCase());
    }

    public boolean hasDefinition(String definition) {
        return this.definitions.containsKey(definition.toLowerCase());
    }

    public void addDefinition(String definition, String value) {
        this.definitions.put(definition.toLowerCase(), value);
    }

    public void removeDefinition(String definition) {
        this.definitions.remove(definition.toLowerCase());
    }

    public Map<String, String> getAllDefinitions() {
        return this.definitions;
    }

    public ScriptEntry getLastEntryExecuted() {
        return this.lastEntryExecuted;
    }

    public void clear() {
        this.was_cleared = true;
        this.script_entries.clear();
    }

    public void delayUntil(long delayTime) {
        this.delay_time = delayTime;
    }

    public TimedQueue forceToTimed(Duration delay) {
        Runnable r = this.callback;
        this.callback = null;
        this.stop();
        TimedQueue newQueue = TimedQueue.getQueue(this.id);
        newQueue.run_async = this.run_async;
        for (ScriptEntry scriptEntry : this.getEntries()) {
            scriptEntry.setInstant(true);
        }
        newQueue.addEntries(this.getEntries());
        for (Map.Entry entry : this.getAllDefinitions().entrySet()) {
            newQueue.addDefinition((String)entry.getKey(), (String)entry.getValue());
        }
        newQueue.setContextSource(this.cs);
        newQueue.cachedContext = this.cachedContext;
        for (Map.Entry entry : this.held_entries.entrySet()) {
            newQueue.holdScriptEntry((String)entry.getKey(), (ScriptEntry)entry.getValue());
        }
        newQueue.setLastEntryExecuted(this.getLastEntryExecuted());
        newQueue.setSpeed(1L);
        this.clear();
        if (delay != null) {
            newQueue.delayFor(delay);
        }
        newQueue.callBack(r);
        newQueue.start();
        return newQueue;
    }

    protected abstract void onStart();

    public void start() {
        Class<? extends ScriptQueue> clazz;
        String name;
        boolean is_delayed;
        if (this.is_started) {
            return;
        }
        _queues.put(this.id, this);
        this.is_started = true;
        boolean bl = is_delayed = this.delay_time > System.currentTimeMillis();
        if (this.script_entries.size() > 0) {
            this.script = this.script_entries.get(0).getScript();
        }
        if ((name = classNameCache.get(clazz = this.cachedClass == null ? (this.cachedClass = this.getClass()) : this.cachedClass)) == null) {
            name = clazz.getSimpleName();
            classNameCache.put(clazz, name);
        }
        if (is_delayed) {
            dB.echoDebug((Debuggable)this, "Delaying " + name + " '" + this.id + "'" + " for '" + new Duration((double)(this.delay_time - System.currentTimeMillis()) / 1000.0).identify() + "'...");
        } else {
            dB.echoDebug((Debuggable)this, "Starting " + name + " '" + this.id + "'...");
        }
        Runnable runToStart = new Runnable(){

            @Override
            public void run() {
                ScriptQueue.this.startTime = System.nanoTime();
                ScriptQueue.this.startTimeMilli = System.currentTimeMillis();
                ScriptQueue.this.onStart();
            }
        };
        if (is_delayed) {
            Schedulable schedulable = new OneTimeSchedulable(runToStart, (float)(this.delay_time - System.currentTimeMillis()) / 1000.0f);
            if (this.run_async) {
                schedulable = new AsyncSchedulable(schedulable);
            }
            DenizenCore.schedule(schedulable);
        } else if (!this.run_async) {
            runToStart.run();
        } else {
            AsyncSchedulable.executor.execute(runToStart);
        }
    }

    public String runNow(List<ScriptEntry> entries, String type) {
        ScriptEntry nextup;
        this.injectEntries(entries, 0);
        ScriptEntry scriptEntry = nextup = this.getQueueSize() > entries.size() ? this.getEntry(entries.size()) : null;
        while (this.getQueueSize() > 0 && this.getEntry(0) != nextup && !this.was_cleared) {
            if (this.breakMe != null) {
                this.removeEntry(0);
                continue;
            }
            this.getEntry(0).setInstant(false);
            this.getEntry(0).setFinished(true);
            DenizenCore.getScriptEngine().revolve(this);
        }
        if (this.breakMe != null && this.breakMe.startsWith(type)) {
            String origBreakMe = this.breakMe;
            this.breakMe = null;
            return origBreakMe;
        }
        return null;
    }

    public void callBack(Runnable r) {
        this.callback = r;
    }

    public void breakLoop(String toBreak) {
        this.breakMe = toBreak;
    }

    public String isLoopBroken() {
        return this.breakMe;
    }

    protected abstract void onStop();

    public void stop() {
        if (!this.is_stopping) {
            ArrayList entries;
            this.is_stopping = true;
            List<Object> list = entries = this.lastEntryExecuted != null && this.lastEntryExecuted.getScript() != null ? this.lastEntryExecuted.getScript().getContainer().getEntries(this.lastEntryExecuted.entryData.clone(), "on queue completes") : new ArrayList();
            if (!entries.isEmpty()) {
                this.script_entries.addAll(entries);
                dB.echoDebug((Debuggable)this, "Finishing up queue '" + this.id + "'...");
            } else {
                if (_queues.get(this.id) == this) {
                    _queues.remove(this.id);
                }
                dB.echoDebug((Debuggable)this, "Completing queue '" + this.id + "' in " + (System.nanoTime() - this.startTime) / 1000000L + "ms.");
                if (this.callback != null) {
                    this.callback.run();
                }
                this.is_started = false;
                this.onStop();
            }
        } else if (_queues.get(this.id) == this) {
            _queues.remove(this.id);
            dB.echoDebug((Debuggable)this, "Re-completing queue '" + this.id + "' in " + (System.nanoTime() - this.startTime) / 1000000L + "ms.");
            if (this.callback != null) {
                this.callback.run();
            }
            this.is_started = false;
            this.onStop();
        }
    }

    public void setLastEntryExecuted(ScriptEntry entry) {
        this.lastEntryExecuted = entry;
    }

    protected abstract boolean shouldRevolve();

    protected void revolve() {
        if (this.script_entries.isEmpty()) {
            this.stop();
            return;
        }
        if (!this.shouldRevolve()) {
            return;
        }
        DenizenCore.getScriptEngine().revolve(this);
        if (this.script_entries.isEmpty()) {
            this.stop();
        }
    }

    public ScriptEntry getNext() {
        if (!this.script_entries.isEmpty()) {
            return this.script_entries.remove(0);
        }
        return null;
    }

    public ScriptQueue addEntries(List<ScriptEntry> entries) {
        this.script_entries.addAll(entries);
        return this;
    }

    public List<ScriptEntry> getEntries() {
        return this.script_entries;
    }

    public ScriptQueue injectEntries(List<ScriptEntry> entries, int position) {
        if (position > this.script_entries.size() || position < 0) {
            position = 1;
        }
        if (this.script_entries.size() == 0) {
            position = 0;
        }
        this.script_entries.addAll(position, entries);
        this.hasInjectedItems = true;
        return this;
    }

    public boolean removeEntry(int position) {
        if (this.script_entries.size() < position) {
            return false;
        }
        this.script_entries.remove(position);
        return true;
    }

    public ScriptEntry getEntry(int position) {
        if (this.script_entries.size() < position) {
            return null;
        }
        return this.script_entries.get(position);
    }

    public ScriptQueue injectEntry(ScriptEntry entry, int position) {
        if (position > this.script_entries.size() || position < 0) {
            position = 1;
        }
        if (this.script_entries.size() == 0) {
            position = 0;
        }
        this.script_entries.add(position, entry);
        this.hasInjectedItems = true;
        return this;
    }

    public int getQueueSize() {
        return this.script_entries.size();
    }

    @Override
    public boolean shouldDebug() throws Exception {
        return this.lastEntryExecuted != null ? this.lastEntryExecuted.shouldDebug() : this.script_entries.get(0).shouldDebug();
    }

    @Override
    public boolean shouldFilter(String criteria) throws Exception {
        return this.lastEntryExecuted != null ? this.lastEntryExecuted.getScript().getName().equalsIgnoreCase(criteria.replace("s@", "")) : this.script_entries.get(0).getScript().getName().equalsIgnoreCase(criteria.replace("s@", ""));
    }

    public static ScriptQueue valueOf(String string) {
        return ScriptQueue.valueOf(string, null);
    }

    @Fetchable(value="q")
    public static ScriptQueue valueOf(String string, TagContext context) {
        if (string == null) {
            return null;
        }
        if (string.startsWith("q@") && string.length() > 2) {
            string = string.substring(2);
        }
        if (ScriptQueue._queueExists(string)) {
            return ScriptQueue._getExistingQueue(string);
        }
        return null;
    }

    public static boolean matches(String string) {
        return string.toLowerCase().startsWith("q@");
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public ScriptQueue setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    @Override
    public String debug() {
        return "<G>" + this.prefix + "='<Y>" + this.identify() + "<G>'  ";
    }

    @Override
    public boolean isUnique() {
        return true;
    }

    @Override
    public String getObjectType() {
        return "queue";
    }

    @Override
    public String identify() {
        return "q@" + this.id;
    }

    @Override
    public String identifySimple() {
        return this.identify();
    }

    public String toString() {
        return this.identify();
    }

    public static void registerTags() {
        ScriptQueue.registerTag("id", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                return new Element(((ScriptQueue)object).id).getAttribute(attribute.fulfill(1));
            }
        });
        ScriptQueue.registerTag("size", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                return new Element(((ScriptQueue)object).script_entries.size()).getAttribute(attribute.fulfill(1));
            }
        });
        ScriptQueue.registerTag("start_time", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                return new Duration(((ScriptQueue)object).startTimeMilli / 50L).getAttribute(attribute.fulfill(1));
            }
        });
        ScriptQueue.registerTag("state", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                String state = ((ScriptQueue)object).is_started ? "running" : (((ScriptQueue)object).is_stopping ? "stopping" : "unknown");
                return new Element(state).getAttribute(attribute.fulfill(1));
            }
        });
        ScriptQueue.registerTag("script", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                if (((ScriptQueue)object).script == null) {
                    return null;
                }
                return ((ScriptQueue)object).script.getAttribute(attribute.fulfill(1));
            }
        });
        ScriptQueue.registerTag("commands", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                dList commands = new dList();
                for (ScriptEntry entry : ((ScriptQueue)object).script_entries) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(entry.getCommandName()).append(" ");
                    for (String arg : entry.getOriginalArguments()) {
                        sb.append(arg).append(" ");
                    }
                    commands.add(sb.substring(0, sb.length() - 1));
                }
                return commands.getAttribute(attribute.fulfill(1));
            }
        });
        ScriptQueue.registerTag("definitions", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                return new dList(((ScriptQueue)object).getAllDefinitions().keySet()).getAttribute(attribute.fulfill(1));
            }
        });
        ScriptQueue.registerTag("definition", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                if (!attribute.hasContext(1)) {
                    dB.echoError("The tag q@queue.definition[...] must have a value.");
                    return null;
                }
                return new Element(((ScriptQueue)object).getDefinition(attribute.getContext(1))).getAttribute(attribute.fulfill(1));
            }
        });
        ScriptQueue.registerTag("determination", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                Long rID = ((ScriptQueue)object).reqId;
                if (rID < 0L || !DetermineCommand.hasOutcome(rID)) {
                    return null;
                }
                return ObjectFetcher.pickObjectFor(DetermineCommand.readOutcome(rID)).getAttribute(attribute.fulfill(1));
            }
        });
    }

    public static void registerTag(String name, TagRunnable runnable) {
        if (runnable.name == null) {
            runnable.name = name;
        }
        registeredTags.put(name, runnable);
    }

    @Override
    public String getAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        String attrLow = CoreUtilities.toLowerCase(attribute.getAttributeWithoutContext(1));
        TagRunnable tr = registeredTags.get(attrLow);
        if (tr != null) {
            if (!tr.name.equals(attrLow)) {
                dB.echoError(attribute.getScriptEntry() != null ? attribute.getScriptEntry().getResidingQueue() : null, "Using deprecated form of tag '" + tr.name + "': '" + attrLow + "'.");
            }
            return tr.run(attribute, this);
        }
        for (Property property : PropertyParser.getProperties(this)) {
            String returned = property.getAttribute(attribute);
            if (returned == null) continue;
            return returned;
        }
        return new Element(this.identify()).getAttribute(attribute);
    }
}

