/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.block;

import net.aufdemrand.denizen.events.BukkitScriptEvent;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.objects.dMaterial;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockCanBuildEvent;
import org.bukkit.plugin.Plugin;

public class BlockBuiltScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static BlockBuiltScriptEvent instance;
    public dLocation location;
    public dMaterial old_material;
    public dMaterial new_material;
    public BlockCanBuildEvent event;

    public BlockBuiltScriptEvent() {
        instance = this;
    }

    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        return lower.contains(" being built");
    }

    public boolean matches(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        if (!this.runInCheck(scriptContainer, s, lower, this.location)) {
            return false;
        }
        String mat1 = CoreUtilities.getXthArg(0, lower);
        if (!this.tryMaterial(this.new_material, mat1)) {
            return false;
        }
        String mat2 = CoreUtilities.getXthArg(4, lower);
        return mat2.length() <= 0 || this.tryMaterial(this.old_material, mat2);
    }

    public String getName() {
        return "BlockBuilt";
    }

    public void init() {
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
    }

    public void destroy() {
        BlockCanBuildEvent.getHandlerList().unregister((Listener)this);
    }

    public boolean applyDetermination(ScriptContainer container, String determination) {
        String lower = CoreUtilities.toLowerCase(determination);
        if (lower.equals("buildable")) {
            this.cancelled = false;
        }
        return super.applyDetermination(container, determination);
    }

    public dObject getContext(String name) {
        if (name.equals("location")) {
            return this.location;
        }
        if (name.equals("new_material")) {
            return this.new_material;
        }
        if (name.equals("old_material")) {
            return this.old_material;
        }
        return super.getContext(name);
    }

    @EventHandler(ignoreCancelled=true)
    public void onBlockBuilt(BlockCanBuildEvent event) {
        this.location = new dLocation(event.getBlock().getLocation());
        this.old_material = dMaterial.getMaterialFrom(event.getBlock().getType(), event.getBlock().getData());
        this.new_material = dMaterial.getMaterialFrom(event.getMaterial());
        this.cancelled = !event.isBuildable();
        this.event = event;
        this.fire();
        event.setBuildable(!this.cancelled);
    }
}

