/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.player;

import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizencore.events.ScriptEvent;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.server.ServerListPingEvent;
import org.bukkit.plugin.Plugin;

public class ListPingScriptEvent
extends ScriptEvent
implements Listener {
    public static ListPingScriptEvent instance;
    public Element motd;
    public Element max_players;
    public Element num_players;
    public Element address;
    public ServerListPingEvent event;

    public ListPingScriptEvent() {
        instance = this;
    }

    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        return lower.startsWith("server list ping");
    }

    public boolean matches(ScriptContainer scriptContainer, String s) {
        return true;
    }

    public String getName() {
        return "ServerListPing";
    }

    public void init() {
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
    }

    public void destroy() {
        ServerListPingEvent.getHandlerList().unregister((Listener)this);
    }

    public boolean applyDetermination(ScriptContainer container, String determination) {
        if (determination.length() > 0 && !determination.equalsIgnoreCase("none")) {
            String[] values = determination.split("[\\|" + dList.internal_escape + "]", 2);
            if (new Element(values[0]).isInt()) {
                this.max_players = new Element(values[0]);
                if (values.length == 1) {
                    return true;
                }
            }
            this.motd = values.length == 2 ? new Element(values[1]) : new Element(values[0]);
        }
        return true;
    }

    public dObject getContext(String name) {
        if (name.equals("motd")) {
            return this.motd;
        }
        if (name.equals("max_players")) {
            return this.max_players;
        }
        if (name.equals("num_players")) {
            return this.num_players;
        }
        if (name.equals("address")) {
            return this.address;
        }
        return super.getContext(name);
    }

    @EventHandler(ignoreCancelled=true)
    public void onListPing(ServerListPingEvent event) {
        this.motd = new Element(event.getMotd());
        this.max_players = new Element(event.getMaxPlayers());
        this.num_players = new Element(event.getNumPlayers());
        this.address = new Element(event.getAddress().toString());
        this.event = event;
        this.fire();
        event.setMaxPlayers(this.max_players.asInt());
        event.setMotd(this.motd.asString());
    }
}

