/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.player;

import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.events.BukkitScriptEvent;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.ScriptEntryData;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerBedEnterEvent;
import org.bukkit.plugin.Plugin;

public class PlayerEntersBedScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static PlayerEntersBedScriptEvent instance;
    public dLocation location;
    public PlayerBedEnterEvent event;

    public PlayerEntersBedScriptEvent() {
        instance = this;
    }

    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        return CoreUtilities.toLowerCase(s).startsWith("player enters bed");
    }

    public boolean matches(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        return this.runInCheck(scriptContainer, s, lower, this.location);
    }

    public String getName() {
        return "PlayerEntersBed";
    }

    public void init() {
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
    }

    public void destroy() {
        PlayerBedEnterEvent.getHandlerList().unregister((Listener)this);
    }

    public boolean applyDetermination(ScriptContainer container, String determination) {
        return super.applyDetermination(container, determination);
    }

    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(dEntity.isPlayer((Entity)this.event.getPlayer()) ? dEntity.getPlayerFrom((Entity)this.event.getPlayer()) : null, null);
    }

    public dObject getContext(String name) {
        if (name.equals("location")) {
            return this.location;
        }
        return super.getContext(name);
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerEntersBed(PlayerBedEnterEvent event) {
        if (dEntity.isNPC((Entity)event.getPlayer())) {
            return;
        }
        this.location = new dLocation(event.getBed().getLocation());
        this.cancelled = event.isCancelled();
        this.event = event;
        this.fire();
        event.setCancelled(this.cancelled);
    }
}

