/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.player;

import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.events.BukkitScriptEvent;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.ScriptEntryData;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerPortalEvent;
import org.bukkit.plugin.Plugin;

public class PlayerUsesPortalScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static PlayerUsesPortalScriptEvent instance;
    public dEntity entity;
    public dLocation to;
    public dLocation from;
    public PlayerPortalEvent event;

    public PlayerUsesPortalScriptEvent() {
        instance = this;
    }

    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        return CoreUtilities.toLowerCase(s).startsWith("player uses portal");
    }

    public boolean matches(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        return this.runInCheck(scriptContainer, s, lower, this.to) || this.runInCheck(scriptContainer, s, lower, this.from);
    }

    public String getName() {
        return "PlayerUsesPortal";
    }

    public void init() {
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
    }

    public void destroy() {
        PlayerPortalEvent.getHandlerList().unregister((Listener)this);
    }

    public boolean applyDetermination(ScriptContainer container, String determination) {
        if (dLocation.matches(determination)) {
            this.to = dLocation.valueOf(determination);
            return true;
        }
        return super.applyDetermination(container, determination);
    }

    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.entity.isPlayer() ? this.entity.getDenizenPlayer() : null, null);
    }

    public dObject getContext(String name) {
        if (name.equals("entity")) {
            return this.entity;
        }
        if (name.equals("to")) {
            return this.to;
        }
        if (name.equals("from")) {
            return this.from;
        }
        return super.getContext(name);
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerEntersPortal(PlayerPortalEvent event) {
        if (dEntity.isNPC((Entity)event.getPlayer())) {
            return;
        }
        this.entity = new dEntity((Entity)event.getPlayer());
        this.to = new dLocation(event.getTo());
        this.from = new dLocation(event.getFrom());
        this.cancelled = event.isCancelled();
        this.event = event;
        this.fire();
        event.setCancelled(this.cancelled);
        event.setTo((Location)this.to);
    }
}

