/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.world;

import net.aufdemrand.denizen.events.BukkitScriptEvent;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.objects.dWorld;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.weather.LightningStrikeEvent;
import org.bukkit.plugin.Plugin;

public class LightningStrikesScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static LightningStrikesScriptEvent instance;
    public dEntity lightning;
    public dLocation location;
    public LightningStrikeEvent event;

    public LightningStrikesScriptEvent() {
        instance = this;
    }

    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        return CoreUtilities.toLowerCase(s).startsWith("lightning strikes");
    }

    public boolean matches(ScriptContainer scriptContainer, String s) {
        return this.runInCheck(scriptContainer, s, CoreUtilities.toLowerCase(s), this.location);
    }

    public String getName() {
        return "LightningStrikes";
    }

    public void init() {
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
    }

    public void destroy() {
        LightningStrikeEvent.getHandlerList().unregister((Listener)this);
    }

    public boolean applyDetermination(ScriptContainer container, String determination) {
        return super.applyDetermination(container, determination);
    }

    public dObject getContext(String name) {
        if (name.equals("lightning")) {
            return this.lightning;
        }
        if (name.equals("location")) {
            return this.location;
        }
        if (name.equals("world")) {
            return new dWorld(this.location.getWorld());
        }
        return super.getContext(name);
    }

    @EventHandler(ignoreCancelled=true)
    public void onLightningStrikes(LightningStrikeEvent event) {
        this.lightning = new dEntity((Entity)event.getLightning());
        this.location = new dLocation(event.getLightning().getLocation());
        this.event = event;
        this.cancelled = event.isCancelled();
        this.fire();
        event.setCancelled(this.cancelled);
    }
}

