/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.world;

import net.aufdemrand.denizen.events.BukkitScriptEvent;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.objects.dMaterial;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.Bukkit;
import org.bukkit.block.Block;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.plugin.Plugin;

public class PistonExtendsScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static PistonExtendsScriptEvent instance;
    public dLocation location;
    public dMaterial material;
    public Element length;
    public dList blocks;
    public Element sticky;
    public dLocation relative;
    public BlockPistonExtendEvent event;

    public PistonExtendsScriptEvent() {
        instance = this;
    }

    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        String cmd = CoreUtilities.getXthArg(1, lower);
        return cmd.equals("extends");
    }

    public boolean matches(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        String mat = CoreUtilities.getXthArg(0, lower);
        return (mat.equals("piston") || this.tryMaterial(this.material, mat)) && this.runInCheck(scriptContainer, s, lower, this.location);
    }

    public String getName() {
        return "PistonExtends";
    }

    public void init() {
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
    }

    public void destroy() {
        BlockPistonExtendEvent.getHandlerList().unregister((Listener)this);
    }

    public boolean applyDetermination(ScriptContainer container, String determination) {
        return super.applyDetermination(container, determination);
    }

    public dObject getContext(String name) {
        if (name.equals("location")) {
            return this.location;
        }
        if (name.equals("material")) {
            return this.material;
        }
        if (name.equals("sticky")) {
            return this.sticky;
        }
        if (name.equals("relative")) {
            return this.relative;
        }
        if (name.equals("blocks")) {
            return this.blocks;
        }
        if (name.equals("length")) {
            return this.length;
        }
        return super.getContext(name);
    }

    @EventHandler(ignoreCancelled=true)
    public void onPistonExtends(BlockPistonExtendEvent event) {
        this.location = new dLocation(event.getBlock().getLocation());
        this.material = dMaterial.getMaterialFrom(event.getBlock().getType(), event.getBlock().getData());
        this.sticky = new Element(event.isSticky() ? "true" : "false");
        this.relative = new dLocation(event.getBlock().getRelative(event.getDirection()).getLocation());
        this.blocks = new dList();
        for (Block block : event.getBlocks()) {
            this.blocks.add(new dLocation(block.getLocation()).identify());
        }
        this.length = new Element(this.blocks.size());
        this.cancelled = event.isCancelled();
        this.event = event;
        this.fire();
        event.setCancelled(this.cancelled);
    }
}

