/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.world;

import net.aufdemrand.denizen.events.BukkitScriptEvent;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.objects.dWorld;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.Bukkit;
import org.bukkit.block.Block;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.world.PortalCreateEvent;
import org.bukkit.plugin.Plugin;

public class PortalCreateScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static PortalCreateScriptEvent instance;
    public dWorld world;
    public Element reason;
    public dList blocks;
    public PortalCreateEvent event;

    public PortalCreateScriptEvent() {
        instance = this;
    }

    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        return CoreUtilities.toLowerCase(s).startsWith("portal created");
    }

    public boolean matches(ScriptContainer scriptContainer, String s) {
        String rCheck;
        String lower = CoreUtilities.toLowerCase(s);
        String string = rCheck = CoreUtilities.getXthArg(2, lower).equals("because") ? CoreUtilities.getXthArg(3, lower) : CoreUtilities.getXthArg(5, lower);
        if (rCheck.length() > 0 && !rCheck.equals(CoreUtilities.toLowerCase(this.reason.asString()))) {
            return false;
        }
        return this.runInCheck(scriptContainer, s, lower, dLocation.valueOf((String)this.blocks.get(0)));
    }

    public String getName() {
        return "PortalCreate";
    }

    public void init() {
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
    }

    public void destroy() {
        PortalCreateEvent.getHandlerList().unregister((Listener)this);
    }

    public boolean applyDetermination(ScriptContainer container, String determination) {
        return super.applyDetermination(container, determination);
    }

    public dObject getContext(String name) {
        if (name.equals("world")) {
            return this.world;
        }
        if (name.equals("reason")) {
            return this.reason;
        }
        if (name.equals("blocks")) {
            return this.blocks;
        }
        return super.getContext(name);
    }

    @EventHandler(ignoreCancelled=true)
    public void onPortalCreate(PortalCreateEvent event) {
        this.world = new dWorld(event.getWorld());
        this.reason = new Element(event.getReason().toString());
        this.blocks = new dList();
        for (Block block : event.getBlocks()) {
            this.blocks.add(new dLocation(block.getLocation()).identify());
        }
        this.event = event;
        this.cancelled = event.isCancelled();
        this.fire();
        event.setCancelled(this.cancelled);
    }
}

