/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.listeners;

import net.aufdemrand.denizen.Denizen;
import net.aufdemrand.denizen.listeners.AbstractListener;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.interfaces.RegistrationableInstance;
import org.bukkit.Bukkit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractListenerType
implements RegistrationableInstance {
    Denizen denizen;
    String name;
    Class<? extends AbstractListener> instanceClass;

    @Override
    public AbstractListenerType activate() {
        this.denizen = (Denizen)Bukkit.getServer().getPluginManager().getPlugin("Denizen");
        return this;
    }

    @Override
    public AbstractListenerType as(String type) {
        this.name = type.toUpperCase();
        this.denizen.getListenerRegistry().register(this.name, this);
        this.onEnable();
        return this;
    }

    public AbstractListener createInstance(dPlayer player, String listenerId) {
        try {
            this.denizen.getListenerRegistry().addListenerFor(player, this.instanceClass.newInstance(), listenerId);
            return this.denizen.getListenerRegistry().getListenerFor(player, listenerId);
        }
        catch (InstantiationException e) {
            dB.echoError(e);
        }
        catch (IllegalAccessException e) {
            dB.echoError(e);
        }
        return null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void onDisable() {
    }

    public AbstractListenerType withClass(Class<? extends AbstractListener> listenerInstanceClass) {
        this.instanceClass = listenerInstanceClass;
        return null;
    }
}

