/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.npc.traits;

import java.util.HashMap;
import net.aufdemrand.denizen.Settings;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.objects.dNPC;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.tags.BukkitTagContext;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizencore.objects.Duration;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.tags.TagManager;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.event.DespawnReason;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByBlockEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.projectiles.ProjectileSource;

public class HealthTrait
extends Trait
implements Listener {
    @Persist(value="animatedeath")
    private boolean animatedeath = Settings.healthTraitAnimatedDeathEnabled();
    @Persist(value="respawnondeath")
    private boolean respawn = Settings.healthTraitRespawnEnabled();
    @Persist(value="respawndelayinseconds")
    private String respawnDelay = Settings.healthTraitRespawnDelay();
    @Persist(value="respawnlocation")
    private String respawnLocation = "<npc.flag[respawn_location] || <npc.location>>";
    private dPlayer player = null;
    private boolean dying = false;
    private Location loc;
    private int entityId = -1;
    public Integer void_watcher_task = null;

    public Duration getRespawnDelay() {
        return Duration.valueOf(this.respawnDelay);
    }

    public void setRespawnLocation(String string) {
        if (aH.matchesLocation("location:" + string)) {
            this.respawnLocation = string;
        }
    }

    public void setRespawnDelay(int seconds) {
        this.respawnDelay = String.valueOf(seconds);
    }

    public void setRespawnDelay(String string) {
        if (aH.matchesDuration("duration:" + string)) {
            this.respawnDelay = string;
        }
    }

    public String getRespawnLocationAsString() {
        return this.respawnLocation;
    }

    public Location getRespawnLocation() {
        return dLocation.valueOf(TagManager.tag(this.respawnLocation, new BukkitTagContext(null, dNPC.mirrorCitizensNPC(this.npc), false, null, false, null)));
    }

    public void setRespawnable(boolean respawnable) {
        this.respawn = respawnable;
    }

    public boolean isRespawnable() {
        return this.respawn;
    }

    public void animateOnDeath(boolean animate) {
        this.animatedeath = animate;
    }

    public boolean animatesOnDeath() {
        return this.animatedeath;
    }

    public void onSpawn() {
        this.dying = false;
        this.setHealth();
        this.void_watcher_task = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)DenizenAPI.getCurrentInstance(), new Runnable(){

            public void run() {
                if (!HealthTrait.this.npc.isSpawned()) {
                    Bukkit.getScheduler().cancelTask(HealthTrait.this.void_watcher_task.intValue());
                    return;
                }
                if (HealthTrait.this.npc.getEntity().getLocation().getY() < -1000.0) {
                    HealthTrait.this.npc.despawn(DespawnReason.DEATH);
                    if (HealthTrait.this.respawn) {
                        if (HealthTrait.this.npc.isSpawned()) {
                            HealthTrait.this.npc.getEntity().teleport(HealthTrait.this.getRespawnLocation());
                        } else {
                            HealthTrait.this.npc.spawn(HealthTrait.this.getRespawnLocation());
                        }
                    }
                }
            }
        }, 200L, 200L);
    }

    public HealthTrait() {
        super("health");
    }

    public double getHealth() {
        if (!this.npc.isSpawned()) {
            return 0.0;
        }
        return ((LivingEntity)this.npc.getEntity()).getHealth();
    }

    public void setMaxhealth(int newMax) {
        ((LivingEntity)this.npc.getEntity()).setMaxHealth((double)newMax);
    }

    public double getMaxhealth() {
        return ((LivingEntity)this.npc.getEntity()).getMaxHealth();
    }

    public void heal(int health) {
        this.setHealth(this.getHealth() + (double)health);
    }

    public void setHealth() {
        this.setHealth(((LivingEntity)this.npc.getEntity()).getMaxHealth());
    }

    public void setHealth(double health) {
        if (this.npc.getEntity() != null) {
            ((LivingEntity)this.npc.getEntity()).setHealth(health);
        }
    }

    public void die() {
        ((LivingEntity)this.npc.getEntity()).damage(((LivingEntity)this.npc.getEntity()).getHealth());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onDeath(EntityDeathEvent event) {
        if (event.getEntity().getEntityId() != this.entityId) {
            return;
        }
        event.getDrops().clear();
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onDamage(EntityDamageEvent event) {
        if (event.getEntity() != this.npc.getEntity() || this.dying) {
            return;
        }
        if (this.getHealth() - event.getFinalDamage() > 0.0) {
            return;
        }
        this.dying = true;
        this.player = null;
        this.entityId = this.npc.getEntity().getEntityId();
        String deathCause = event.getCause().toString().toLowerCase().replace('_', ' ');
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        context.put("damage", new Element(event.getDamage()));
        context.put("death_cause", new Element(deathCause));
        if (event instanceof EntityDamageByEntityEvent) {
            ProjectileSource shooter;
            Entity killerEntity = ((EntityDamageByEntityEvent)event).getDamager();
            context.put("killer", new dEntity(killerEntity));
            if (killerEntity instanceof Player) {
                this.player = dPlayer.mirrorBukkitPlayer((OfflinePlayer)((Player)killerEntity));
            } else if (killerEntity instanceof Projectile && (shooter = ((Projectile)killerEntity).getShooter()) != null && shooter instanceof LivingEntity) {
                context.put("shooter", new dEntity((Entity)((LivingEntity)shooter)));
                if (shooter instanceof Player) {
                    this.player = dPlayer.mirrorBukkitPlayer((OfflinePlayer)((Player)shooter));
                }
                DenizenAPI.getDenizenNPC(this.npc).action("death by " + ((LivingEntity)shooter).getType().toString(), this.player, context);
            }
            DenizenAPI.getDenizenNPC(this.npc).action("death by entity", this.player, context);
            DenizenAPI.getDenizenNPC(this.npc).action("death by " + killerEntity.getType().toString(), this.player, context);
        } else if (event instanceof EntityDamageByBlockEvent) {
            DenizenAPI.getDenizenNPC(this.npc).action("death by block", this.player, context);
        }
        DenizenAPI.getDenizenNPC(this.npc).action("death", this.player, context);
        DenizenAPI.getDenizenNPC(this.npc).action("death by " + deathCause, this.player, context);
        if (this.npc.getEntity() == null) {
            return;
        }
        this.loc = dLocation.valueOf(TagManager.tag(this.respawnLocation, new BukkitTagContext(null, DenizenAPI.getDenizenNPC(this.npc), false, null, true, null)));
        if (this.loc == null) {
            this.loc = this.npc.getEntity().getLocation();
        }
        if (this.animatedeath) {
            this.npc.getNavigator().cancelNavigation();
        }
        this.die();
        if (this.respawn && Duration.valueOf(this.respawnDelay).getTicks() > 0L) {
            Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)DenizenAPI.getCurrentInstance(), new Runnable(){

                public void run() {
                    if (CitizensAPI.getNPCRegistry().getById(HealthTrait.this.npc.getId()) == null || HealthTrait.this.npc.isSpawned()) {
                        return;
                    }
                    HealthTrait.this.npc.spawn(HealthTrait.this.loc);
                }
            }, Duration.valueOf(this.respawnDelay).getTicks());
        }
    }
}

