/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.objects.properties.item;

import java.util.ArrayList;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.Mechanism;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.objects.properties.Property;
import net.aufdemrand.denizencore.tags.Attribute;
import net.aufdemrand.denizencore.tags.core.EscapeTags;
import org.bukkit.Material;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemBook
implements Property {
    dItem item;

    public static boolean describes(dObject item) {
        return item instanceof dItem && (((dItem)item).getItemStack().getType().equals((Object)Material.WRITTEN_BOOK) || ((dItem)item).getItemStack().getType().equals((Object)Material.BOOK_AND_QUILL));
    }

    public static ItemBook getFrom(dObject _item) {
        if (!ItemBook.describes(_item)) {
            return null;
        }
        return new ItemBook((dItem)_item);
    }

    private ItemBook(dItem _item) {
        this.item = _item;
    }

    public String getAttribute(Attribute attribute) {
        if (attribute == null) {
            return "null";
        }
        if (attribute.startsWith("book")) {
            BookMeta bookInfo = (BookMeta)this.item.getItemStack().getItemMeta();
            attribute = attribute.fulfill(1);
            if (this.item.getItemStack().getType() == Material.WRITTEN_BOOK) {
                if (attribute.startsWith("author")) {
                    return new Element(bookInfo.getAuthor()).getAttribute(attribute.fulfill(1));
                }
                if (attribute.startsWith("title")) {
                    return new Element(bookInfo.getTitle()).getAttribute(attribute.fulfill(1));
                }
            }
            if (attribute.startsWith("page_count")) {
                return new Element(bookInfo.getPageCount()).getAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("get_page") && aH.matchesInteger(attribute.getContext(1))) {
                return new Element(bookInfo.getPage(attribute.getIntContext(1))).getAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("pages.escaped")) {
                StringBuilder output = new StringBuilder();
                for (String page : bookInfo.getPages()) {
                    output.append(EscapeTags.Escape(page)).append("|");
                }
                return new dList(output.length() > 0 ? output.substring(0, output.length() - 1) : output.toString()).getAttribute(attribute.fulfill(2));
            }
            if (attribute.startsWith("pages")) {
                return new dList(bookInfo.getPages()).getAttribute(attribute.fulfill(1));
            }
            String output = this.getPropertyString();
            if (output == null) {
                output = "null";
            }
            return new Element(output).getAttribute(attribute);
        }
        return null;
    }

    public String getPropertyString() {
        StringBuilder output = new StringBuilder();
        BookMeta bookInfo = (BookMeta)this.item.getItemStack().getItemMeta();
        if (this.item.getItemStack().getType().equals((Object)Material.WRITTEN_BOOK) && bookInfo.hasAuthor() && bookInfo.hasTitle()) {
            output.append("author|").append(EscapeTags.Escape(bookInfo.getAuthor())).append("|title|").append(EscapeTags.Escape(bookInfo.getTitle())).append("|");
        }
        output.append("pages|");
        if (bookInfo.hasPages()) {
            for (String page : bookInfo.getPages()) {
                output.append(EscapeTags.Escape(page)).append("|");
            }
        }
        if (output.length() <= 6) {
            return null;
        }
        return output.substring(0, output.length() - 1);
    }

    public String getPropertyId() {
        return "book";
    }

    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("book")) {
            BookMeta meta = (BookMeta)this.item.getItemStack().getItemMeta();
            dList data = mechanism.getValue().asType(dList.class);
            if (data.size() < 2) {
                dB.echoError("Invalid book input!");
            } else {
                if (data.size() > 4 && ((String)data.get(0)).equalsIgnoreCase("author") && ((String)data.get(2)).equalsIgnoreCase("title")) {
                    if (!this.item.getItemStack().getType().equals((Object)Material.WRITTEN_BOOK)) {
                        dB.echoError("That type of book cannot have title or author!");
                    } else {
                        meta.setAuthor(EscapeTags.unEscape((String)data.get(1)));
                        meta.setTitle(EscapeTags.unEscape((String)data.get(3)));
                        for (int i = 0; i < 4; ++i) {
                            data.remove(0);
                        }
                    }
                }
                if (!((String)data.get(0)).equalsIgnoreCase("pages")) {
                    dB.echoError("Invalid book input!");
                } else {
                    ArrayList<String> newPages = new ArrayList<String>();
                    for (int i = 1; i < data.size(); ++i) {
                        newPages.add(EscapeTags.unEscape((String)data.get(i)));
                    }
                    meta.setPages(newPages);
                }
                this.item.getItemStack().setItemMeta((ItemMeta)meta);
            }
        }
    }
}

