/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.objects.properties.item;

import java.util.ArrayList;
import java.util.List;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.objects.Mechanism;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.objects.properties.Property;
import net.aufdemrand.denizencore.tags.Attribute;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.block.banner.Pattern;
import org.bukkit.block.banner.PatternType;
import org.bukkit.inventory.meta.BannerMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemPatterns
implements Property {
    dItem item;

    public static boolean describes(dObject item) {
        if (item instanceof dItem) {
            Material material = ((dItem)item).getItemStack().getType();
            return material == Material.BANNER || material == Material.WALL_BANNER || material == Material.STANDING_BANNER;
        }
        return false;
    }

    public static ItemPatterns getFrom(dObject item) {
        if (!ItemPatterns.describes(item)) {
            return null;
        }
        return new ItemPatterns((dItem)item);
    }

    private ItemPatterns(dItem item) {
        this.item = item;
    }

    private dList listPatterns() {
        dList list = new dList();
        for (Pattern pattern : ((BannerMeta)this.item.getItemStack().getItemMeta()).getPatterns()) {
            list.add(pattern.getColor().name() + "/" + pattern.getPattern().name());
        }
        return list;
    }

    public String getAttribute(Attribute attribute) {
        if (attribute == null) {
            return "null";
        }
        if (attribute.startsWith("patterns")) {
            return this.listPatterns().getAttribute(attribute.fulfill(1));
        }
        return null;
    }

    public String getPropertyString() {
        dList list = this.listPatterns();
        if (list.isEmpty()) {
            return null;
        }
        return list.identify();
    }

    public String getPropertyId() {
        return "patterns";
    }

    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("patterns")) {
            ArrayList<Pattern> patterns = new ArrayList<Pattern>();
            dList list = mechanism.getValue().asType(dList.class);
            for (String string : list) {
                try {
                    List<String> split = CoreUtilities.split(string, '/', 2);
                    patterns.add(new Pattern(DyeColor.valueOf((String)split.get(0).toUpperCase()), PatternType.valueOf((String)split.get(1).toUpperCase())));
                }
                catch (Exception e) {
                    dB.echoError("Could not apply pattern to banner: " + string);
                }
            }
            BannerMeta bannerMeta = (BannerMeta)this.item.getItemStack().getItemMeta();
            bannerMeta.setPatterns(patterns);
            this.item.getItemStack().setItemMeta((ItemMeta)bannerMeta);
        }
    }
}

