/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import java.util.List;
import net.aufdemrand.denizen.Settings;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.DenizenCore;
import net.aufdemrand.denizencore.exceptions.CommandExecutionException;
import net.aufdemrand.denizencore.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizencore.exceptions.ScriptEntryCreationException;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.commands.BracedCommand;
import net.aufdemrand.denizencore.tags.TagManager;
import net.aufdemrand.denizencore.utilities.debugging.dB;

public class WhileCommand
extends BracedCommand {
    public void onEnable() {
        this.setBraced();
    }

    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        List<aH.Argument> original_args = aH.interpret(scriptEntry.modifiedArguments());
        int i = 0;
        List<aH.Argument> parsed_args = aH.interpret(scriptEntry.getArguments());
        if (i < parsed_args.size()) {
            aH.Argument arg = parsed_args.get(i);
            aH.Argument original = original_args.get(i);
            if (!scriptEntry.hasObject("stop") && arg.matches("stop")) {
                scriptEntry.addObject("stop", Element.TRUE);
            } else if (!scriptEntry.hasObject("next") && arg.matches("next")) {
                scriptEntry.addObject("next", Element.TRUE);
            } else if (!scriptEntry.hasObject("callback") && arg.matches("\u0000CALLBACK")) {
                scriptEntry.addObject("callback", Element.TRUE);
            } else if (!scriptEntry.hasObject("value")) {
                scriptEntry.addObject("value", new Element(original.raw_value));
                scriptEntry.addObject("parsed_value", new Element(arg.raw_value));
            } else {
                arg.reportUnhandled();
            }
        }
        if (!(scriptEntry.hasObject("value") || scriptEntry.hasObject("stop") || scriptEntry.hasObject("next") || scriptEntry.hasObject("callback"))) {
            throw new InvalidArgumentsException("Must specify a comparison value or 'stop' or 'next'!");
        }
        scriptEntry.addObject("braces", WhileCommand.getBracedCommands(scriptEntry));
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        Element stop = scriptEntry.getElement("stop");
        Element next = scriptEntry.getElement("next");
        Element callback = scriptEntry.getElement("callback");
        if (stop != null && stop.asBoolean()) {
            dB.report(scriptEntry, this.getName(), stop.debug());
            boolean hasnext = false;
            for (int i = 0; i < scriptEntry.getResidingQueue().getQueueSize(); ++i) {
                ScriptEntry entry = scriptEntry.getResidingQueue().getEntry(i);
                List<String> args = entry.getOriginalArguments();
                if (!entry.getCommandName().equalsIgnoreCase("while") || args.size() <= 0 || !args.get(0).equalsIgnoreCase("\u0000CALLBACK")) continue;
                hasnext = true;
                break;
            }
            if (hasnext) {
                while (scriptEntry.getResidingQueue().getQueueSize() > 0) {
                    ScriptEntry entry = scriptEntry.getResidingQueue().getEntry(0);
                    List<String> args = entry.getOriginalArguments();
                    if (entry.getCommandName().equalsIgnoreCase("while") && args.size() > 0 && args.get(0).equalsIgnoreCase("\u0000CALLBACK")) {
                        scriptEntry.getResidingQueue().removeEntry(0);
                        break;
                    }
                    scriptEntry.getResidingQueue().removeEntry(0);
                }
            } else {
                dB.echoError(scriptEntry.getResidingQueue(), "Cannot stop while: not in one!");
            }
            return;
        }
        if (next != null && next.asBoolean()) {
            dB.report(scriptEntry, this.getName(), next.debug());
            boolean hasnext = false;
            for (int i = 0; i < scriptEntry.getResidingQueue().getQueueSize(); ++i) {
                ScriptEntry entry = scriptEntry.getResidingQueue().getEntry(i);
                List<String> args = entry.getOriginalArguments();
                if (!entry.getCommandName().equalsIgnoreCase("while") || args.size() <= 0 || !args.get(0).equalsIgnoreCase("\u0000CALLBACK")) continue;
                hasnext = true;
                break;
            }
            if (hasnext) {
                while (scriptEntry.getResidingQueue().getQueueSize() > 0) {
                    ScriptEntry entry = scriptEntry.getResidingQueue().getEntry(0);
                    List<String> args = entry.getOriginalArguments();
                    if (!entry.getCommandName().equalsIgnoreCase("while") || args.size() <= 0 || !args.get(0).equalsIgnoreCase("\u0000CALLBACK")) {
                        scriptEntry.getResidingQueue().removeEntry(0);
                        continue;
                    }
                    break;
                }
            } else {
                dB.echoError(scriptEntry.getResidingQueue(), "Cannot stop while: not in one!");
            }
            return;
        }
        if (callback != null && callback.asBoolean()) {
            if (scriptEntry.getOwner() != null && (scriptEntry.getOwner().getCommandName().equalsIgnoreCase("while") || scriptEntry.getOwner().getBracedSet() == null || scriptEntry.getOwner().getBracedSet().size() == 0 || scriptEntry.getBracedSet().get((int)0).value.get(scriptEntry.getBracedSet().get((int)0).value.size() - 1) != scriptEntry)) {
                WhileData data = (WhileData)scriptEntry.getOwner().getData();
                ++data.index;
                if (System.currentTimeMillis() - data.LastChecked < 50L) {
                    ++data.instaTicks;
                    int max = Settings.whileMaxLoops();
                    if (data.instaTicks > max && max != 0) {
                        return;
                    }
                } else {
                    data.instaTicks = 0;
                }
                data.LastChecked = System.currentTimeMillis();
                if (TagManager.tag(data.value, DenizenCore.getImplementation().getTagContextFor(scriptEntry, false)).equalsIgnoreCase("true")) {
                    dB.echoDebug(scriptEntry, dB.DebugElement.Header, "While loop " + data.index);
                    scriptEntry.getResidingQueue().addDefinition("loop_index", String.valueOf(data.index));
                    List<ScriptEntry> bracedCommands = BracedCommand.getBracedCommands((ScriptEntry)scriptEntry.getOwner()).get((int)0).value;
                    ScriptEntry callbackEntry = null;
                    try {
                        callbackEntry = new ScriptEntry("WHILE", new String[]{"\u0000CALLBACK"}, scriptEntry.getScript() != null ? scriptEntry.getScript().getContainer() : null);
                        callbackEntry.copyFrom(scriptEntry);
                    }
                    catch (ScriptEntryCreationException e) {
                        dB.echoError(scriptEntry.getResidingQueue(), e);
                    }
                    callbackEntry.setOwner(scriptEntry.getOwner());
                    bracedCommands.add(callbackEntry);
                    for (int i = 0; i < bracedCommands.size(); ++i) {
                        bracedCommands.get(i).setInstant(true);
                        bracedCommands.get(i).addObject("reqId", scriptEntry.getObject("reqId"));
                    }
                    scriptEntry.getResidingQueue().injectEntries(bracedCommands, 0);
                }
            } else {
                dB.echoError(scriptEntry.getResidingQueue(), "While CALLBACK invalid: not a real callback!");
            }
        } else {
            Element value = scriptEntry.getElement("value");
            Element parsed_value = scriptEntry.getElement("parsed_value");
            List<ScriptEntry> bracedCommandsList = ((BracedCommand.BracedData)((List)scriptEntry.getObject((String)"braces")).get((int)0)).value;
            if (bracedCommandsList == null || bracedCommandsList.isEmpty()) {
                dB.echoError(scriptEntry.getResidingQueue(), "Empty braces!");
                return;
            }
            dB.report(scriptEntry, this.getName(), value.debug());
            if (!parsed_value.asString().equalsIgnoreCase("true")) {
                return;
            }
            WhileData datum = new WhileData();
            datum.index = 1;
            datum.value = value.asString();
            datum.LastChecked = System.currentTimeMillis();
            datum.instaTicks = 1;
            scriptEntry.setData(datum);
            ScriptEntry callbackEntry = null;
            try {
                callbackEntry = new ScriptEntry("WHILE", new String[]{"\u0000CALLBACK"}, scriptEntry.getScript() != null ? scriptEntry.getScript().getContainer() : null);
                callbackEntry.copyFrom(scriptEntry);
            }
            catch (ScriptEntryCreationException e) {
                dB.echoError(scriptEntry.getResidingQueue(), e);
            }
            callbackEntry.setOwner(scriptEntry);
            bracedCommandsList.add(callbackEntry);
            scriptEntry.getResidingQueue().addDefinition("loop_index", "1");
            for (int i = 0; i < bracedCommandsList.size(); ++i) {
                bracedCommandsList.get(i).setInstant(true);
                bracedCommandsList.get(i).addObject("reqId", scriptEntry.getObject("reqId"));
            }
            scriptEntry.getResidingQueue().injectEntries(bracedCommandsList, 0);
        }
    }

    private class WhileData {
        public int index;
        public String value;
        public long LastChecked;
        int instaTicks;

        private WhileData() {
        }
    }
}

