/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.entity;

import java.util.List;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.exceptions.CommandExecutionException;
import net.aufdemrand.denizencore.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.commands.AbstractCommand;
import net.citizensnpcs.util.PlayerAnimation;
import org.bukkit.EntityEffect;
import org.bukkit.entity.Player;

public class AnimateCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (!scriptEntry.hasObject("entities") && arg.matchesArgumentList(dEntity.class)) {
                scriptEntry.addObject("entities", arg.asType(dList.class).filter(dEntity.class));
            }
            if (scriptEntry.hasObject("animation") || scriptEntry.hasObject("effect")) continue;
            if (arg.matchesEnum((Enum<?>[])PlayerAnimation.values())) {
                scriptEntry.addObject("animation", PlayerAnimation.valueOf((String)arg.getValue().toUpperCase()));
                continue;
            }
            if (!arg.matchesEnum((Enum<?>[])EntityEffect.values())) continue;
            scriptEntry.addObject("effect", EntityEffect.valueOf((String)arg.getValue().toUpperCase()));
        }
        if (!scriptEntry.hasObject("entities")) {
            throw new InvalidArgumentsException("Must specify entity/entities!");
        }
        if (!scriptEntry.hasObject("effect") && !scriptEntry.hasObject("animation")) {
            throw new InvalidArgumentsException("Must specify a valid animation!");
        }
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        List entities = (List)scriptEntry.getObject("entities");
        PlayerAnimation animation = scriptEntry.hasObject("animation") ? (PlayerAnimation)scriptEntry.getObject("animation") : null;
        EntityEffect effect = scriptEntry.hasObject("effect") ? (EntityEffect)scriptEntry.getObject("effect") : null;
        dB.report(scriptEntry, this.getName(), (animation != null ? aH.debugObj("animation", animation.name()) : aH.debugObj("effect", effect.name())) + aH.debugObj("entities", entities.toString()));
        for (dEntity entity : entities) {
            if (!entity.isSpawned()) continue;
            try {
                if (animation != null && entity.getBukkitEntity() instanceof Player) {
                    Player player = (Player)entity.getBukkitEntity();
                    animation.play(player);
                    continue;
                }
                entity.getBukkitEntity().playEffect(effect);
            }
            catch (Exception e) {
                dB.echoError(scriptEntry.getResidingQueue(), "Error playing that animation!");
            }
        }
    }
}

