/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.world;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import net.aufdemrand.denizen.objects.dCuboid;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.objects.dMaterial;
import net.aufdemrand.denizen.utilities.blocks.BlockData;
import net.aufdemrand.denizen.utilities.blocks.CuboidBlockSet;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.exceptions.CommandExecutionException;
import net.aufdemrand.denizencore.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.commands.AbstractCommand;
import net.aufdemrand.denizencore.scripts.commands.Holdable;
import net.aufdemrand.denizencore.tags.Attribute;
import net.aufdemrand.denizencore.tags.ReplaceableTagEvent;
import net.aufdemrand.denizencore.tags.TagManager;

public class SchematicCommand
extends AbstractCommand
implements Holdable {
    public static Map<String, CuboidBlockSet> schematics;

    public void onEnable() {
        TagManager.registerTagEvents(this);
        schematics = new HashMap<String, CuboidBlockSet>();
    }

    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (!scriptEntry.hasObject("type") && arg.matchesEnum(Type.values())) {
                scriptEntry.addObject("type", new Element(arg.raw_value.toUpperCase()));
                continue;
            }
            if (!scriptEntry.hasObject("name") && arg.matchesPrefix("name")) {
                scriptEntry.addObject("name", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("angle") && arg.matchesPrimitive(aH.PrimitiveType.Integer)) {
                scriptEntry.addObject("angle", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("location") && arg.matchesArgumentType(dLocation.class)) {
                scriptEntry.addObject("location", arg.asType(dLocation.class));
                continue;
            }
            if (!scriptEntry.hasObject("cuboid") && arg.matchesArgumentType(dCuboid.class)) {
                scriptEntry.addObject("cuboid", arg.asType(dCuboid.class));
                continue;
            }
            if (!scriptEntry.hasObject("delayed") && arg.matches("delayed")) {
                scriptEntry.addObject("delayed", new Element("true"));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("type")) {
            throw new InvalidArgumentsException("Missing type argument!");
        }
        if (!scriptEntry.hasObject("name")) {
            throw new InvalidArgumentsException("Missing name argument!");
        }
    }

    public void execute(final ScriptEntry scriptEntry) throws CommandExecutionException {
        Element angle = scriptEntry.getElement("angle");
        Element type = scriptEntry.getElement("type");
        Element name = scriptEntry.getElement("name");
        Element delayed = scriptEntry.getElement("delayed");
        dLocation location = (dLocation)scriptEntry.getdObject("location");
        dCuboid cuboid = (dCuboid)scriptEntry.getdObject("cuboid");
        dB.report(scriptEntry, this.getName(), type.debug() + name.debug() + (location != null ? location.debug() : "") + (cuboid != null ? cuboid.debug() : "") + (angle != null ? angle.debug() : "") + (delayed != null ? delayed.debug() : ""));
        Type ttype = Type.valueOf(type.asString());
        if (scriptEntry.shouldWaitFor() && ttype != Type.PASTE) {
            dB.echoError("Tried to wait for a non-paste schematic command.");
            scriptEntry.setFinished(true);
        }
        switch (ttype) {
            case CREATE: {
                if (schematics.containsKey(name.asString().toUpperCase())) {
                    dB.echoError(scriptEntry.getResidingQueue(), "Schematic file " + name.asString() + " is already loaded.");
                    return;
                }
                if (cuboid == null) {
                    dB.echoError(scriptEntry.getResidingQueue(), "Missing cuboid argument!");
                    return;
                }
                if (location == null) {
                    dB.echoError(scriptEntry.getResidingQueue(), "Missing origin location argument!");
                    return;
                }
                try {
                    CuboidBlockSet set = new CuboidBlockSet(cuboid, location);
                    schematics.put(name.asString().toUpperCase(), set);
                    break;
                }
                catch (Exception ex) {
                    dB.echoError(scriptEntry.getResidingQueue(), "Error creating schematic object " + name.asString() + ".");
                    dB.echoError(scriptEntry.getResidingQueue(), ex);
                    return;
                }
            }
            case LOAD: {
                if (schematics.containsKey(name.asString().toUpperCase())) {
                    dB.echoError(scriptEntry.getResidingQueue(), "Schematic file " + name.asString() + " is already loaded.");
                    return;
                }
                try {
                    String directory = URLDecoder.decode(System.getProperty("user.dir"));
                    File f = new File(directory + "/plugins/Denizen/schematics/" + name.asString() + ".schematic");
                    if (!f.exists()) {
                        dB.echoError("Schematic file " + name.asString() + " does not exist. Are you sure it's in " + directory + "/plugins/Denizen/schematics/?");
                        return;
                    }
                    FileInputStream fs = new FileInputStream(f);
                    CuboidBlockSet set = CuboidBlockSet.fromMCEditStream(fs);
                    ((InputStream)fs).close();
                    schematics.put(name.asString().toUpperCase(), set);
                    break;
                }
                catch (Exception ex) {
                    dB.echoError(scriptEntry.getResidingQueue(), "Error loading schematic file " + name.asString() + ".");
                    dB.echoError(scriptEntry.getResidingQueue(), ex);
                    return;
                }
            }
            case UNLOAD: {
                if (!schematics.containsKey(name.asString().toUpperCase())) {
                    dB.echoError(scriptEntry.getResidingQueue(), "Schematic file " + name.asString() + " is not loaded.");
                    return;
                }
                schematics.remove(name.asString().toUpperCase());
                break;
            }
            case ROTATE: {
                if (!schematics.containsKey(name.asString().toUpperCase())) {
                    dB.echoError(scriptEntry.getResidingQueue(), "Schematic file " + name.asString() + " is not loaded.");
                    return;
                }
                if (angle == null) {
                    dB.echoError(scriptEntry.getResidingQueue(), "Missing angle argument!");
                    return;
                }
                dB.echoError(scriptEntry.getResidingQueue(), "Schematic rotation is TODO!");
                int ang = angle.asInt();
                if (ang < 0) {
                    ang = 360 + ang;
                }
                while (ang > 0) {
                    ang -= 90;
                    schematics.get(name.asString().toUpperCase()).rotateOne();
                }
                break;
            }
            case PASTE: {
                if (!schematics.containsKey(name.asString().toUpperCase())) {
                    dB.echoError(scriptEntry.getResidingQueue(), "Schematic file " + name.asString() + " is not loaded.");
                    return;
                }
                if (location == null) {
                    dB.echoError(scriptEntry.getResidingQueue(), "Missing location argument!");
                    return;
                }
                try {
                    if (delayed != null && delayed.asBoolean()) {
                        schematics.get(name.asString().toUpperCase()).setBlocksDelayed(location, new Runnable(){

                            public void run() {
                                scriptEntry.setFinished(true);
                            }
                        });
                        break;
                    }
                    scriptEntry.setFinished(true);
                    schematics.get(name.asString().toUpperCase()).setBlocks(location);
                    break;
                }
                catch (Exception ex) {
                    dB.echoError(scriptEntry.getResidingQueue(), "Exception pasting schematic file " + name.asString() + ".");
                    dB.echoError(scriptEntry.getResidingQueue(), ex);
                    return;
                }
            }
            case SAVE: {
                if (!schematics.containsKey(name.asString().toUpperCase())) {
                    dB.echoError(scriptEntry.getResidingQueue(), "Schematic file " + name.asString() + " is not loaded.");
                    return;
                }
                try {
                    CuboidBlockSet set = schematics.get(name.asString().toUpperCase());
                    String directory = URLDecoder.decode(System.getProperty("user.dir"));
                    File f = new File(directory + "/plugins/Denizen/schematics/" + name.asString() + ".schematic");
                    FileOutputStream fs = new FileOutputStream(f);
                    set.saveMCEditFormatToStream(fs);
                    fs.flush();
                    fs.close();
                    break;
                }
                catch (Exception ex) {
                    dB.echoError(scriptEntry.getResidingQueue(), "Error saving schematic file " + name.asString() + ".");
                    dB.echoError(scriptEntry.getResidingQueue(), ex);
                    return;
                }
            }
        }
    }

    @TagManager.TagEvents
    public void schematicTags(ReplaceableTagEvent event) {
        if (!event.matches("schematic, schem")) {
            return;
        }
        if (!event.hasNameContext()) {
            return;
        }
        String id = event.getNameContext().toUpperCase();
        Attribute attribute = event.getAttributes().fulfill(1);
        if (!schematics.containsKey(id)) {
            if (attribute.startsWith("exists")) {
                event.setReplaced(new Element(false).getAttribute(attribute.fulfill(1)));
                return;
            }
            dB.echoError(attribute.getScriptEntry() != null ? attribute.getScriptEntry().getResidingQueue() : null, "Schematic file " + id + " is not loaded.");
            return;
        }
        CuboidBlockSet set = schematics.get(id);
        if (attribute.startsWith("exists")) {
            event.setReplaced(new Element(true).getAttribute(attribute.fulfill(1)));
            return;
        }
        if (attribute.startsWith("height")) {
            event.setReplaced(new Element(set.y_length).getAttribute(attribute.fulfill(1)));
            return;
        }
        if (attribute.startsWith("length")) {
            event.setReplaced(new Element(set.z_height).getAttribute(attribute.fulfill(1)));
            return;
        }
        if (attribute.startsWith("width")) {
            event.setReplaced(new Element(set.x_width).getAttribute(attribute.fulfill(1)));
            return;
        }
        if (attribute.startsWith("block") && attribute.hasContext(1) && dLocation.matches(attribute.getContext(1))) {
            dLocation location = dLocation.valueOf(attribute.getContext(1));
            BlockData block = set.blockAt(location.getX(), location.getY(), location.getZ());
            event.setReplaced(dMaterial.getMaterialFrom(block.material, block.data).getAttribute(attribute.fulfill(1)));
            return;
        }
        if (attribute.startsWith("origin")) {
            event.setReplaced(new dLocation(null, set.center_x, set.center_y, set.center_z).getAttribute(attribute.fulfill(1)));
            return;
        }
        if (attribute.startsWith("blocks")) {
            event.setReplaced(new Element(set.blocks.size()).getAttribute(attribute.fulfill(1)));
            return;
        }
        if (attribute.startsWith("cuboid") && attribute.hasContext(1)) {
            dLocation origin = dLocation.valueOf(attribute.getContext(1));
            event.setReplaced(set.getCuboid(origin).getAttribute(attribute.fulfill(1)));
            return;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Type {
        CREATE,
        LOAD,
        UNLOAD,
        ROTATE,
        PASTE,
        SAVE;

    }
}

