/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.world;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizen.utilities.depends.Depends;
import net.aufdemrand.denizencore.exceptions.CommandExecutionException;
import net.aufdemrand.denizencore.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizencore.objects.Duration;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.commands.AbstractCommand;
import net.aufdemrand.denizencore.utilities.debugging.Debuggable;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import net.minecraft.server.v1_8_R3.Block;
import net.minecraft.server.v1_8_R3.BlockPosition;
import net.minecraft.server.v1_8_R3.EntityHuman;
import net.minecraft.server.v1_8_R3.EnumDirection;
import net.minecraft.server.v1_8_R3.World;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.craftbukkit.v1_8_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_8_R3.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class SwitchCommand
extends AbstractCommand {
    private Map<Location, Integer> taskMap = new ConcurrentHashMap<Location, Integer>(8, 0.9f, 1);

    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (!scriptEntry.hasObject("locations") && arg.matchesArgumentList(dLocation.class)) {
                scriptEntry.addObject("locations", arg.asType(dList.class));
                continue;
            }
            if (!scriptEntry.hasObject("duration") && arg.matchesArgumentType(Duration.class)) {
                scriptEntry.addObject("duration", arg.asType(Duration.class));
                continue;
            }
            if (!scriptEntry.hasObject("state") && arg.matchesEnum(SwitchState.values())) {
                scriptEntry.addObject("switchstate", new Element(arg.getValue().toUpperCase()));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("locations")) {
            throw new InvalidArgumentsException("Must specify a location!");
        }
        scriptEntry.defaultObject("duration", new Duration(0));
        scriptEntry.defaultObject("switchstate", new Element("TOGGLE"));
    }

    public void execute(final ScriptEntry scriptEntry) throws CommandExecutionException {
        dList interactLocations = (dList)scriptEntry.getdObject("locations");
        long duration = ((Duration)scriptEntry.getObject("duration")).getTicks();
        SwitchState switchState = SwitchState.valueOf(scriptEntry.getElement("switchstate").asString());
        final Player player = ((BukkitScriptEntryData)scriptEntry.entryData).hasPlayer() ? ((BukkitScriptEntryData)scriptEntry.entryData).getPlayer().getPlayerEntity() : null;
        dB.report(scriptEntry, this.getName(), interactLocations.debug() + aH.debugObj("duration", duration + "t") + aH.debugObj("switchstate", switchState.name()));
        for (final dLocation interactLocation : interactLocations.filter(dLocation.class)) {
            this.switchBlock(scriptEntry, interactLocation, switchState, player);
            if (duration <= 0L) continue;
            if (this.taskMap.containsKey(interactLocation)) {
                try {
                    DenizenAPI.getCurrentInstance().getServer().getScheduler().cancelTask(this.taskMap.get(interactLocation).intValue());
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            dB.log("Setting delayed task 'SWITCH' for " + interactLocation.identify());
            this.taskMap.put(interactLocation, DenizenAPI.getCurrentInstance().getServer().getScheduler().scheduleSyncDelayedTask((Plugin)DenizenAPI.getCurrentInstance(), new Runnable(){

                public void run() {
                    SwitchCommand.this.switchBlock(scriptEntry, interactLocation, SwitchState.TOGGLE, player);
                }
            }, duration));
        }
    }

    public void switchBlock(ScriptEntry scriptEntry, Location interactLocation, SwitchState switchState, Player player) {
        org.bukkit.World world = interactLocation.getWorld();
        boolean currentState = (interactLocation.getBlock().getData() & 8) > 0;
        String state = switchState.toString();
        CraftPlayer craftPlayer = (CraftPlayer)player;
        if (craftPlayer == null && Bukkit.getOnlinePlayers().size() > 0) {
            if (Bukkit.getOnlinePlayers().size() > 0) {
                craftPlayer = (CraftPlayer)Bukkit.getOnlinePlayers().toArray()[0];
            } else if (Depends.citizens != null) {
                for (NPC npc : CitizensAPI.getNPCRegistry()) {
                    if (!npc.isSpawned() || !(npc.getEntity() instanceof Player)) continue;
                    craftPlayer = (CraftPlayer)npc.getEntity();
                    break;
                }
            }
        }
        if (state.equals("ON") && !currentState || state.equals("OFF") && currentState || state.equals("TOGGLE")) {
            try {
                if (interactLocation.getBlock().getType() == Material.IRON_DOOR_BLOCK) {
                    Location block = interactLocation.clone().add(0.0, -1.0, 0.0).getBlock().getType() == Material.IRON_DOOR_BLOCK ? interactLocation.clone().add(0.0, -1.0, 0.0) : interactLocation;
                    block.getBlock().setData((byte)(block.getBlock().getData() ^ 4));
                } else {
                    BlockPosition pos = new BlockPosition(interactLocation.getBlockX(), interactLocation.getBlockY(), interactLocation.getBlockZ());
                    Block.getById((int)interactLocation.getBlock().getType().getId()).interact((World)((CraftWorld)interactLocation.getWorld()).getHandle(), pos, ((CraftWorld)interactLocation.getWorld()).getHandle().getType(pos), (EntityHuman)(craftPlayer != null ? craftPlayer.getHandle() : null), EnumDirection.NORTH, 0.0f, 0.0f, 0.0f);
                }
                dB.echoDebug((Debuggable)scriptEntry, "Switched " + interactLocation.getBlock().getType().toString() + "! Current state now: " + ((interactLocation.getBlock().getData() & 8) > 0 ? "ON" : "OFF"));
            }
            catch (NullPointerException e) {
                dB.echoError("Cannot switch " + interactLocation.getBlock().getType().toString() + "!");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum SwitchState {
        ON,
        OFF,
        TOGGLE;

    }
}

