/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.triggers.core;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.aufdemrand.denizen.events.bukkit.ScriptReloadEvent;
import net.aufdemrand.denizen.npc.dNPCRegistry;
import net.aufdemrand.denizen.npc.traits.TriggerTrait;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.objects.dNPC;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.scripts.containers.core.InteractScriptContainer;
import net.aufdemrand.denizen.scripts.triggers.AbstractTrigger;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.scripts.ScriptRegistry;
import net.aufdemrand.denizencore.utilities.debugging.Debuggable;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class ProximityTrigger
extends AbstractTrigger
implements Listener {
    private static int maxProximityDistance = 75;
    int taskID = -1;
    private static Map<UUID, Set<Integer>> proximityTracker = new ConcurrentHashMap<UUID, Set<Integer>>(8, 0.9f, 1);

    public void onEnable() {
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
        final ProximityTrigger trigger = this;
        this.taskID = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)DenizenAPI.getCurrentInstance(), new Runnable(){

            public void run() {
                for (dNPC npc : dNPCRegistry.getSpawnedNPCs()) {
                    if (npc == null || npc.getCitizen() == null || !npc.getCitizen().hasTrait(TriggerTrait.class) || !((TriggerTrait)npc.getCitizen().getTrait(TriggerTrait.class)).isEnabled(ProximityTrigger.this.name) || !npc.isSpawned()) continue;
                    for (Player BukkitPlayer : Bukkit.getOnlinePlayers()) {
                        if (!npc.getWorld().equals(BukkitPlayer.getWorld()) && ProximityTrigger.this.hasExitedProximityOf(BukkitPlayer, npc) || !ProximityTrigger.this.isCloseEnough(BukkitPlayer, npc) && ProximityTrigger.this.hasExitedProximityOf(BukkitPlayer, npc)) continue;
                        dPlayer player = dPlayer.mirrorBukkitPlayer((OfflinePlayer)BukkitPlayer);
                        InteractScriptContainer script = npc.getInteractScriptQuietly(player, ProximityTrigger.class);
                        double entryRadius = npc.getTriggerTrait().getRadius(ProximityTrigger.this.name);
                        double exitRadius = npc.getTriggerTrait().getRadius(ProximityTrigger.this.name);
                        double moveRadius = npc.getTriggerTrait().getRadius(ProximityTrigger.this.name);
                        if (script != null) {
                            try {
                                if (script.hasTriggerOptionFor(ProximityTrigger.class, player, null, "ENTRY RADIUS")) {
                                    entryRadius = Integer.valueOf(script.getTriggerOptionFor(ProximityTrigger.class, player, null, "ENTRY RADIUS")).intValue();
                                }
                            }
                            catch (NumberFormatException nfe) {
                                dB.echoDebug((Debuggable)script, "Entry Radius was not an integer.  Assuming " + entryRadius + " as the radius.");
                            }
                            try {
                                if (script.hasTriggerOptionFor(ProximityTrigger.class, player, null, "EXIT RADIUS")) {
                                    exitRadius = Integer.valueOf(script.getTriggerOptionFor(ProximityTrigger.class, player, null, "EXIT RADIUS")).intValue();
                                }
                            }
                            catch (NumberFormatException nfe) {
                                dB.echoDebug((Debuggable)script, "Exit Radius was not an integer.  Assuming " + exitRadius + " as the radius.");
                            }
                            try {
                                if (script.hasTriggerOptionFor(ProximityTrigger.class, player, null, "MOVE RADIUS")) {
                                    moveRadius = Integer.valueOf(script.getTriggerOptionFor(ProximityTrigger.class, player, null, "MOVE RADIUS")).intValue();
                                }
                            }
                            catch (NumberFormatException nfe) {
                                dB.echoDebug((Debuggable)script, "Move Radius was not an integer.  Assuming " + moveRadius + " as the radius.");
                            }
                        }
                        dLocation npcLocation = npc.getLocation();
                        boolean playerChangedWorlds = false;
                        if (npcLocation.getWorld() != player.getWorld()) {
                            playerChangedWorlds = true;
                        }
                        boolean exitedProximity = ProximityTrigger.this.hasExitedProximityOf(BukkitPlayer, npc);
                        double distance = 0.0;
                        if (!playerChangedWorlds) {
                            distance = npcLocation.distance(player.getLocation());
                        }
                        if (!exitedProximity && (playerChangedWorlds || distance >= exitRadius)) {
                            if (!npc.getTriggerTrait().triggerCooldownOnly(trigger, player)) continue;
                            ProximityTrigger.this.exitProximityOf(BukkitPlayer, npc);
                            npc.action("exit proximity", player);
                            ProximityTrigger.this.parse(npc, player, script, "EXIT");
                            continue;
                        }
                        if (exitedProximity && distance <= entryRadius) {
                            if (!npc.getTriggerTrait().triggerCooldownOnly(trigger, player)) continue;
                            ProximityTrigger.this.enterProximityOf(BukkitPlayer, npc);
                            npc.action("enter proximity", player);
                            ProximityTrigger.this.parse(npc, player, script, "ENTRY");
                            continue;
                        }
                        if (exitedProximity || !(distance <= moveRadius)) continue;
                        npc.action("move proximity", player);
                        ProximityTrigger.this.parse(npc, player, script, "MOVE");
                    }
                }
            }
        }, 5L, 5L);
    }

    public void onDisable() {
        Bukkit.getScheduler().cancelTask(this.taskID);
    }

    private boolean isCloseEnough(Player player, dNPC npc) {
        Location pLoc = player.getLocation();
        dLocation nLoc = npc.getLocation();
        if (Math.abs(pLoc.getX() - nLoc.getX()) > (double)maxProximityDistance) {
            return false;
        }
        if (Math.abs(pLoc.getY() - nLoc.getY()) > (double)maxProximityDistance) {
            return false;
        }
        return !(Math.abs(pLoc.getZ() - nLoc.getZ()) > (double)maxProximityDistance);
    }

    @EventHandler
    public void checkMaxProximities(ScriptReloadEvent event) {
        for (String string : ScriptRegistry._getScriptNames()) {
        }
    }

    private boolean hasExitedProximityOf(Player player, dNPC npc) {
        Set<Integer> existing = proximityTracker.get(player.getUniqueId());
        if (existing == null) {
            return true;
        }
        return !existing.contains(npc.getId());
    }

    private void enterProximityOf(Player player, dNPC npc) {
        Set<Integer> npcs = proximityTracker.get(player.getUniqueId());
        if (npcs == null) {
            npcs = new HashSet<Integer>();
            proximityTracker.put(player.getUniqueId(), npcs);
        }
        npcs.add(npc.getId());
    }

    private void exitProximityOf(Player player, dNPC npc) {
        Set<Integer> npcs = proximityTracker.get(player.getUniqueId());
        if (npcs == null) {
            npcs = new HashSet<Integer>();
            proximityTracker.put(player.getUniqueId(), npcs);
        }
        npcs.remove(npc.getId());
    }
}

