/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.utilities;

import java.util.ArrayList;
import java.util.HashSet;
import net.aufdemrand.denizen.Settings;
import net.aufdemrand.denizen.objects.dLocation;

public class PathFinder {
    public static dLocation[] surroundings = new dLocation[]{new dLocation(null, 1.0, 0.0, 0.0), new dLocation(null, -1.0, 0.0, 0.0), new dLocation(null, 0.0, 0.0, 1.0), new dLocation(null, 0.0, 0.0, -1.0), new dLocation(null, 0.0, 1.0, 1.0), new dLocation(null, 0.0, 1.0, -1.0), new dLocation(null, 1.0, 1.0, 0.0), new dLocation(null, -1.0, 1.0, 0.0), new dLocation(null, 0.0, -1.0, 1.0), new dLocation(null, 0.0, -1.0, -1.0), new dLocation(null, 1.0, -1.0, 0.0), new dLocation(null, -1.0, -1.0, 0.0)};

    public static Node findPath(dLocation start, dLocation end, int radius) {
        int maxRadius = Settings.pathfindingMaxDistance();
        Node snode = new Node();
        snode.position = start;
        MinHeap heaplist = new MinHeap();
        heaplist.add(snode);
        HashSet<dLocation> tried = new HashSet<dLocation>(100);
        ArrayList<Node> fNodes = new ArrayList<Node>();
        tried.add(start);
        while (heaplist.hasNext()) {
            Node curr = heaplist.extractFirst();
            if (curr.position.distanceSquared(end) <= (double)(radius * radius)) {
                Node n = new Node();
                n.position = start;
                n.cost = curr.pathCost + 1.0;
                n.pathCost = curr.cost + 1.0;
                n.next = curr;
                fNodes.add(n);
                continue;
            }
            for (int i = 0; i < surroundings.length; ++i) {
                dLocation surr = surroundings[i];
                dLocation point = new dLocation(start.getWorld(), curr.position.getX() + surr.getX(), curr.position.getY() + surr.getY(), curr.position.getZ() + surr.getZ());
                if (!PathFinder.pointIsFree(point, maxRadius, start) || tried.contains(point)) continue;
                tried.add(point);
                Node node = new Node();
                node.position = point;
                double surrCost = PathFinder.lengthSquared(surr);
                node.cost = curr.pathCost + surrCost + point.distanceSquared(end);
                node.pathCost = curr.pathCost + surrCost;
                node.next = curr;
                heaplist.add(node);
            }
        }
        Node fnode = null;
        for (Node node : fNodes) {
            if (fnode != null && !(node.pathCost < fnode.pathCost)) continue;
            fnode = node;
        }
        return fnode;
    }

    public static double lengthSquared(dLocation loc) {
        return loc.getX() * loc.getX() + loc.getY() * loc.getY() + loc.getZ() * loc.getZ();
    }

    public static boolean pointIsFree(dLocation point, int maxRadius, dLocation start) {
        return point.getWorld() != null && !point.getBlock().getType().isSolid() && !point.clone().add(0.0, 1.0, 0.0).getBlock().getType().isSolid() && point.clone().add(0.0, -1.0, 0.0).getBlock().getType().isSolid() && point.distanceSquared(start) < (double)(maxRadius * maxRadius);
    }

    static class MinHeap {
        public Node head;

        MinHeap() {
        }

        public boolean hasNext() {
            return this.head != null;
        }

        public void add(Node node) {
            if (this.head == null) {
                this.head = node;
            } else if (this.head.next == null && node.cost < this.head.cost) {
                node.nextListElement = this.head;
                this.head = node;
            } else {
                Node cur = this.head;
                while (cur.nextListElement != null && cur.nextListElement.cost < node.cost) {
                    cur = cur.nextListElement;
                }
                node.nextListElement = cur.nextListElement;
                cur.nextListElement = node;
            }
        }

        public Node extractFirst() {
            Node res = this.head;
            this.head = this.head.nextListElement;
            return res;
        }
    }

    public static class Node {
        public dLocation position;
        public double cost;
        public double pathCost;
        public Node next;
        public Node nextListElement;
    }
}

