/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.utilities.maps;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.stream.FileImageOutputStream;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizen.utilities.maps.DenizenMapRenderer;
import net.aufdemrand.denizen.utilities.maps.MapAnimatedImage;
import net.aufdemrand.denizen.utilities.maps.MapCursor;
import net.aufdemrand.denizen.utilities.maps.MapImage;
import net.aufdemrand.denizen.utilities.maps.MapObject;
import net.aufdemrand.denizen.utilities.maps.MapText;
import net.aufdemrand.denizencore.utilities.NaturalOrderComparator;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.map.MapRenderer;
import org.bukkit.map.MapView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DenizenMapManager {
    private static final Map<Short, DenizenMapRenderer> mapRenderers = new HashMap<Short, DenizenMapRenderer>();
    private static final Map<String, String> downloadedByUrl = new HashMap<String, String>();
    private static final File imagesFolder = new File(DenizenAPI.getCurrentInstance().getDataFolder(), "images");
    private static final File imageDownloads = new File(imagesFolder, "downloaded");
    private static final File mapsFile = new File(DenizenAPI.getCurrentInstance().getDataFolder(), "maps.yml");
    private static int downloadCount = (imageDownloads.exists() ? imageDownloads.listFiles().length : 0) + 1;
    private static YamlConfiguration mapsConfig;

    public static void reloadMaps() {
        MapView mapView;
        HashMap<Short, List<MapRenderer>> oldMapRenderers = new HashMap<Short, List<MapRenderer>>();
        for (Map.Entry<Short, DenizenMapRenderer> entry : mapRenderers.entrySet()) {
            DenizenMapRenderer denizenMapRenderer = entry.getValue();
            oldMapRenderers.put(entry.getKey(), denizenMapRenderer.getOldRenderers());
            denizenMapRenderer.deactivate();
        }
        mapRenderers.clear();
        downloadedByUrl.clear();
        mapsConfig = YamlConfiguration.loadConfiguration((File)mapsFile);
        ConfigurationSection mapsSection = mapsConfig.getConfigurationSection("MAPS");
        if (mapsSection == null) {
            return;
        }
        for (String string : mapsSection.getKeys(false)) {
            List oldRenderers;
            short mapId = Short.valueOf(string);
            mapView = Bukkit.getServer().getMap(mapId);
            if (mapView == null) {
                dB.echoError("Map #" + string + " does not exist. Has it been removed? Deleting from maps.yml...");
                mapsSection.set(string, null);
                continue;
            }
            ConfigurationSection objectsData = mapsSection.getConfigurationSection(string + ".objects");
            if (oldMapRenderers.containsKey(mapId)) {
                oldRenderers = (List)oldMapRenderers.get(mapId);
            } else {
                oldRenderers = mapView.getRenderers();
                for (MapRenderer oldRenderer : oldRenderers) {
                    mapView.removeRenderer(oldRenderer);
                }
            }
            DenizenMapRenderer renderer = new DenizenMapRenderer(oldRenderers, mapsSection.getBoolean(string + ".auto update", false));
            ArrayList objects = new ArrayList(objectsData.getKeys(false));
            Collections.sort(objects, new NaturalOrderComparator());
            for (String objectKey : objects) {
                String type = objectsData.getString(objectKey + ".type").toUpperCase();
                String xTag = objectsData.getString(objectKey + ".x");
                String yTag = objectsData.getString(objectKey + ".y");
                String visibilityTag = objectsData.getString(objectKey + ".visibility");
                boolean debug = objectsData.getBoolean(objectKey + ".debug");
                MapObject object = null;
                if (type.equals("CURSOR")) {
                    object = new MapCursor(xTag, yTag, visibilityTag, debug, objectsData.getString(objectKey + ".direction"), objectsData.getString(objectKey + ".cursor"));
                } else if (type.equals("IMAGE")) {
                    String file = objectsData.getString(objectKey + ".image");
                    int width = objectsData.getInt(objectKey + ".width", 0);
                    int height = objectsData.getInt(objectKey + ".height", 0);
                    object = file.toLowerCase().endsWith(".gif") ? new MapAnimatedImage(xTag, yTag, visibilityTag, debug, file, width, height) : new MapImage(xTag, yTag, visibilityTag, debug, file, width, height);
                } else if (type.equals("TEXT")) {
                    object = new MapText(xTag, yTag, visibilityTag, debug, objectsData.getString(objectKey + ".text"));
                }
                if (object == null) continue;
                renderer.addObject(object);
            }
            mapView.addRenderer((MapRenderer)renderer);
            mapRenderers.put(mapId, renderer);
        }
        for (Map.Entry entry : oldMapRenderers.entrySet()) {
            short id = (Short)entry.getKey();
            if (mapRenderers.containsKey(id) || (mapView = Bukkit.getServer().getMap(id)) == null) continue;
            for (MapRenderer renderer : (List)entry.getValue()) {
                mapView.addRenderer(renderer);
            }
        }
        ConfigurationSection downloadedImages = mapsConfig.getConfigurationSection("DOWNLOADED");
        if (downloadedImages == null) {
            return;
        }
        for (String image : downloadedImages.getKeys(false)) {
            downloadedByUrl.put(downloadedImages.getString(image).toLowerCase(), image.replace("DOT", "."));
        }
    }

    public static void saveMaps() {
        for (Map.Entry<Short, DenizenMapRenderer> entry : mapRenderers.entrySet()) {
            if (!entry.getValue().isActive()) continue;
            mapsConfig.set("MAPS." + entry.getKey(), entry.getValue().getSaveData());
        }
        for (Map.Entry<Object, Object> entry : downloadedByUrl.entrySet()) {
            mapsConfig.set("DOWNLOADED." + ((String)entry.getValue()).replace(".", "DOT"), entry.getKey());
        }
        try {
            mapsConfig.save(mapsFile);
        }
        catch (Exception e) {
            dB.echoError(e);
        }
    }

    public static void setMap(MapView map, DenizenMapRenderer denizenMapRenderer) {
        List oldRenderers = map.getRenderers();
        for (MapRenderer renderer : oldRenderers) {
            map.removeRenderer(renderer);
        }
        map.addRenderer((MapRenderer)denizenMapRenderer);
        mapRenderers.put(map.getId(), denizenMapRenderer);
    }

    public static DenizenMapRenderer getDenizenRenderer(MapView map) {
        DenizenMapRenderer dmr;
        short mapId = map.getId();
        if (!mapRenderers.containsKey(mapId)) {
            dmr = new DenizenMapRenderer(map.getRenderers(), false);
            DenizenMapManager.setMap(map, dmr);
        } else {
            dmr = mapRenderers.get(mapId);
        }
        return dmr;
    }

    public static List<MapRenderer> removeDenizenRenderers(MapView map) {
        ArrayList<MapRenderer> oldRenderers = new ArrayList<MapRenderer>();
        for (MapRenderer renderer : map.getRenderers()) {
            if (!(renderer instanceof DenizenMapRenderer)) continue;
            map.removeRenderer(renderer);
            oldRenderers.addAll(((DenizenMapRenderer)renderer).getOldRenderers());
            ((DenizenMapRenderer)renderer).deactivate();
            mapRenderers.remove(map.getId());
        }
        return oldRenderers;
    }

    public static String getActualFile(String file) {
        String fileLower = file.toLowerCase();
        if (!fileLower.startsWith("http://") && !fileLower.startsWith("https://")) {
            return new File(imagesFolder, file).getPath();
        }
        try {
            return DenizenMapManager.downloadImage(new URL(file));
        }
        catch (MalformedURLException e) {
            dB.echoError("URL is malformed: " + file);
            return null;
        }
    }

    private static String downloadImage(URL url) {
        try {
            int i;
            File image;
            String urlString;
            if (!imageDownloads.exists()) {
                imageDownloads.mkdirs();
            }
            if (downloadedByUrl.containsKey(urlString = url.toString().toLowerCase()) && (image = new File(imageDownloads, downloadedByUrl.get(urlString))).exists()) {
                return image.getPath();
            }
            URLConnection connection = url.openConnection();
            BufferedInputStream in = new BufferedInputStream(connection.getInputStream());
            int lastDot = urlString.lastIndexOf(46);
            String fileName = String.format("%0" + (6 - String.valueOf(downloadCount).length()) + "d", downloadCount) + (lastDot > 0 ? urlString.substring(lastDot) : "");
            File output = new File(imageDownloads, fileName);
            FileImageOutputStream out = new FileImageOutputStream(output);
            while ((i = in.read()) != -1) {
                out.write(i);
            }
            out.flush();
            out.close();
            in.close();
            downloadedByUrl.put(urlString, fileName);
            ++downloadCount;
            return output.getPath();
        }
        catch (IOException e) {
            dB.echoError(e);
            return null;
        }
    }
}

