/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.utilities.maps;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.utilities.maps.MapObject;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.map.MapCanvas;
import org.bukkit.map.MapRenderer;
import org.bukkit.map.MapView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DenizenMapRenderer
extends MapRenderer {
    private final List<MapObject> mapObjects = new ArrayList<MapObject>();
    private final List<MapRenderer> oldMapRenderers;
    private final boolean autoUpdate;
    private boolean active;

    public DenizenMapRenderer(List<MapRenderer> oldMapRenderers, boolean autoUpdate) {
        super(true);
        this.oldMapRenderers = oldMapRenderers;
        this.autoUpdate = autoUpdate;
        this.active = true;
    }

    public void addObject(MapObject object) {
        if (!this.active) {
            throw new IllegalStateException("DenizenMapRenderer is not active");
        }
        this.mapObjects.add(object);
    }

    public List<MapRenderer> getOldRenderers() {
        return this.oldMapRenderers;
    }

    public void deactivate() {
        if (!this.active) {
            throw new IllegalStateException("Already deactivated");
        }
        this.active = false;
        this.mapObjects.clear();
        this.oldMapRenderers.clear();
    }

    public boolean isActive() {
        return this.active;
    }

    public Map<String, Object> getSaveData() {
        if (this.active) {
            HashMap<String, Object> data = new HashMap<String, Object>();
            HashMap<String, Map<String, Object>> objects = new HashMap<String, Map<String, Object>>();
            for (int i = 0; i < this.mapObjects.size(); ++i) {
                Map<String, Object> objectData = this.mapObjects.get(i).getSaveData();
                objects.put(String.valueOf(i), objectData);
            }
            data.put("objects", objects);
            data.put("auto update", this.autoUpdate);
            return data;
        }
        throw new IllegalStateException("DenizenMapRenderer is not active");
    }

    public void render(MapView mapView, MapCanvas mapCanvas, Player player) {
        if (this.active) {
            UUID uuid = player.getUniqueId();
            dPlayer p = dPlayer.mirrorBukkitPlayer((OfflinePlayer)player);
            for (MapObject object : this.mapObjects) {
                if (this.autoUpdate) {
                    object.update(p, uuid);
                }
                if (!object.isVisibleTo(p, uuid)) continue;
                object.render(mapView, mapCanvas, p, uuid);
            }
        } else {
            mapView.removeRenderer((MapRenderer)this);
        }
    }
}

