/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.utilities.midi;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.Receiver;
import javax.sound.midi.Sequencer;
import javax.sound.midi.ShortMessage;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.utilities.midi.MidiUtil;
import net.aufdemrand.denizen.utilities.midi.ToneUtil;
import net.aufdemrand.denizencore.utilities.debugging.dB;
import org.bukkit.Location;
import org.bukkit.Sound;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NoteBlockReceiver
implements Receiver {
    public float VOLUME_RANGE = 10.0f;
    private List<dEntity> entities;
    private dLocation location;
    private Map<Integer, Integer> channelPatches;
    public String key = null;
    public Sequencer sequencer;

    public NoteBlockReceiver(List<dEntity> entities, String _Key) throws InvalidMidiDataException, IOException {
        this.entities = entities;
        this.location = null;
        this.channelPatches = Maps.newHashMap();
        this.key = _Key;
    }

    public NoteBlockReceiver(dLocation location, String _Key) throws InvalidMidiDataException, IOException {
        this.entities = null;
        this.location = location;
        this.channelPatches = Maps.newHashMap();
        this.key = _Key;
    }

    public void setSequencer(Sequencer sequencer) {
        this.sequencer = sequencer;
    }

    @Override
    public void send(MidiMessage m, long time) {
        if (m instanceof ShortMessage) {
            ShortMessage smessage = (ShortMessage)m;
            int chan = smessage.getChannel();
            switch (smessage.getCommand()) {
                case 192: {
                    int patch = smessage.getData1();
                    this.channelPatches.put(chan, patch);
                    break;
                }
                case 144: {
                    this.playNote(smessage);
                    break;
                }
                case 128: {
                    break;
                }
                case 252: {
                    this.close();
                }
            }
        }
    }

    public void playNote(ShortMessage message) {
        if (144 != message.getCommand()) {
            return;
        }
        int channel = message.getChannel();
        if (channel == 9) {
            return;
        }
        if (this.channelPatches == null) {
            dB.echoError("Trying to play notes on closed midi NoteBlockReceiver!");
            return;
        }
        Integer patch = this.channelPatches.get(channel);
        float pitch = (float)ToneUtil.midiToPitch(message);
        float volume = this.VOLUME_RANGE * ((float)message.getData2() / 127.0f);
        Sound instrument = Sound.NOTE_PIANO;
        if (patch != null) {
            instrument = MidiUtil.patchToInstrument(patch);
        }
        if (this.location != null) {
            this.location.getWorld().playSound((Location)this.location, instrument, volume, pitch);
        } else if (this.entities != null && !this.entities.isEmpty()) {
            for (int i = 0; i < this.entities.size(); ++i) {
                dEntity entity = this.entities.get(i);
                if (entity.isSpawned()) {
                    if (entity.isPlayer()) {
                        entity.getPlayer().playSound((Location)entity.getLocation(), instrument, volume, pitch);
                        continue;
                    }
                    entity.getWorld().playSound((Location)entity.getLocation(), instrument, volume, pitch);
                    continue;
                }
                this.entities.remove(i);
                --i;
            }
        } else {
            this.close();
        }
    }

    @Override
    public void close() {
        this.entities = null;
        this.location = null;
        this.channelPatches.clear();
        this.channelPatches = null;
        if (MidiUtil.receivers.containsKey(this.key)) {
            MidiUtil.receivers.remove(this.key);
        }
        if (this.sequencer != null) {
            this.sequencer.close();
            this.sequencer = null;
        }
    }
}

