/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizencore.utilities;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import net.aufdemrand.denizencore.utilities.debugging.dB;
import net.aufdemrand.denizencore.utilities.text.StringHolder;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public class YamlConfiguration {
    Map<StringHolder, Object> contents = new HashMap<StringHolder, Object>();

    public static YamlConfiguration load(String data) {
        DumperOptions options = new DumperOptions();
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        options.setAllowUnicode(true);
        Yaml yaml = new Yaml(options);
        Object obj = yaml.load(data);
        YamlConfiguration config = new YamlConfiguration();
        if (obj == null) {
            return null;
        }
        if (obj instanceof String) {
            config.contents = new HashMap<StringHolder, Object>();
            config.contents.put(null, obj);
        } else if (obj instanceof Map) {
            config.contents = (Map)obj;
        } else {
            dB.echoError("Invalid YAML object type: " + obj.toString() + " is " + obj.getClass().getSimpleName());
            return null;
        }
        YamlConfiguration.switchKeys(config.contents);
        return config;
    }

    private static void switchKeys(Map<StringHolder, Object> objs) {
        for (StringHolder stringHolder : new HashSet<StringHolder>(objs.keySet())) {
            Object got = objs.get(stringHolder);
            objs.remove(stringHolder);
            objs.put(new StringHolder(((Object)stringHolder).toString()), got);
        }
        for (Map.Entry entry : objs.entrySet()) {
            if (!(entry.getValue() instanceof Map)) continue;
            Map map = (Map)entry.getValue();
            YamlConfiguration.switchKeys(map);
            objs.remove(map);
            objs.put((StringHolder)entry.getKey(), map);
        }
    }

    private static Map<String, Object> reverse(Map<StringHolder, Object> objs) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Map.Entry<StringHolder, Object> obj : objs.entrySet()) {
            if (obj.getValue() instanceof Map) {
                map.put(obj.getKey().str, YamlConfiguration.reverse((Map)obj.getValue()));
                continue;
            }
            map.put(obj.getKey().str, obj.getValue());
        }
        return map;
    }

    private static List<String> patchListNonsense(List<Object> objs) {
        ArrayList<String> list = new ArrayList<String>();
        for (Object o : objs) {
            if (o == null) {
                list.add("null");
                continue;
            }
            list.add(o.toString());
        }
        return list;
    }

    public Set<StringHolder> getKeys(boolean deep) {
        if (!deep) {
            return new HashSet<StringHolder>(this.contents.keySet());
        }
        return this.getKeysDeep(this.contents);
    }

    public Map<StringHolder, Object> getMap() {
        return new HashMap<StringHolder, Object>(this.contents);
    }

    private Set<StringHolder> getKeysDeep(Map<StringHolder, Object> objs) {
        HashSet<StringHolder> strings = new HashSet<StringHolder>(objs.keySet());
        for (Map.Entry<StringHolder, Object> str : objs.entrySet()) {
            if (!(str.getValue() instanceof Map)) continue;
            strings.addAll(this.getKeysDeep((Map)str.getValue()));
        }
        return strings;
    }

    public String saveToString() {
        DumperOptions options = new DumperOptions();
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        options.setAllowUnicode(true);
        Yaml yaml = new Yaml(options);
        String dumped = yaml.dump(YamlConfiguration.reverse(this.contents));
        if (dB.verbose) {
            dB.log("Outputting " + dumped);
        }
        return dumped;
    }

    public Object get(String path) {
        List<String> parts = CoreUtilities.split(path, '.');
        Map portion = this.contents;
        for (int i = 0; i < parts.size(); ++i) {
            Object oPortion = portion.get(new StringHolder(parts.get(i)));
            if (oPortion == null) {
                return null;
            }
            if (parts.size() == i + 1) {
                return oPortion;
            }
            if (!(oPortion instanceof Map)) {
                return null;
            }
            portion = (Map)oPortion;
        }
        return null;
    }

    public void set(String path, Object o) {
        if (o instanceof YamlConfiguration) {
            o = new HashMap<StringHolder, Object>(((YamlConfiguration)((Object)o)).contents);
        }
        List<String> parts = CoreUtilities.split(path, '.');
        HashMap portion = this.contents;
        for (int i = 0; i < parts.size(); ++i) {
            HashMap map;
            Object oPortion = portion.get(new StringHolder(parts.get(i)));
            if (parts.size() == i + 1) {
                if (o == null) {
                    portion.remove(new StringHolder(parts.get(i)));
                    this.emptyEmptyMaps(parts);
                } else {
                    portion.put(new StringHolder(parts.get(i)), o);
                }
                return;
            }
            if (oPortion == null) {
                map = new HashMap();
                portion.put(new StringHolder(parts.get(i)), map);
                portion = map;
                continue;
            }
            if (oPortion instanceof Map) {
                portion = (HashMap)oPortion;
                continue;
            }
            map = new HashMap();
            portion.put(new StringHolder(parts.get(i)), map);
            portion = map;
        }
        dB.echoError("Failed to set somehow?");
    }

    void emptyEmptyMaps(List<String> parts) {
        Map portion = this.contents;
        for (int i = 0; i < parts.size(); ++i) {
            Object oPortion = portion.get(new StringHolder(parts.get(i)));
            if (oPortion == null) {
                return;
            }
            if (oPortion instanceof Map) {
                if (((Map)oPortion).size() == 0) {
                    portion.remove(new StringHolder(parts.get(i)));
                    this.emptyEmptyMaps(parts);
                    return;
                }
            } else {
                return;
            }
            portion = (Map)oPortion;
        }
    }

    public boolean contains(String path) {
        return this.get(path) != null;
    }

    public String getString(String path) {
        Object o = this.get(path);
        if (o == null) {
            return null;
        }
        return o.toString();
    }

    public String getString(String path, String def) {
        Object o = this.get(path);
        if (o == null) {
            return def;
        }
        return o.toString();
    }

    public boolean isList(String path) {
        Object o = this.get(path);
        if (o == null) {
            return false;
        }
        return o instanceof List;
    }

    public List<Object> getList(String path) {
        Object o = this.get(path);
        if (o == null) {
            return null;
        }
        if (!(o instanceof List)) {
            return null;
        }
        return (List)o;
    }

    public List<String> getStringList(String path) {
        Object o = this.get(path);
        if (o == null) {
            return null;
        }
        if (!(o instanceof List)) {
            return null;
        }
        return YamlConfiguration.patchListNonsense((List)o);
    }

    public YamlConfiguration getConfigurationSection(String path) {
        try {
            List<String> parts = CoreUtilities.split(path, '.');
            Map portion = this.contents;
            for (int i = 0; i < parts.size(); ++i) {
                Object oPortion = portion.get(new StringHolder(parts.get(i)));
                if (oPortion == null) {
                    return null;
                }
                if (parts.size() == i + 1) {
                    YamlConfiguration configuration = new YamlConfiguration();
                    if (!(oPortion instanceof Map)) {
                        return null;
                    }
                    configuration.contents = (Map)oPortion;
                    return configuration;
                }
                if (!(oPortion instanceof Map)) {
                    return null;
                }
                portion = (Map)oPortion;
            }
        }
        catch (Exception e) {
            dB.echoError(e);
        }
        return null;
    }
}

