/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.entity;

import net.aufdemrand.denizen.events.BukkitScriptEvent;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreeperPowerEvent;
import org.bukkit.plugin.Plugin;

public class CreeperPoweredScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static CreeperPoweredScriptEvent instance;
    public dEntity lightning;
    public dEntity entity;
    public Element cause;
    public CreeperPowerEvent event;

    public CreeperPoweredScriptEvent() {
        instance = this;
    }

    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        return lower.startsWith("creeper powered");
    }

    public boolean matches(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        String reason = CoreUtilities.getXthArg(3, lower);
        if (CoreUtilities.getXthArg(2, lower).equals("because") && !reason.equals(CoreUtilities.toLowerCase(this.cause.toString()))) {
            return false;
        }
        return this.runInCheck(scriptContainer, s, lower, this.event.getEntity().getLocation());
    }

    public String getName() {
        return "CreeperPowered";
    }

    public void init() {
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
    }

    public void destroy() {
        CreeperPowerEvent.getHandlerList().unregister((Listener)this);
    }

    public boolean applyDetermination(ScriptContainer container, String determination) {
        return super.applyDetermination(container, determination);
    }

    public dObject getContext(String name) {
        if (name.equals("entity")) {
            return this.entity;
        }
        if (name.equals("lightning") && this.lightning != null) {
            return this.lightning;
        }
        if (name.equals("cause")) {
            return this.cause;
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onCreeperPowered(CreeperPowerEvent event) {
        this.lightning = new dEntity((Entity)event.getLightning());
        this.entity = new dEntity((Entity)event.getEntity());
        this.cause = new Element(event.getCause().name());
        this.cancelled = event.isCancelled();
        this.event = event;
        this.fire();
        event.setCancelled(this.cancelled);
    }
}

