/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.entity;

import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.events.BukkitScriptEvent;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.ScriptEntryData;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.Bukkit;
import org.bukkit.DyeColor;
import org.bukkit.entity.Entity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.SheepDyeWoolEvent;
import org.bukkit.plugin.Plugin;

public class SheepDyedScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static SheepDyedScriptEvent instance;
    public dEntity entity;
    public DyeColor color;
    public SheepDyeWoolEvent event;

    public SheepDyedScriptEvent() {
        instance = this;
    }

    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        String cmd = CoreUtilities.getXthArg(1, lower);
        return cmd.equals("dyed") || cmd.equals("dyes");
    }

    public boolean matches(ScriptContainer scriptContainer, String s) {
        String new_color;
        String sheep;
        String lower = CoreUtilities.toLowerCase(s);
        String cmd = CoreUtilities.getXthArg(1, lower);
        String string = sheep = cmd.equals("dyed") ? CoreUtilities.getXthArg(0, lower) : CoreUtilities.getXthArg(3, lower);
        if (!this.entity.matchesEntity(sheep)) {
            return false;
        }
        String string2 = new_color = cmd.equals("dyes") ? CoreUtilities.getXthArg(3, lower) : CoreUtilities.getXthArg(2, lower);
        if (new_color.length() > 0 && !new_color.equals(CoreUtilities.toLowerCase(this.color.toString()))) {
            return false;
        }
        return this.runInCheck(scriptContainer, s, lower, this.entity.getLocation());
    }

    public String getName() {
        return "SheepDyed";
    }

    public void init() {
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
    }

    public void destroy() {
        SheepDyeWoolEvent.getHandlerList().unregister((Listener)this);
    }

    public boolean applyDetermination(ScriptContainer container, String determination) {
        if (!CoreUtilities.toLowerCase(determination).equals("cancelled")) {
            try {
                this.color = DyeColor.valueOf((String)determination.toUpperCase());
                return true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return super.applyDetermination(container, determination);
    }

    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(null, null);
    }

    public dObject getContext(String name) {
        if (name.equals("color")) {
            return new Element(this.color.toString());
        }
        if (name.equals("entity")) {
            return this.entity;
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onSheepDyed(SheepDyeWoolEvent event) {
        this.entity = new dEntity((Entity)event.getEntity());
        this.color = DyeColor.valueOf((String)event.getColor().toString());
        this.cancelled = event.isCancelled();
        this.event = event;
        this.fire();
        event.setCancelled(this.cancelled);
        event.setColor(this.color);
    }
}

