/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.entity;

import net.aufdemrand.denizen.events.BukkitScriptEvent;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.objects.dMaterial;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.vehicle.VehicleBlockCollisionEvent;
import org.bukkit.plugin.Plugin;

public class VehicleCollidesBlockScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static VehicleCollidesBlockScriptEvent instance;
    public dEntity vehicle;
    public dLocation location;
    private dMaterial material;
    public VehicleBlockCollisionEvent event;

    public VehicleCollidesBlockScriptEvent() {
        instance = this;
    }

    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        return lower.contains("collides with");
    }

    public boolean matches(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        String ent = CoreUtilities.getXthArg(0, lower);
        if (!this.vehicle.matchesEntity(ent)) {
            return false;
        }
        String mat = CoreUtilities.getXthArg(3, lower);
        if (!this.tryMaterial(this.material, mat)) {
            return false;
        }
        return this.runInCheck(scriptContainer, s, lower, this.location);
    }

    public String getName() {
        return "VehicleCollidesBlock";
    }

    public void init() {
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
    }

    public void destroy() {
        VehicleBlockCollisionEvent.getHandlerList().unregister((Listener)this);
    }

    public boolean applyDetermination(ScriptContainer container, String determination) {
        return super.applyDetermination(container, determination);
    }

    public dObject getContext(String name) {
        if (name.equals("vehicle")) {
            return this.vehicle;
        }
        if (name.equals("location")) {
            return this.location;
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onVehicleCollidesBlock(VehicleBlockCollisionEvent event) {
        this.vehicle = new dEntity((Entity)event.getVehicle());
        this.location = new dLocation(event.getBlock().getLocation());
        this.material = dMaterial.getMaterialFrom(event.getBlock().getType(), event.getBlock().getData());
        this.event = event;
        this.fire();
    }
}

