/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.player;

import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.events.BukkitScriptEvent;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.ScriptEntryData;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerExpChangeEvent;
import org.bukkit.plugin.Plugin;

public class PlayerChangesXPScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static PlayerChangesXPScriptEvent instance;
    public int amount;
    public PlayerExpChangeEvent event;

    public PlayerChangesXPScriptEvent() {
        instance = this;
    }

    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        return CoreUtilities.toLowerCase(s).startsWith("player changes xp");
    }

    public boolean matches(ScriptContainer scriptContainer, String s) {
        return true;
    }

    public String getName() {
        return "PlayerChangesXP";
    }

    public void init() {
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
    }

    public void destroy() {
        PlayerExpChangeEvent.getHandlerList().unregister((Listener)this);
    }

    public boolean applyDetermination(ScriptContainer container, String determination) {
        String lower = CoreUtilities.toLowerCase(determination);
        if (aH.matchesInteger(determination)) {
            this.amount = aH.getIntegerFrom(determination);
            return true;
        }
        if (lower.equals("cancelled")) {
            this.amount = 0;
            return true;
        }
        return super.applyDetermination(container, determination);
    }

    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(dEntity.isPlayer((Entity)this.event.getPlayer()) ? dEntity.getPlayerFrom((Entity)this.event.getPlayer()) : null, null);
    }

    public dObject getContext(String name) {
        if (name.equals("amount")) {
            return new Element(this.amount);
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onPlayerChangesXP(PlayerExpChangeEvent event) {
        if (dEntity.isNPC((Entity)event.getPlayer())) {
            return;
        }
        this.amount = event.getAmount();
        this.event = event;
        this.fire();
        event.setAmount(this.amount);
    }
}

