/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.player;

import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.events.BukkitScriptEvent;
import net.aufdemrand.denizen.objects.dCuboid;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.objects.dMaterial;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.ScriptEntryData;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockDamageEvent;
import org.bukkit.plugin.Plugin;

public class PlayerDamagesBlockScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static PlayerDamagesBlockScriptEvent instance;
    public dLocation location;
    public dMaterial material;
    public dList cuboids;
    public Boolean instabreak;
    public BlockDamageEvent event;

    public PlayerDamagesBlockScriptEvent() {
        instance = this;
    }

    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        String mat = CoreUtilities.getXthArg(2, lower);
        return lower.startsWith("player damages") && (mat.equals("block") || dMaterial.matches(mat));
    }

    public boolean matches(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        String mat = CoreUtilities.getXthArg(2, lower);
        if (!this.tryMaterial(this.material, mat)) {
            return false;
        }
        return this.runInCheck(scriptContainer, s, lower, this.location);
    }

    public String getName() {
        return "PlayerDamagesBlock";
    }

    public void init() {
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
    }

    public void destroy() {
        BlockDamageEvent.getHandlerList().unregister((Listener)this);
    }

    public boolean applyDetermination(ScriptContainer container, String determination) {
        if (determination.toLowerCase().equals("instabreak")) {
            this.instabreak = true;
        }
        return super.applyDetermination(container, determination);
    }

    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(new dPlayer(this.event.getPlayer()), null);
    }

    public dObject getContext(String name) {
        if (name.equals("location")) {
            return this.location;
        }
        if (name.equals("material")) {
            return this.material;
        }
        if (name.equals("cuboids")) {
            return this.cuboids;
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onPlayerDamagesBlock(BlockDamageEvent event) {
        if (dEntity.isNPC((Entity)event.getPlayer())) {
            return;
        }
        this.material = dMaterial.getMaterialFrom(event.getBlock().getType(), event.getBlock().getData());
        this.location = new dLocation(event.getBlock().getLocation());
        this.cuboids = new dList();
        for (dCuboid cuboid : dCuboid.getNotableCuboidsContaining(this.location)) {
            this.cuboids.add(cuboid.identifySimple());
        }
        this.cancelled = event.isCancelled();
        this.instabreak = event.getInstaBreak();
        this.event = event;
        this.fire();
        event.setCancelled(this.cancelled);
        event.setInstaBreak(this.instabreak.booleanValue());
    }
}

