/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.player;

import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.events.BukkitScriptEvent;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.ScriptEntryData;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerLeashEntityEvent;
import org.bukkit.plugin.Plugin;

public class PlayerLeashesScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static PlayerLeashesScriptEvent instance;
    public dEntity entity;
    public dEntity holder;
    public PlayerLeashEntityEvent event;

    public PlayerLeashesScriptEvent() {
        instance = this;
    }

    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        return CoreUtilities.toLowerCase(s).startsWith("player leashes");
    }

    public boolean matches(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        String target = CoreUtilities.getXthArg(2, lower);
        if (target.length() > 0 && !target.equals(CoreUtilities.toLowerCase(this.entity.getName()))) {
            return false;
        }
        return this.runInCheck(scriptContainer, s, lower, this.entity.getLocation());
    }

    public String getName() {
        return "PlayerLeashes";
    }

    public void init() {
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
    }

    public void destroy() {
        PlayerLeashEntityEvent.getHandlerList().unregister((Listener)this);
    }

    public boolean applyDetermination(ScriptContainer container, String determination) {
        return super.applyDetermination(container, determination);
    }

    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.holder.isPlayer() ? this.holder.getDenizenPlayer() : null, null);
    }

    public dObject getContext(String name) {
        if (name.equals("holder")) {
            return this.holder;
        }
        if (name.equals("entity")) {
            return this.entity;
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onPlayerLeashes(PlayerLeashEntityEvent event) {
        if (dEntity.isNPC((Entity)event.getPlayer())) {
            return;
        }
        this.holder = new dEntity((Entity)event.getPlayer());
        this.entity = new dEntity(event.getEntity());
        this.event = event;
        this.cancelled = event.isCancelled();
        this.fire();
        event.setCancelled(this.cancelled);
    }
}

