/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.player;

import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.events.BukkitScriptEvent;
import net.aufdemrand.denizen.objects.dCuboid;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.ScriptEntryData;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.plugin.Plugin;

public class PlayerRightClicksEntityScriptEvent
extends BukkitScriptEvent
implements Listener {
    PlayerRightClicksEntityScriptEvent instance;
    PlayerInteractEntityEvent event;
    dEntity entity;
    dItem item;
    dLocation location;
    dList cuboids;

    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        return lower.startsWith("player right clicks") && !CoreUtilities.getXthArg(3, lower).equals("at");
    }

    public boolean matches(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        if (!this.tryEntity(this.entity, CoreUtilities.getXthArg(3, lower))) {
            return false;
        }
        if (!this.runInCheck(scriptContainer, s, lower, this.event.getPlayer().getLocation())) {
            return false;
        }
        if (!this.runWithCheck(scriptContainer, s, lower, new dItem(this.event.getPlayer().getItemInHand()))) {
            return false;
        }
        return !CoreUtilities.xthArgEquals(4, lower, "with") || this.tryItem(new dItem(this.event.getPlayer().getItemInHand()), CoreUtilities.getXthArg(5, lower));
    }

    public String getName() {
        return "PlayerRightClicksEntity";
    }

    public void init() {
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
    }

    public void destroy() {
        PlayerInteractEntityEvent.getHandlerList().unregister((Listener)this);
    }

    public boolean applyDetermination(ScriptContainer container, String determination) {
        return super.applyDetermination(container, determination);
    }

    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(new dPlayer(this.event.getPlayer()), null);
    }

    public dObject getContext(String name) {
        if (name.equals("entity")) {
            return this.entity;
        }
        if (name.equals("item")) {
            return this.item;
        }
        if (name.equals("location")) {
            return this.location;
        }
        if (name.equals("cuboids")) {
            return this.cuboids;
        }
        return super.getContext(name);
    }

    @EventHandler
    public void playerRightClicksEntity(PlayerInteractEntityEvent event) {
        this.entity = new dEntity(event.getRightClicked());
        this.item = new dItem(event.getPlayer().getItemInHand());
        this.location = new dLocation(event.getRightClicked().getLocation());
        this.cuboids = new dList();
        for (dCuboid cuboid : dCuboid.getNotableCuboidsContaining(this.location)) {
            this.cuboids.add(cuboid.identify());
        }
        this.cancelled = event.isCancelled();
        this.event = event;
        this.fire();
        event.setCancelled(this.cancelled);
    }
}

