/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.listeners;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.aufdemrand.denizen.Denizen;
import net.aufdemrand.denizen.objects.dNPC;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dScript;
import org.bukkit.Bukkit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractListener {
    protected Denizen denizen;
    protected String type;
    public String id;
    protected dPlayer player;
    protected dScript scriptName;
    protected dNPC npc;
    protected Map<String, Object> savable = new HashMap<String, Object>();

    public AbstractListener() {
        this.denizen = (Denizen)Bukkit.getServer().getPluginManager().getPlugin("Denizen");
    }

    public void build(dPlayer player, String listenerId, String listenerType, List<aH.Argument> args, dScript finishScript, dNPC npc) {
        this.player = player;
        this.id = listenerId;
        this.type = listenerType;
        this.scriptName = finishScript;
        this.npc = npc;
        this.onBuild(args);
        this.save();
        this.constructed();
    }

    public void cancel() {
        this.onCancel();
        this.denizen.getListenerRegistry().cancel(this.player, this.id);
        this.deconstructed();
    }

    public abstract void constructed();

    public abstract void deconstructed();

    public void finish() {
        this.onFinish();
        this.denizen.getListenerRegistry().finish(this.player, this.npc, this.id, this.scriptName);
        this.deconstructed();
    }

    public Object get(String key) {
        return this.denizen.getSaves().get("Listeners." + this.player.getSaveName() + "." + this.id + "." + key);
    }

    public String getListenerId() {
        return this.id != null ? this.id : "";
    }

    public String getListenerType() {
        return this.type != null ? this.type : "";
    }

    public void load(dPlayer player, dNPC npc, String id, String listenerType) {
        this.player = player;
        this.id = id;
        this.type = listenerType;
        this.scriptName = dScript.valueOf((String)this.get("Finish Script"));
        this.npc = npc;
        try {
            this.onLoad();
        }
        catch (Exception e) {
            dB.echoError("Problem loading saved listener '" + id + "' for " + player.getName() + "!");
        }
        this.constructed();
    }

    public abstract void onBuild(List<aH.Argument> var1);

    public abstract void onCancel();

    public abstract void onFinish();

    public abstract void onLoad();

    public abstract void onSave();

    public abstract String report();

    public void save() {
        this.denizen.getSaves().set("Listeners." + this.player.getSaveName() + "." + this.id + ".Listener Type", (Object)this.type);
        this.denizen.getSaves().set("Listeners." + this.player.getSaveName() + "." + this.id + ".Finish Script", (Object)this.scriptName.toString());
        if (this.npc != null) {
            this.denizen.getSaves().set("Listeners." + this.player.getSaveName() + "." + this.id + ".Linked NPCID", (Object)this.npc.getId());
        }
        this.onSave();
        try {
            if (!this.savable.isEmpty()) {
                for (Map.Entry<String, Object> entry : this.savable.entrySet()) {
                    this.denizen.getSaves().set("Listeners." + this.player.getSaveName() + "." + this.id + "." + entry.getKey(), entry.getValue());
                }
            }
        }
        catch (Exception e) {
            dB.echoError("Problem saving listener '" + this.id + "' for " + this.player.getSaveName() + "!");
        }
        this.deconstructed();
    }

    public void store(String key, Object object) {
        this.savable.put(key, object);
    }
}

