/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.objects;

import java.util.HashMap;
import java.util.List;
import net.aufdemrand.denizen.utilities.BiomeNMS;
import net.aufdemrand.denizencore.objects.Adjustable;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.Fetchable;
import net.aufdemrand.denizencore.objects.Mechanism;
import net.aufdemrand.denizencore.objects.TagRunnable;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.tags.Attribute;
import net.aufdemrand.denizencore.tags.TagContext;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import net.aufdemrand.denizencore.utilities.debugging.dB;
import org.bukkit.block.Biome;
import org.bukkit.entity.EntityType;

public class dBiome
implements dObject,
Adjustable {
    private BiomeNMS biome;
    String prefix = "biome";
    public static HashMap<String, TagRunnable> registeredTags = new HashMap();

    public static dBiome valueOf(String string) {
        return dBiome.valueOf(string, null);
    }

    @Fetchable(value="b")
    public static dBiome valueOf(String string, TagContext context) {
        if (string.startsWith("b@")) {
            string = string.substring(2);
        }
        for (Biome biome : Biome.values()) {
            if (!biome.name().equalsIgnoreCase(string)) continue;
            return new dBiome(biome);
        }
        return null;
    }

    public static boolean matches(String arg) {
        if (arg.startsWith("b@")) {
            arg = arg.substring(2);
        }
        for (Biome b : Biome.values()) {
            if (!b.name().equalsIgnoreCase(arg)) continue;
            return true;
        }
        return false;
    }

    public dBiome(Biome biome) {
        this.biome = new BiomeNMS(biome);
    }

    public BiomeNMS getBiome() {
        return this.biome;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String debug() {
        return this.prefix + "='<A>" + this.identify() + "<G>'  ";
    }

    public boolean isUnique() {
        return false;
    }

    public String getObjectType() {
        return "Biome";
    }

    public String identify() {
        return "b@" + this.biome.getName().toLowerCase();
    }

    public String identifySimple() {
        return this.identify();
    }

    public dObject setPrefix(String prefix) {
        if (prefix != null) {
            this.prefix = prefix;
        }
        return this;
    }

    public static void registerTags() {
        dBiome.registerTag("downfall_type", new TagRunnable(){

            public String run(Attribute attribute, dObject object) {
                return new Element(CoreUtilities.toLowerCase(((dBiome)object).biome.getDownfallType().name())).getAttribute(attribute.fulfill(1));
            }
        });
        dBiome.registerTag("humidity", new TagRunnable(){

            public String run(Attribute attribute, dObject object) {
                return new Element(((dBiome)object).biome.getHumidity()).getAttribute(attribute.fulfill(1));
            }
        });
        dBiome.registerTag("temperature", new TagRunnable(){

            public String run(Attribute attribute, dObject object) {
                return new Element(((dBiome)object).biome.getTemperature()).getAttribute(attribute.fulfill(1));
            }
        });
        dBiome.registerTag("spawnable_entities", new TagRunnable(){

            public String run(Attribute attribute, dObject object) {
                List<EntityType> entityTypes;
                attribute = attribute.fulfill(1);
                BiomeNMS biome = ((dBiome)object).biome;
                boolean hasAttribute = true;
                if (attribute.startsWith("ambient")) {
                    entityTypes = biome.getAmbientEntities();
                } else if (attribute.startsWith("creatures")) {
                    entityTypes = biome.getCreatureEntities();
                } else if (attribute.startsWith("monsters")) {
                    entityTypes = biome.getMonsterEntities();
                } else if (attribute.startsWith("water")) {
                    entityTypes = biome.getWaterEntities();
                } else {
                    entityTypes = biome.getAllEntities();
                    hasAttribute = false;
                }
                dList list = new dList();
                for (EntityType entityType : entityTypes) {
                    list.add(entityType.name());
                }
                return list.getAttribute(hasAttribute ? attribute.fulfill(1) : attribute);
            }
        });
    }

    public static void registerTag(String name, TagRunnable runnable) {
        if (runnable.name == null) {
            runnable.name = name;
        }
        registeredTags.put(name, runnable);
    }

    public String getAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        String attrLow = CoreUtilities.toLowerCase(attribute.getAttributeWithoutContext(1));
        TagRunnable tr = registeredTags.get(attrLow);
        if (tr != null) {
            if (!tr.name.equals(attrLow)) {
                dB.echoError(attribute.getScriptEntry() != null ? attribute.getScriptEntry().getResidingQueue() : null, "Using deprecated form of tag '" + tr.name + "': '" + attrLow + "'.");
            }
            return tr.run(attribute, this);
        }
        return new Element(this.identify()).getAttribute(attribute);
    }

    public void applyProperty(Mechanism mechanism) {
        net.aufdemrand.denizen.utilities.debugging.dB.echoError("Cannot apply properties to a biome!");
    }

    public void adjust(Mechanism mechanism) {
        Element value = mechanism.getValue();
        if (mechanism.matches("humidity") && mechanism.requireFloat()) {
            this.biome.setHumidity(value.asFloat());
        }
        if (mechanism.matches("temperature") && mechanism.requireFloat()) {
            this.biome.setTemperature(value.asFloat());
        }
    }
}

