/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.objects;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.aufdemrand.denizen.flags.FlagManager;
import net.aufdemrand.denizen.objects.dInventory;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.objects.dMaterial;
import net.aufdemrand.denizen.objects.dNPC;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.objects.dWorld;
import net.aufdemrand.denizen.objects.properties.entity.EntityAge;
import net.aufdemrand.denizen.objects.properties.entity.EntityColor;
import net.aufdemrand.denizen.objects.properties.entity.EntityTame;
import net.aufdemrand.denizen.scripts.containers.core.EntityScriptContainer;
import net.aufdemrand.denizen.scripts.containers.core.EntityScriptHelper;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizen.utilities.depends.Depends;
import net.aufdemrand.denizen.utilities.entity.CraftFakePlayer;
import net.aufdemrand.denizen.utilities.entity.DenizenEntityType;
import net.aufdemrand.denizen.utilities.entity.Rotation;
import net.aufdemrand.denizen.utilities.nbt.CustomNBT;
import net.aufdemrand.denizencore.objects.Adjustable;
import net.aufdemrand.denizencore.objects.Duration;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.Fetchable;
import net.aufdemrand.denizencore.objects.Mechanism;
import net.aufdemrand.denizencore.objects.ObjectFetcher;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.objects.dScript;
import net.aufdemrand.denizencore.objects.properties.Property;
import net.aufdemrand.denizencore.objects.properties.PropertyParser;
import net.aufdemrand.denizencore.scripts.ScriptRegistry;
import net.aufdemrand.denizencore.tags.Attribute;
import net.aufdemrand.denizencore.tags.TagContext;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import net.citizensnpcs.api.CitizensAPI;
import net.minecraft.server.v1_8_R3.Block;
import net.minecraft.server.v1_8_R3.BlockPosition;
import net.minecraft.server.v1_8_R3.EntityHuman;
import net.minecraft.server.v1_8_R3.EntityLiving;
import net.minecraft.server.v1_8_R3.EnumDirection;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.EntityEffect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.block.BlockFace;
import org.bukkit.craftbukkit.v1_8_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_8_R3.entity.CraftAnimals;
import org.bukkit.craftbukkit.v1_8_R3.entity.CraftCreature;
import org.bukkit.craftbukkit.v1_8_R3.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_8_R3.entity.CraftPlayer;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Hanging;
import org.bukkit.entity.Horse;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Ocelot;
import org.bukkit.entity.Pig;
import org.bukkit.entity.PigZombie;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Sheep;
import org.bukkit.entity.Skeleton;
import org.bukkit.entity.Slime;
import org.bukkit.entity.Vehicle;
import org.bukkit.entity.Villager;
import org.bukkit.entity.WitherSkull;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class dEntity
implements dObject,
Adjustable {
    private static final Map<UUID, Entity> rememberedEntities = new HashMap<UUID, Entity>();
    static final Pattern entity_by_id = Pattern.compile("(n@|e@|p@)(.+)", 2);
    static final Pattern entity_with_data = Pattern.compile("(\\w+),?(\\w+)?,?(\\w+)?", 2);
    private Entity entity = null;
    private DenizenEntityType entity_type = null;
    private String data1 = null;
    private String data2 = null;
    private DespawnedEntity despawned_entity = null;
    private dNPC npc = null;
    private UUID uuid = null;
    private String entityScript = null;
    private String prefix = "Entity";
    private ArrayList<Mechanism> mechanisms = new ArrayList();

    public static void rememberEntity(Entity entity) {
        if (entity == null) {
            return;
        }
        rememberedEntities.put(entity.getUniqueId(), entity);
    }

    public static void forgetEntity(Entity entity) {
        if (entity == null) {
            return;
        }
        rememberedEntities.remove(entity.getUniqueId());
    }

    public static boolean isNPC(Entity entity) {
        return entity != null && entity.hasMetadata("NPC") && ((MetadataValue)entity.getMetadata("NPC").get(0)).asBoolean();
    }

    public static boolean isCitizensNPC(Entity entity) {
        return entity != null && Depends.citizens != null && CitizensAPI.getNPCRegistry().isNPC(entity);
    }

    public static dNPC getNPCFrom(Entity entity) {
        if (dEntity.isCitizensNPC(entity)) {
            return dNPC.fromEntity(entity);
        }
        return null;
    }

    public static boolean isPlayer(Entity entity) {
        return entity != null && entity instanceof Player && !dEntity.isNPC(entity);
    }

    public static dPlayer getPlayerFrom(Entity entity) {
        if (dEntity.isPlayer(entity)) {
            return dPlayer.mirrorBukkitPlayer((OfflinePlayer)((Player)entity));
        }
        return null;
    }

    public dItem getItemInHand() {
        if (this.isLivingEntity()) {
            return new dItem(this.getLivingEntity().getEquipment().getItemInHand().clone());
        }
        return null;
    }

    public static dEntity valueOf(String string) {
        return dEntity.valueOf(string, null);
    }

    @Fetchable(value="e")
    public static dEntity valueOf(String string, TagContext context) {
        if (string == null) {
            return null;
        }
        Matcher m = ObjectFetcher.DESCRIBED_PATTERN.matcher(string);
        if (m.matches()) {
            return ObjectFetcher.getObjectFrom(dEntity.class, string, context);
        }
        if (string.equalsIgnoreCase("RANDOM")) {
            EntityType randomType = null;
            while (randomType == null || randomType.name().matches("^(COMPLEX_PART|DROPPED_ITEM|ENDER_CRYSTAL|ENDER_DRAGON|FISHING_HOOK|ITEM_FRAME|LEASH_HITCH|LIGHTNING|PAINTING|PLAYER|UNKNOWN|WEATHER|WITHER|WITHER_SKULL)$")) {
                randomType = EntityType.values()[CoreUtilities.getRandom().nextInt(EntityType.values().length)];
            }
            return new dEntity(DenizenEntityType.getByName(randomType.name()), "RANDOM");
        }
        m = entity_by_id.matcher(string);
        if (m.matches()) {
            String entityGroup = m.group(1).toUpperCase();
            if (entityGroup.matches("N@")) {
                dNPC npc = dNPC.valueOf(string);
                if (npc != null) {
                    return new dEntity(npc);
                }
                dB.echoError("NPC '" + string + "' does not exist!");
            } else if (entityGroup.matches("P@")) {
                Player returnable = dPlayer.valueOf(m.group(2)).getPlayerEntity();
                if (returnable != null) {
                    return new dEntity((Entity)returnable);
                }
                if (context == null || context.debug) {
                    dB.echoError("Invalid Player! '" + m.group(2) + "' could not be found. Has the player logged off?");
                }
            } else {
                try {
                    UUID entityID = UUID.fromString(m.group(2));
                    Entity entity = dEntity.getEntityForID(entityID);
                    if (entity != null) {
                        return new dEntity(entity);
                    }
                    return null;
                }
                catch (Exception ex) {
                    ex.getCause();
                }
            }
        }
        if (ScriptRegistry.containsScript(string = string.replace("e@", ""), EntityScriptContainer.class)) {
            return ScriptRegistry.getScriptContainerAs(string, EntityScriptContainer.class).getEntityFrom();
        }
        m = entity_with_data.matcher(string);
        if (m.matches()) {
            String data1 = null;
            String data2 = null;
            if (m.group(2) != null) {
                data1 = m.group(2);
            }
            if (m.group(3) != null) {
                data2 = m.group(3);
            }
            if (DenizenEntityType.isRegistered(m.group(1))) {
                return new dEntity(DenizenEntityType.getByName(m.group(1)), data1, data2);
            }
        }
        if (context == null || context.debug) {
            dB.log("valueOf dEntity returning null: " + string);
        }
        return null;
    }

    public static Entity getEntityForID(UUID id) {
        if (rememberedEntities.containsKey(id)) {
            return rememberedEntities.get(id);
        }
        for (World world : Bukkit.getWorlds()) {
            net.minecraft.server.v1_8_R3.Entity nmsEntity = ((CraftWorld)world).getHandle().getEntity(id);
            if (nmsEntity == null) continue;
            return nmsEntity.getBukkitEntity();
        }
        return null;
    }

    public static boolean matches(String arg) {
        Matcher m = entity_by_id.matcher(arg);
        if (m.matches()) {
            return true;
        }
        if ((arg = arg.replace("e@", "").toUpperCase()).equals("RANDOM")) {
            return true;
        }
        if (ScriptRegistry.containsScript(arg, EntityScriptContainer.class)) {
            return true;
        }
        m = entity_with_data.matcher(arg);
        return m.matches() && DenizenEntityType.isRegistered(m.group(1));
    }

    public dEntity(Entity entity) {
        if (entity != null) {
            this.entity = entity;
            this.entityScript = EntityScriptHelper.getEntityScript(entity);
            this.uuid = entity.getUniqueId();
            this.entity_type = DenizenEntityType.getByEntity(entity);
            if (dEntity.isCitizensNPC(entity)) {
                this.npc = dEntity.getNPCFrom(entity);
            }
        } else {
            dB.echoError("Entity referenced is null!");
        }
    }

    @Deprecated
    public dEntity(EntityType entityType) {
        if (entityType != null) {
            this.entity = null;
            this.entity_type = DenizenEntityType.getByName(entityType.name());
        } else {
            dB.echoError("Entity_type referenced is null!");
        }
    }

    @Deprecated
    public dEntity(EntityType entityType, ArrayList<Mechanism> mechanisms) {
        this(entityType);
        this.mechanisms = mechanisms;
    }

    @Deprecated
    public dEntity(EntityType entityType, String data1) {
        if (entityType != null) {
            this.entity = null;
            this.entity_type = DenizenEntityType.getByName(entityType.name());
            this.data1 = data1;
        } else {
            dB.echoError("Entity_type referenced is null!");
        }
    }

    @Deprecated
    public dEntity(EntityType entityType, String data1, String data2) {
        if (entityType != null) {
            this.entity = null;
            this.entity_type = DenizenEntityType.getByName(entityType.name());
            this.data1 = data1;
            this.data2 = data2;
        } else {
            dB.echoError("Entity_type referenced is null!");
        }
    }

    public dEntity(DenizenEntityType entityType) {
        if (entityType != null) {
            this.entity = null;
            this.entity_type = entityType;
        } else {
            dB.echoError("DenizenEntityType referenced is null!");
        }
    }

    public dEntity(DenizenEntityType entityType, ArrayList<Mechanism> mechanisms) {
        this(entityType);
        this.mechanisms = mechanisms;
    }

    public dEntity(DenizenEntityType entityType, String data1) {
        if (entityType != null) {
            this.entity = null;
            this.entity_type = entityType;
            this.data1 = data1;
        } else {
            dB.echoError("DenizenEntityType referenced is null!");
        }
    }

    public dEntity(DenizenEntityType entityType, String data1, String data2) {
        if (entityType != null) {
            this.entity = null;
            this.entity_type = entityType;
            this.data1 = data1;
            this.data2 = data2;
        } else {
            dB.echoError("DenizenEntityType referenced is null!");
        }
    }

    public dEntity(dNPC npc) {
        if (Depends.citizens == null) {
            return;
        }
        if (npc != null) {
            this.npc = npc;
            if (npc.isSpawned()) {
                this.entity = npc.getEntity();
                this.entity_type = DenizenEntityType.getByName(npc.getEntityType().name());
                this.uuid = this.entity.getUniqueId();
            }
        } else {
            dB.echoError("NPC referenced is null!");
        }
    }

    public DenizenEntityType getEntityType() {
        return this.entity_type;
    }

    public EntityType getBukkitEntityType() {
        return this.entity_type.getBukkitEntityType();
    }

    public void setEntityScript(String entityScript) {
        this.entityScript = entityScript;
    }

    public String getEntityScript() {
        return this.entityScript;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public String getSaveName() {
        String baseID = this.uuid.toString().toUpperCase().replace("-", "");
        return baseID.substring(0, 2) + "." + baseID;
    }

    public dObject getDenizenObject() {
        if (this.entity == null) {
            return null;
        }
        if (this.isCitizensNPC()) {
            return this.getDenizenNPC();
        }
        if (this.isPlayer()) {
            return new dPlayer(this.getPlayer());
        }
        return this;
    }

    public Entity getBukkitEntity() {
        return this.entity;
    }

    public LivingEntity getLivingEntity() {
        if (this.entity instanceof LivingEntity) {
            return (LivingEntity)this.entity;
        }
        return null;
    }

    public boolean isLivingEntity() {
        return this.entity instanceof LivingEntity;
    }

    public boolean hasInventory() {
        return this.getBukkitEntity() instanceof InventoryHolder || this.isCitizensNPC();
    }

    public dNPC getDenizenNPC() {
        if (this.npc != null) {
            return this.npc;
        }
        return dEntity.getNPCFrom(this.entity);
    }

    public boolean isNPC() {
        return this.npc != null || dEntity.isNPC(this.entity);
    }

    public boolean isCitizensNPC() {
        return this.npc != null || dEntity.isCitizensNPC(this.entity);
    }

    public Player getPlayer() {
        if (this.isPlayer()) {
            return (Player)this.entity;
        }
        return null;
    }

    public dPlayer getDenizenPlayer() {
        if (this.isPlayer()) {
            return new dPlayer(this.getPlayer());
        }
        return null;
    }

    public boolean isPlayer() {
        return this.entity instanceof Player && !this.isNPC();
    }

    public Projectile getProjectile() {
        return (Projectile)this.entity;
    }

    public boolean isProjectile() {
        return this.entity instanceof Projectile;
    }

    public dEntity getShooter() {
        if (this.hasShooter()) {
            return new dEntity((Entity)((LivingEntity)this.getProjectile().getShooter()));
        }
        return null;
    }

    public void setShooter(dEntity shooter) {
        if (this.isProjectile() && shooter.isLivingEntity()) {
            this.getProjectile().setShooter((ProjectileSource)shooter.getLivingEntity());
        }
    }

    public boolean hasShooter() {
        return this.isProjectile() && this.getProjectile().getShooter() != null && this.getProjectile().getShooter() instanceof LivingEntity;
    }

    public Inventory getBukkitInventory() {
        if (this.hasInventory() && !this.isCitizensNPC()) {
            return ((InventoryHolder)this.getBukkitEntity()).getInventory();
        }
        return null;
    }

    public dInventory getInventory() {
        return this.hasInventory() ? (this.isCitizensNPC() ? this.getDenizenNPC().getDenizenInventory() : new dInventory(this.getBukkitInventory())) : null;
    }

    public String getName() {
        if (this.isCitizensNPC()) {
            return this.getDenizenNPC().getCitizen().getName();
        }
        if (this.entity instanceof CraftFakePlayer) {
            return ((CraftFakePlayer)this.entity).getFullName();
        }
        if (this.entity instanceof Player) {
            return ((Player)this.entity).getName();
        }
        String customName = this.entity.getCustomName();
        if (customName != null) {
            return customName;
        }
        return this.entity_type.getName();
    }

    public dList getEquipment() {
        if (this.isCitizensNPC() || this.isPlayer()) {
            return this.getInventory().getEquipment();
        }
        ItemStack[] equipment = this.getLivingEntity().getEquipment().getArmorContents();
        dList equipmentList = new dList();
        for (ItemStack item : equipment) {
            equipmentList.add(new dItem(item).identify());
        }
        return equipmentList;
    }

    public boolean isGeneric() {
        return !this.isUnique();
    }

    public dLocation getLocation() {
        if (this.isUnique() && this.entity != null) {
            return new dLocation(this.entity.getLocation());
        }
        return null;
    }

    public dLocation getEyeLocation() {
        if (this.isPlayer()) {
            return new dLocation(this.getPlayer().getEyeLocation());
        }
        if (!this.isGeneric() && this.isLivingEntity()) {
            return new dLocation(this.getLivingEntity().getEyeLocation());
        }
        if (!this.isGeneric()) {
            return new dLocation(this.getBukkitEntity().getLocation());
        }
        return null;
    }

    public Vector getVelocity() {
        if (!this.isGeneric()) {
            return this.entity.getVelocity();
        }
        return null;
    }

    public void setVelocity(Vector vector) {
        if (!this.isGeneric()) {
            if (this.entity instanceof WitherSkull) {
                ((WitherSkull)this.entity).setDirection(vector);
            } else {
                this.entity.setVelocity(vector);
            }
        }
    }

    public World getWorld() {
        if (!this.isGeneric()) {
            return this.entity.getWorld();
        }
        return null;
    }

    public void spawnAt(Location location) {
        if (this.isCitizensNPC()) {
            if (this.getDenizenNPC().getCitizen().isSpawned()) {
                this.getDenizenNPC().getCitizen().teleport(location, PlayerTeleportEvent.TeleportCause.PLUGIN);
            } else {
                this.getDenizenNPC().getCitizen().spawn(location);
                this.entity = this.getDenizenNPC().getCitizen().getEntity();
                this.uuid = this.getDenizenNPC().getCitizen().getEntity().getUniqueId();
            }
        } else if (this.entity != null && this.isUnique()) {
            this.entity.teleport(location);
        } else {
            if (this.entity_type != null) {
                if (this.despawned_entity != null) {
                    if (this.despawned_entity.custom_script == null) {
                        this.entity = this.entity_type.spawnNewEntity(location, this.mechanisms);
                    }
                    this.getLivingEntity().teleport(location);
                    this.getLivingEntity().getEquipment().setArmorContents(this.despawned_entity.equipment);
                    this.getLivingEntity().setHealth(this.despawned_entity.health.doubleValue());
                    this.despawned_entity = null;
                } else {
                    Entity ent = null;
                    if (this.entity_type.getName().equals("PLAYER")) {
                        if (Depends.citizens == null) {
                            dB.echoError("Cannot spawn entity of type PLAYER!");
                            return;
                        }
                        dNPC npc = new dNPC(CitizensAPI.getNPCRegistry().createNPC(EntityType.PLAYER, this.data1));
                        npc.getCitizen().spawn(location);
                        this.entity = npc.getEntity();
                        this.uuid = this.entity.getUniqueId();
                    } else if (this.entity_type.getName().equals("FALLING_BLOCK")) {
                        Material material = null;
                        if (this.data1 != null && dMaterial.matches(this.data1)) {
                            material = dMaterial.valueOf(this.data1).getMaterial();
                            while (this.data1.equalsIgnoreCase("RANDOM") && (!material.isBlock() || material == Material.AIR || material == Material.PORTAL || material == Material.ENDER_PORTAL)) {
                                material = dMaterial.valueOf(this.data1).getMaterial();
                            }
                        }
                        if (material == null || !material.isBlock()) {
                            material = Material.SAND;
                        }
                        byte materialData = 0;
                        if (this.data2 != null && aH.matchesInteger(this.data2)) {
                            materialData = (byte)aH.getIntegerFrom(this.data2);
                        }
                        this.entity = ent = location.getWorld().spawnFallingBlock(location, material, materialData);
                        this.uuid = this.entity.getUniqueId();
                    } else {
                        this.entity = ent = this.entity_type.spawnNewEntity(location, this.mechanisms);
                        if (this.entity == null) {
                            return;
                        }
                        this.uuid = this.entity.getUniqueId();
                        if (this.entityScript != null) {
                            EntityScriptHelper.setEntityScript(this.entity, this.entityScript);
                        }
                        if (this.entity_type.getName().equals("PIG_ZOMBIE")) {
                            if (!dItem.matches(this.data1)) {
                                this.data1 = "gold_sword";
                            }
                            ((PigZombie)this.entity).getEquipment().setItemInHand(dItem.valueOf(this.data1).getItemStack());
                        } else if (this.entity_type.getName().equals("SKELETON")) {
                            if (!dItem.matches(this.data2)) {
                                this.data2 = "bow";
                            }
                            ((Skeleton)this.entity).getEquipment().setItemInHand(dItem.valueOf(this.data2).getItemStack());
                        }
                        if (this.data1 != null) {
                            try {
                                if (ent instanceof Creeper && this.data1.equalsIgnoreCase("POWERED")) {
                                    ((Creeper)this.entity).setPowered(true);
                                } else if (ent instanceof Enderman && dMaterial.matches(this.data1)) {
                                    ((Enderman)this.entity).setCarriedMaterial(dMaterial.valueOf(this.data1).getMaterialData());
                                } else if (ent instanceof Horse) {
                                    this.setSubtype("org.bukkit.entity.Horse", "org.bukkit.entity.Horse$Variant", "setVariant", this.data1);
                                    if (this.data2 != null) {
                                        this.setSubtype("org.bukkit.entity.Horse", "org.bukkit.entity.Horse$Color", "setColor", this.data2);
                                    }
                                } else if (ent instanceof Ocelot) {
                                    this.setSubtype("org.bukkit.entity.Ocelot", "org.bukkit.entity.Ocelot$Type", "setCatType", this.data1);
                                } else if (ent instanceof Sheep) {
                                    this.setSubtype("org.bukkit.entity.Sheep", "org.bukkit.DyeColor", "setColor", this.data1);
                                } else if (ent instanceof Skeleton) {
                                    this.setSubtype("org.bukkit.entity.Skeleton", "org.bukkit.entity.Skeleton$SkeletonType", "setSkeletonType", this.data1);
                                } else if (ent instanceof Slime && aH.matchesInteger(this.data1)) {
                                    ((Slime)this.entity).setSize(aH.getIntegerFrom(this.data1));
                                } else if (ent instanceof Villager) {
                                    this.setSubtype("org.bukkit.entity.Villager", "org.bukkit.entity.Villager$Profession", "setProfession", this.data1);
                                }
                            }
                            catch (Exception e) {
                                dB.echoError("Error setting custom entity data.");
                                dB.echoError(e);
                            }
                        }
                    }
                }
            } else {
                dB.echoError("Cannot spawn a null dEntity!");
            }
            if (!this.isUnique()) {
                dB.echoError("Error spawning entity - bad entity type, blocked by another plugin, or tried to spawn in an unloaded chunk?");
                return;
            }
            for (Mechanism mechanism : this.mechanisms) {
                this.adjust(mechanism);
            }
            this.mechanisms.clear();
        }
    }

    public void despawn() {
        this.despawned_entity = new DespawnedEntity(this);
        this.getLivingEntity().remove();
    }

    public void respawn() {
        if (this.despawned_entity != null) {
            this.spawnAt(this.despawned_entity.location);
        } else if (this.entity == null) {
            dB.echoError("Cannot respawn a null dEntity!");
        }
    }

    public boolean isSpawned() {
        return this.entity != null && this.isValid();
    }

    public boolean isValid() {
        return this.entity != null && this.entity.isValid();
    }

    public void remove() {
        EntityScriptHelper.unlinkEntity(this.entity);
        this.entity.remove();
    }

    public void teleport(Location location) {
        if (this.isCitizensNPC()) {
            this.getDenizenNPC().getCitizen().teleport(location, PlayerTeleportEvent.TeleportCause.PLUGIN);
        } else {
            this.entity.teleport(location);
        }
    }

    public void target(LivingEntity target) {
        if (!this.isSpawned() || !(this.entity instanceof Creature)) {
            dB.echoError(this.identify() + " is not a valid creature entity!");
            return;
        }
        EntityLiving nmsTarget = target != null ? ((CraftLivingEntity)target).getHandle() : null;
        ((CraftCreature)this.entity).getHandle().setGoalTarget(nmsTarget, EntityTargetEvent.TargetReason.CUSTOM, true);
        ((CraftCreature)this.entity).setTarget(target);
    }

    public void setSubtype(String entityName, String typeName, String method, String value) throws Exception {
        Class<?> entityClass = Class.forName(entityName);
        Class<?> typeClass = Class.forName(typeName);
        ?[] types = typeClass.getEnumConstants();
        if (value.equalsIgnoreCase("RANDOM")) {
            entityClass.getMethod(method, typeClass).invoke((Object)this.entity, types[CoreUtilities.getRandom().nextInt(types.length)]);
        } else {
            for (Object type : types) {
                if (!type.toString().equalsIgnoreCase(value)) continue;
                entityClass.getMethod(method, typeClass).invoke((Object)this.entity, type);
                break;
            }
        }
    }

    public void setEntity(Entity entity) {
        this.entity = entity;
    }

    public int comparesTo(dEntity entity) {
        if (entity == null) {
            return 0;
        }
        if (entity.isUnique() && entity.identify().equals(this.identify())) {
            return 1;
        }
        if (!entity.isUnique()) {
            if (!this.isUnique() && entity.identify().equals(this.identify())) {
                return 1;
            }
            if (this.entity_type == entity.entity_type) {
                return 1;
            }
        }
        return 0;
    }

    @Override
    public String getObjectType() {
        return "Entity";
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public dEntity setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    @Override
    public String debug() {
        return "<G>" + this.prefix + "='<Y>" + this.identify() + "<G>'  ";
    }

    @Override
    public String identify() {
        if (this.npc != null) {
            return "n@" + this.npc.getId();
        }
        if (this.entity != null) {
            if (this.isPlayer()) {
                return "p@" + this.getPlayer().getUniqueId();
            }
            if (this.isSpawned() || rememberedEntities.containsKey(this.entity.getUniqueId())) {
                return "e@" + this.entity.getUniqueId().toString();
            }
        }
        if (this.entityScript != null) {
            return "e@" + this.entityScript;
        }
        if (this.entity_type != null) {
            StringBuilder properties = new StringBuilder();
            for (Mechanism mechanism : this.mechanisms) {
                properties.append(mechanism.getName()).append("=").append(mechanism.getValue().asString().replace(';', '\u2011')).append(";");
            }
            String propertyOutput = "";
            if (properties.length() > 0) {
                propertyOutput = "[" + properties.substring(0, properties.length() - 1) + "]";
            }
            return "e@" + this.entity_type.getLowercaseName() + propertyOutput;
        }
        return "null";
    }

    @Override
    public String identifySimple() {
        if (this.npc != null && this.npc.isValid()) {
            return "n@" + this.npc.getId();
        }
        if (this.isPlayer()) {
            return "p@" + this.getPlayer().getName();
        }
        if (this.entityScript != null) {
            return "e@" + this.entityScript;
        }
        if (this.entity_type != null) {
            return "e@" + this.entity_type.getLowercaseName();
        }
        return "null";
    }

    public String identifyType() {
        if (this.isCitizensNPC()) {
            return "npc";
        }
        if (this.isPlayer()) {
            return "player";
        }
        return "e@" + this.entity_type.getName();
    }

    public String identifySimpleType() {
        if (this.isCitizensNPC()) {
            return "npc";
        }
        if (this.isPlayer()) {
            return "player";
        }
        return this.entity_type.getLowercaseName();
    }

    public String toString() {
        return this.identify();
    }

    @Override
    public boolean isUnique() {
        return this.isPlayer() || this.isCitizensNPC() || this.isSpawned() || this.entity != null && rememberedEntities.containsKey(this.entity.getUniqueId());
    }

    public boolean matchesEntity(String ent) {
        if (ent.equalsIgnoreCase("npc")) {
            return this.isCitizensNPC();
        }
        if (ent.equalsIgnoreCase("entity")) {
            return true;
        }
        if (ent.equalsIgnoreCase("player")) {
            return this.isPlayer();
        }
        if (ent.equalsIgnoreCase("vehicle")) {
            return this.entity instanceof Vehicle;
        }
        if (ent.equalsIgnoreCase("projectile")) {
            return this.entity instanceof Projectile;
        }
        if (ent.equalsIgnoreCase("hanging")) {
            return this.entity instanceof Hanging;
        }
        if (ent.equalsIgnoreCase(this.getName())) {
            return true;
        }
        if (ent.equalsIgnoreCase(this.entity_type.getLowercaseName())) {
            return true;
        }
        if (this.entity != null && this.getEntityScript() != null) {
            return ent.equalsIgnoreCase(this.getEntityScript());
        }
        return this.uuid != null && this.uuid.toString().equals(ent);
    }

    @Override
    public String getAttribute(Attribute attribute) {
        dEntity toEntity;
        Rotation.MapTraceResult mtr;
        if (attribute == null) {
            return null;
        }
        if (this.entity == null && this.entity_type == null) {
            if (this.npc != null) {
                return new Element(this.identify()).getAttribute(attribute);
            }
            dB.echoError("dEntity has returned null.");
            return null;
        }
        if (attribute.startsWith("debug.log")) {
            dB.log(this.debug());
            return new Element(Boolean.TRUE.toString()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("debug.no_color")) {
            return new Element(ChatColor.stripColor((String)this.debug())).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("debug")) {
            return new Element(this.debug()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("prefix")) {
            return new Element(this.prefix).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("type")) {
            return new Element("Entity").getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("entity_type")) {
            return new Element(this.entity_type.getName()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("is_spawned")) {
            return new Element(this.isSpawned()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("eid")) {
            return new Element(this.entity.getEntityId()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("uuid")) {
            return new Element(this.getUUID().toString()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("script")) {
            return new Element(this.entityScript == null ? "null" : this.entityScript).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("has_flag")) {
            if (!attribute.hasContext(1)) {
                return null;
            }
            String flag_name = attribute.getContext(1);
            if (this.isPlayer() || this.isCitizensNPC()) {
                dB.echoError("Reading flag for PLAYER or NPC as if it were an ENTITY!");
                return null;
            }
            return new Element(FlagManager.entityHasFlag(this, flag_name)).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("flag")) {
            if (!attribute.hasContext(1)) {
                return null;
            }
            String flag_name = attribute.getContext(1);
            if (this.isPlayer() || this.isCitizensNPC()) {
                dB.echoError("Reading flag for PLAYER or NPC as if it were an ENTITY!");
                return null;
            }
            if (attribute.getAttribute(2).equalsIgnoreCase("is_expired") || attribute.startsWith("isexpired")) {
                return new Element(!FlagManager.entityHasFlag(this, flag_name)).getAttribute(attribute.fulfill(2));
            }
            if (attribute.getAttribute(2).equalsIgnoreCase("size") && !FlagManager.entityHasFlag(this, flag_name)) {
                return new Element(0).getAttribute(attribute.fulfill(2));
            }
            if (FlagManager.entityHasFlag(this, flag_name)) {
                FlagManager.Flag flag = DenizenAPI.getCurrentInstance().flagManager().getEntityFlag(this, flag_name);
                return new dList(flag.toString(), true, flag.values()).getAttribute(attribute.fulfill(1));
            }
            return new Element(this.identify()).getAttribute(attribute);
        }
        if (attribute.startsWith("list_flags")) {
            dList allFlags = new dList(DenizenAPI.getCurrentInstance().flagManager().listEntityFlags(this));
            dList searchFlags = null;
            if (!allFlags.isEmpty() && attribute.hasContext(1)) {
                searchFlags = new dList();
                String search = attribute.getContext(1);
                if (search.startsWith("regex:")) {
                    try {
                        Pattern pattern = Pattern.compile(search.substring(6), 2);
                        for (String flag : allFlags) {
                            if (!pattern.matcher(flag).matches()) continue;
                            searchFlags.add(flag);
                        }
                    }
                    catch (Exception e) {
                        dB.echoError(e);
                    }
                } else {
                    search = CoreUtilities.toLowerCase(search);
                    for (String flag : allFlags) {
                        if (!flag.toLowerCase().contains(search)) continue;
                        searchFlags.add(flag);
                    }
                }
            }
            return searchFlags == null ? allFlags.getAttribute(attribute.fulfill(1)) : searchFlags.getAttribute(attribute.fulfill(1));
        }
        if (this.entity == null) {
            return new Element(this.identify()).getAttribute(attribute);
        }
        if (attribute.startsWith("custom_id")) {
            if (CustomNBT.hasCustomNBT(this.getLivingEntity(), "denizen-script-id")) {
                return new dScript(CustomNBT.getCustomNBT(this.getLivingEntity(), "denizen-script-id")).getAttribute(attribute.fulfill(1));
            }
            return new Element(this.entity.getType().name()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("name")) {
            return new Element(this.getName()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("saddle")) {
            if (this.getLivingEntity().getType() == EntityType.HORSE) {
                return new dItem(((Horse)this.getLivingEntity()).getInventory().getSaddle()).getAttribute(attribute.fulfill(1));
            }
            if (this.getLivingEntity().getType() == EntityType.PIG) {
                return new dItem(((Pig)this.getLivingEntity()).hasSaddle() ? Material.SADDLE : Material.AIR).getAttribute(attribute.fulfill(1));
            }
        }
        if ((attribute.startsWith("horse_armor") || attribute.startsWith("horse_armour")) && this.getLivingEntity().getType() == EntityType.HORSE) {
            return new dItem(((Horse)this.getLivingEntity()).getInventory().getArmor()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("has_saddle")) {
            if (this.getLivingEntity().getType() == EntityType.HORSE) {
                return new Element(((Horse)this.getLivingEntity()).getInventory().getSaddle().getType() == Material.SADDLE).getAttribute(attribute.fulfill(1));
            }
            if (this.getLivingEntity().getType() == EntityType.PIG) {
                return new Element(((Pig)this.getLivingEntity()).hasSaddle()).getAttribute(attribute.fulfill(1));
            }
        }
        if (attribute.startsWith("item_in_hand") || attribute.startsWith("iteminhand")) {
            return new dItem(this.getLivingEntity().getEquipment().getItemInHand()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("map_trace") && (mtr = Rotation.mapTrace(this.getLivingEntity(), 200.0)) != null) {
            double x = 0.0;
            double y = 0.0;
            double basex = mtr.hitLocation.getX() - Math.floor(mtr.hitLocation.getX());
            double basey = mtr.hitLocation.getY() - Math.floor(mtr.hitLocation.getY());
            double basez = mtr.hitLocation.getZ() - Math.floor(mtr.hitLocation.getZ());
            if (mtr.angle == BlockFace.NORTH) {
                x = 128.0 - basex * 128.0;
            } else if (mtr.angle == BlockFace.SOUTH) {
                x = basex * 128.0;
            } else if (mtr.angle == BlockFace.WEST) {
                x = basez * 128.0;
            } else if (mtr.angle == BlockFace.EAST) {
                x = 128.0 - basez * 128.0;
            }
            y = 128.0 - basey * 128.0;
            return new dLocation(null, Math.round(x), Math.round(y)).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("can_see") && this.isLivingEntity() && attribute.hasContext(1) && dEntity.matches(attribute.getContext(1)) && (toEntity = dEntity.valueOf(attribute.getContext(1))) != null && toEntity.isSpawned()) {
            return new Element(this.getLivingEntity().hasLineOfSight(toEntity.getBukkitEntity())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("eye_location")) {
            return new dLocation(this.getEyeLocation()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("eye_height") && this.isLivingEntity()) {
            return new Element(this.getLivingEntity().getEyeHeight()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("location.cursor_on")) {
            int range = attribute.getIntContext(2);
            if (range < 1) {
                range = 50;
            }
            HashSet<Material> set = new HashSet<Material>();
            set.add(Material.AIR);
            attribute = attribute.fulfill(2);
            if (attribute.startsWith("ignore") && attribute.hasContext(1)) {
                List<dMaterial> ignoreList = dList.valueOf(attribute.getContext(1)).filter(dMaterial.class);
                for (dMaterial material : ignoreList) {
                    set.add(material.getMaterial());
                }
                attribute = attribute.fulfill(1);
            }
            return new dLocation(this.getLivingEntity().getTargetBlock(set, range).getLocation()).getAttribute(attribute);
        }
        if (attribute.startsWith("location.standing_on")) {
            return new dLocation(this.entity.getLocation().clone().add(0.0, -0.5, 0.0)).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("location")) {
            return new dLocation(this.entity.getLocation()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("velocity")) {
            return new dLocation(this.entity.getVelocity().toLocation(this.entity.getWorld())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("world")) {
            return new dWorld(this.entity.getWorld()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("can_pickup_items") && this.isLivingEntity()) {
            return new Element(this.getLivingEntity().getCanPickupItems()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("fallingblock_material")) {
            return dMaterial.getMaterialFrom(((FallingBlock)this.entity).getMaterial()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("fall_distance")) {
            return new Element(this.entity.getFallDistance()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("fire_time")) {
            return new Duration(this.entity.getFireTicks() / 20).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("on_fire")) {
            return new Element(this.entity.getFireTicks() > 0).getAttribute(attribute.fulfill(1));
        }
        if ((attribute.startsWith("leash_holder") || attribute.startsWith("get_leash_holder")) && this.isLivingEntity() && this.getLivingEntity().isLeashed()) {
            return new dEntity(this.getLivingEntity().getLeashHolder()).getAttribute(attribute.fulfill(1));
        }
        if ((attribute.startsWith("passenger") || attribute.startsWith("get_passenger")) && !this.entity.isEmpty()) {
            return new dEntity(this.entity.getPassenger()).getAttribute(attribute.fulfill(1));
        }
        if ((attribute.startsWith("shooter") || attribute.startsWith("get_shooter")) && this.isProjectile() && this.hasShooter()) {
            return this.getShooter().getAttribute(attribute.fulfill(1));
        }
        if ((attribute.startsWith("vehicle") || attribute.startsWith("get_vehicle")) && this.entity.isInsideVehicle()) {
            return new dEntity(this.entity.getVehicle()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("has_effect")) {
            boolean returnElement = false;
            if (attribute.hasContext(1)) {
                PotionEffectType effectType = PotionEffectType.getByName((String)attribute.getContext(1));
                for (PotionEffect effect : this.getLivingEntity().getActivePotionEffects()) {
                    if (!effect.getType().equals((Object)effectType)) continue;
                    returnElement = true;
                }
            } else if (!this.getLivingEntity().getActivePotionEffects().isEmpty()) {
                returnElement = true;
            }
            return new Element(returnElement).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("list_effects")) {
            dList effects = new dList();
            for (PotionEffect effect : this.getLivingEntity().getActivePotionEffects()) {
                effects.add(effect.getType().getName() + "," + effect.getAmplifier() + "," + effect.getDuration() + "t");
            }
            return effects.getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("can_breed")) {
            return new Element(((Ageable)this.getLivingEntity()).canBreed()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("breeding") || attribute.startsWith("is_breeding")) {
            return new Element(((CraftAnimals)this.getLivingEntity()).getHandle().ce()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("has_passenger")) {
            return new Element(!this.entity.isEmpty()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("empty") || attribute.startsWith("is_empty")) {
            return new Element(this.entity.isEmpty()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("inside_vehicle") || attribute.startsWith("is_inside_vehicle")) {
            return new Element(this.entity.isInsideVehicle()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("leashed") || attribute.startsWith("is_leashed")) {
            if (this.isLivingEntity()) {
                return new Element(this.getLivingEntity().isLeashed()).getAttribute(attribute.fulfill(1));
            }
            return Element.FALSE.getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("on_ground") || attribute.startsWith("is_on_ground")) {
            return new Element(this.entity.isOnGround()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("persistent") || attribute.startsWith("is_persistent")) {
            if (this.isLivingEntity()) {
                return new Element(!this.getLivingEntity().getRemoveWhenFarAway()).getAttribute(attribute.fulfill(1));
            }
            return Element.FALSE.getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("killer")) {
            return dEntity.getPlayerFrom((Entity)this.getLivingEntity().getKiller()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("last_damage.amount")) {
            return new Element(this.getLivingEntity().getLastDamage()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("last_damage.cause") && this.entity.getLastDamageCause() != null) {
            return new Element(this.entity.getLastDamageCause().getCause().name()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("last_damage.duration")) {
            return new Duration((long)this.getLivingEntity().getNoDamageTicks()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("oxygen.max")) {
            return new Duration((long)this.getLivingEntity().getMaximumAir()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("oxygen")) {
            return new Duration((long)this.getLivingEntity().getRemainingAir()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("remove_when_far")) {
            return new Element(this.getLivingEntity().getRemoveWhenFarAway()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("target")) {
            dEntity target;
            if (this.getBukkitEntity() instanceof Creature && (target = new dEntity((Entity)((Creature)this.getLivingEntity()).getTarget())) != null) {
                return target.getAttribute(attribute.fulfill(1));
            }
            return null;
        }
        if (attribute.startsWith("time_lived")) {
            return new Duration(this.entity.getTicksLived() / 20).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("is_living")) {
            return new Element(this.isLivingEntity()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("is_mob")) {
            if (!this.isPlayer() && !this.isNPC()) {
                return Element.TRUE.getAttribute(attribute.fulfill(1));
            }
            return Element.FALSE.getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("is_npc")) {
            return new Element(this.isCitizensNPC()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("is_player")) {
            return new Element(this.isPlayer()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("is_projectile")) {
            return new Element(this.isProjectile()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("tameable") || attribute.startsWith("is_tameable")) {
            return new Element(EntityTame.describes(this)).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("ageable") || attribute.startsWith("is_ageable")) {
            return new Element(EntityAge.describes(this)).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("colorable") || attribute.startsWith("is_colorable")) {
            return new Element(EntityColor.describes(this)).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("describe")) {
            String escript = this.getEntityScript();
            return new Element("e@" + (escript != null && escript.length() > 0 ? escript : this.getEntityType().getLowercaseName()) + PropertyParser.getPropertiesString(this)).getAttribute(attribute.fulfill(1));
        }
        for (Property property : PropertyParser.getProperties(this)) {
            String returned = property.getAttribute(attribute);
            if (returned == null) continue;
            return returned;
        }
        return new Element(this.identify()).getAttribute(attribute);
    }

    public ArrayList<Mechanism> getWaitingMechanisms() {
        return this.mechanisms;
    }

    @Override
    public void applyProperty(Mechanism mechanism) {
        if (this.isGeneric()) {
            this.mechanisms.add(mechanism);
        } else if (rememberedEntities.containsKey(this.entity.getUniqueId())) {
            this.adjust(mechanism);
        } else {
            dB.echoError("Cannot apply properties to an already-spawned entity!");
        }
    }

    @Override
    public void adjust(Mechanism mechanism) {
        dList list;
        if (this.isGeneric()) {
            this.mechanisms.add(mechanism);
            return;
        }
        Element value = mechanism.getValue();
        if (mechanism.matches("can_pickup_items") && mechanism.requireBoolean()) {
            this.getLivingEntity().setCanPickupItems(value.asBoolean());
        }
        if (mechanism.matches("fall_distance") && mechanism.requireFloat()) {
            this.entity.setFallDistance(value.asFloat());
        }
        if (mechanism.matches("fire_time") && mechanism.requireObject(Duration.class)) {
            this.entity.setFireTicks(value.asType(Duration.class).getTicksAsInt());
        }
        if (mechanism.matches("leash_holder") && mechanism.requireObject(dEntity.class)) {
            this.getLivingEntity().setLeashHolder(value.asType(dEntity.class).getBukkitEntity());
        }
        if (mechanism.matches("can_breed") && mechanism.requireBoolean()) {
            ((Ageable)this.getLivingEntity()).setBreed(true);
        }
        if (mechanism.matches("breed") && (list = dList.valueOf(value.asString())).size() > 1) {
            if (((String)list.get(0)).equalsIgnoreCase("true")) {
                ((CraftAnimals)this.getLivingEntity()).getHandle().a((EntityHuman)null);
            } else {
                ((CraftAnimals)this.getLivingEntity()).getHandle().cq();
            }
        }
        if (mechanism.matches("passenger") && mechanism.requireObject(dEntity.class)) {
            this.entity.setPassenger(value.asType(dEntity.class).getBukkitEntity());
        }
        if (mechanism.matches("time_lived") && mechanism.requireObject(Duration.class)) {
            this.entity.setTicksLived(value.asType(Duration.class).getTicksAsInt());
        }
        if (mechanism.matches("remaining_air") && mechanism.requireInteger()) {
            this.getLivingEntity().setRemainingAir(value.asInt());
        }
        if (mechanism.matches("remove_effects")) {
            for (PotionEffect potionEffect : this.getLivingEntity().getActivePotionEffects()) {
                this.getLivingEntity().removePotionEffect(potionEffect.getType());
            }
        }
        if (mechanism.matches("remove_when_far_away") && mechanism.requireBoolean()) {
            this.getLivingEntity().setRemoveWhenFarAway(value.asBoolean());
        }
        if (mechanism.matches("velocity") && mechanism.requireObject(dLocation.class)) {
            this.setVelocity(value.asType(dLocation.class).toVector());
        }
        if (mechanism.matches("interact_with") && mechanism.requireObject(dLocation.class)) {
            dLocation interactLocation = value.asType(dLocation.class);
            CraftPlayer craftPlayer = (CraftPlayer)this.getPlayer();
            BlockPosition pos = new BlockPosition(interactLocation.getBlockX(), interactLocation.getBlockY(), interactLocation.getBlockZ());
            Block.getById((int)interactLocation.getBlock().getType().getId()).interact((net.minecraft.server.v1_8_R3.World)((CraftWorld)interactLocation.getWorld()).getHandle(), pos, ((CraftWorld)interactLocation.getWorld()).getHandle().getType(pos), (EntityHuman)(craftPlayer != null ? craftPlayer.getHandle() : null), EnumDirection.NORTH, 0.0f, 0.0f, 0.0f);
        }
        if (mechanism.matches("play_death")) {
            this.getLivingEntity().playEffect(EntityEffect.DEATH);
        }
        for (Property property : PropertyParser.getProperties(this)) {
            property.adjust(mechanism);
            if (!mechanism.fulfilled()) continue;
            break;
        }
        if (!mechanism.fulfilled()) {
            mechanism.reportInvalid();
        }
    }

    private class DespawnedEntity {
        Double health = null;
        Location location = null;
        ItemStack[] equipment = null;
        String custom_script = null;

        public DespawnedEntity(dEntity entity) {
            if (entity != null) {
                this.health = entity.getLivingEntity().getHealth();
                this.location = entity.getLivingEntity().getLocation();
                this.equipment = entity.getLivingEntity().getEquipment().getArmorContents();
                if (CustomNBT.hasCustomNBT(entity.getLivingEntity(), "denizen-script-id")) {
                    this.custom_script = CustomNBT.getCustomNBT(entity.getLivingEntity(), "denizen-script-id");
                }
            }
        }
    }
}

